/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.keymanagement.model;

/**
 * An object which encapsulates the details of a given HSM. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: release")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = HsmPartitionSummary.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class HsmPartitionSummary
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "id",
        "hsmClusterId",
        "lifecycleState",
        "compartmentId",
        "portInformation",
        "timeCreated",
        "timeUpdated"
    })
    public HsmPartitionSummary(
            String id,
            String hsmClusterId,
            HsmPartition.LifecycleState lifecycleState,
            String compartmentId,
            java.util.List<PortInformation> portInformation,
            java.util.Date timeCreated,
            java.util.Date timeUpdated) {
        super();
        this.id = id;
        this.hsmClusterId = hsmClusterId;
        this.lifecycleState = lifecycleState;
        this.compartmentId = compartmentId;
        this.portInformation = portInformation;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /** The OCID of the HSM resource. Each HSM resource will have a unique OCID identifier. */
        @com.fasterxml.jackson.annotation.JsonProperty("id")
        private String id;

        /**
         * The OCID of the HSM resource. Each HSM resource will have a unique OCID identifier.
         *
         * @param id the value to set
         * @return this builder
         */
        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }
        /** The OCID of the HSMCluster that contains a particular HSM resource. */
        @com.fasterxml.jackson.annotation.JsonProperty("hsmClusterId")
        private String hsmClusterId;

        /**
         * The OCID of the HSMCluster that contains a particular HSM resource.
         *
         * @param hsmClusterId the value to set
         * @return this builder
         */
        public Builder hsmClusterId(String hsmClusterId) {
            this.hsmClusterId = hsmClusterId;
            this.__explicitlySet__.add("hsmClusterId");
            return this;
        }
        /**
         * A HSMCluster resource's current lifecycle state.
         *
         * <p>Example: {@code ACTIVE}
         */
        @com.fasterxml.jackson.annotation.JsonProperty("lifecycleState")
        private HsmPartition.LifecycleState lifecycleState;

        /**
         * A HSMCluster resource's current lifecycle state.
         *
         * <p>Example: {@code ACTIVE}
         *
         * @param lifecycleState the value to set
         * @return this builder
         */
        public Builder lifecycleState(HsmPartition.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }
        /** The OCID of the compartment that contains a particular HSM resource. */
        @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
        private String compartmentId;

        /**
         * The OCID of the compartment that contains a particular HSM resource.
         *
         * @param compartmentId the value to set
         * @return this builder
         */
        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }
        /**
         * Details of a single portInformation item include the PortNumber (an integer used as an
         * identifier) and the PortType (refers to either an enum value of
         * Managementutility,Clientutility, or null)
         */
        @com.fasterxml.jackson.annotation.JsonProperty("portInformation")
        private java.util.List<PortInformation> portInformation;

        /**
         * Details of a single portInformation item include the PortNumber (an integer used as an
         * identifier) and the PortType (refers to either an enum value of
         * Managementutility,Clientutility, or null)
         *
         * @param portInformation the value to set
         * @return this builder
         */
        public Builder portInformation(java.util.List<PortInformation> portInformation) {
            this.portInformation = portInformation;
            this.__explicitlySet__.add("portInformation");
            return this;
        }
        /**
         * The date and time an HSM was created, expressed in [RFC
         * 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
         *
         * <p>Example: {@code 2018-04-03T21:10:29.600Z}
         */
        @com.fasterxml.jackson.annotation.JsonProperty("timeCreated")
        private java.util.Date timeCreated;

        /**
         * The date and time an HSM was created, expressed in [RFC
         * 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
         *
         * <p>Example: {@code 2018-04-03T21:10:29.600Z}
         *
         * @param timeCreated the value to set
         * @return this builder
         */
        public Builder timeCreated(java.util.Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }
        /**
         * The date and time an HSM was updated, expressed in [RFC
         * 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
         *
         * <p>Example: {@code 2018-04-03T21:10:29.600Z}
         */
        @com.fasterxml.jackson.annotation.JsonProperty("timeUpdated")
        private java.util.Date timeUpdated;

        /**
         * The date and time an HSM was updated, expressed in [RFC
         * 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
         *
         * <p>Example: {@code 2018-04-03T21:10:29.600Z}
         *
         * @param timeUpdated the value to set
         * @return this builder
         */
        public Builder timeUpdated(java.util.Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public HsmPartitionSummary build() {
            HsmPartitionSummary model =
                    new HsmPartitionSummary(
                            this.id,
                            this.hsmClusterId,
                            this.lifecycleState,
                            this.compartmentId,
                            this.portInformation,
                            this.timeCreated,
                            this.timeUpdated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(HsmPartitionSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("hsmClusterId")) {
                this.hsmClusterId(model.getHsmClusterId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("portInformation")) {
                this.portInformation(model.getPortInformation());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /** The OCID of the HSM resource. Each HSM resource will have a unique OCID identifier. */
    @com.fasterxml.jackson.annotation.JsonProperty("id")
    private final String id;

    /**
     * The OCID of the HSM resource. Each HSM resource will have a unique OCID identifier.
     *
     * @return the value
     */
    public String getId() {
        return id;
    }

    /** The OCID of the HSMCluster that contains a particular HSM resource. */
    @com.fasterxml.jackson.annotation.JsonProperty("hsmClusterId")
    private final String hsmClusterId;

    /**
     * The OCID of the HSMCluster that contains a particular HSM resource.
     *
     * @return the value
     */
    public String getHsmClusterId() {
        return hsmClusterId;
    }

    /**
     * A HSMCluster resource's current lifecycle state.
     *
     * <p>Example: {@code ACTIVE}
     */
    @com.fasterxml.jackson.annotation.JsonProperty("lifecycleState")
    private final HsmPartition.LifecycleState lifecycleState;

    /**
     * A HSMCluster resource's current lifecycle state.
     *
     * <p>Example: {@code ACTIVE}
     *
     * @return the value
     */
    public HsmPartition.LifecycleState getLifecycleState() {
        return lifecycleState;
    }

    /** The OCID of the compartment that contains a particular HSM resource. */
    @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
    private final String compartmentId;

    /**
     * The OCID of the compartment that contains a particular HSM resource.
     *
     * @return the value
     */
    public String getCompartmentId() {
        return compartmentId;
    }

    /**
     * Details of a single portInformation item include the PortNumber (an integer used as an
     * identifier) and the PortType (refers to either an enum value of
     * Managementutility,Clientutility, or null)
     */
    @com.fasterxml.jackson.annotation.JsonProperty("portInformation")
    private final java.util.List<PortInformation> portInformation;

    /**
     * Details of a single portInformation item include the PortNumber (an integer used as an
     * identifier) and the PortType (refers to either an enum value of
     * Managementutility,Clientutility, or null)
     *
     * @return the value
     */
    public java.util.List<PortInformation> getPortInformation() {
        return portInformation;
    }

    /**
     * The date and time an HSM was created, expressed in [RFC
     * 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
     *
     * <p>Example: {@code 2018-04-03T21:10:29.600Z}
     */
    @com.fasterxml.jackson.annotation.JsonProperty("timeCreated")
    private final java.util.Date timeCreated;

    /**
     * The date and time an HSM was created, expressed in [RFC
     * 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
     *
     * <p>Example: {@code 2018-04-03T21:10:29.600Z}
     *
     * @return the value
     */
    public java.util.Date getTimeCreated() {
        return timeCreated;
    }

    /**
     * The date and time an HSM was updated, expressed in [RFC
     * 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
     *
     * <p>Example: {@code 2018-04-03T21:10:29.600Z}
     */
    @com.fasterxml.jackson.annotation.JsonProperty("timeUpdated")
    private final java.util.Date timeUpdated;

    /**
     * The date and time an HSM was updated, expressed in [RFC
     * 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
     *
     * <p>Example: {@code 2018-04-03T21:10:29.600Z}
     *
     * @return the value
     */
    public java.util.Date getTimeUpdated() {
        return timeUpdated;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("HsmPartitionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", hsmClusterId=").append(String.valueOf(this.hsmClusterId));
        sb.append(", lifecycleState=").append(String.valueOf(this.lifecycleState));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", portInformation=").append(String.valueOf(this.portInformation));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HsmPartitionSummary)) {
            return false;
        }

        HsmPartitionSummary other = (HsmPartitionSummary) o;
        return java.util.Objects.equals(this.id, other.id)
                && java.util.Objects.equals(this.hsmClusterId, other.hsmClusterId)
                && java.util.Objects.equals(this.lifecycleState, other.lifecycleState)
                && java.util.Objects.equals(this.compartmentId, other.compartmentId)
                && java.util.Objects.equals(this.portInformation, other.portInformation)
                && java.util.Objects.equals(this.timeCreated, other.timeCreated)
                && java.util.Objects.equals(this.timeUpdated, other.timeUpdated)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.id == null ? 43 : this.id.hashCode());
        result = (result * PRIME) + (this.hsmClusterId == null ? 43 : this.hsmClusterId.hashCode());
        result =
                (result * PRIME)
                        + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result =
                (result * PRIME)
                        + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result =
                (result * PRIME)
                        + (this.portInformation == null ? 43 : this.portInformation.hashCode());
        result = (result * PRIME) + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = (result * PRIME) + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
