/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.keymanagement.model.*;
/**
 * <b>Example: </b>Click <a
 * href="https://docs.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/keymanagement/UpdateEkmsPrivateEndpointExample.java.html"
 * target="_blank" rel="noopener noreferrer">here</a> to see how to use
 * UpdateEkmsPrivateEndpointRequest.
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: release")
public class UpdateEkmsPrivateEndpointRequest
        extends com.oracle.bmc.requests.BmcRequest<
                com.oracle.bmc.keymanagement.model.UpdateEkmsPrivateEndpointDetails> {

    /** Unique EKMS private endpoint identifier. */
    private String ekmsPrivateEndpointId;

    /** Unique EKMS private endpoint identifier. */
    public String getEkmsPrivateEndpointId() {
        return ekmsPrivateEndpointId;
    }
    /** The information to be updated in EKMS private endpoint */
    private com.oracle.bmc.keymanagement.model.UpdateEkmsPrivateEndpointDetails
            updateEkmsPrivateEndpointDetails;

    /** The information to be updated in EKMS private endpoint */
    public com.oracle.bmc.keymanagement.model.UpdateEkmsPrivateEndpointDetails
            getUpdateEkmsPrivateEndpointDetails() {
        return updateEkmsPrivateEndpointDetails;
    }
    /**
     * For optimistic concurrency control. In the PUT or DELETE call for a resource, set the {@code
     * if-match} parameter to the value of the etag from a previous GET or POST response for that
     * resource. The resource will be updated or deleted only if the etag you provide matches the
     * resource's current etag value.
     */
    private String ifMatch;

    /**
     * For optimistic concurrency control. In the PUT or DELETE call for a resource, set the {@code
     * if-match} parameter to the value of the etag from a previous GET or POST response for that
     * resource. The resource will be updated or deleted only if the etag you provide matches the
     * resource's current etag value.
     */
    public String getIfMatch() {
        return ifMatch;
    }
    /**
     * Unique identifier for the request. If provided, the returned request ID will include this
     * value. Otherwise, a random request ID will be generated by the service.
     */
    private String opcRequestId;

    /**
     * Unique identifier for the request. If provided, the returned request ID will include this
     * value. Otherwise, a random request ID will be generated by the service.
     */
    public String getOpcRequestId() {
        return opcRequestId;
    }

    /**
     * Alternative accessor for the body parameter.
     *
     * @return body parameter
     */
    @Override
    @com.oracle.bmc.InternalSdk
    public com.oracle.bmc.keymanagement.model.UpdateEkmsPrivateEndpointDetails getBody$() {
        return updateEkmsPrivateEndpointDetails;
    }

    public static class Builder
            implements com.oracle.bmc.requests.BmcRequest.Builder<
                    UpdateEkmsPrivateEndpointRequest,
                    com.oracle.bmc.keymanagement.model.UpdateEkmsPrivateEndpointDetails> {
        private com.oracle.bmc.http.client.RequestInterceptor invocationCallback = null;
        private com.oracle.bmc.retrier.RetryConfiguration retryConfiguration = null;

        /** Unique EKMS private endpoint identifier. */
        private String ekmsPrivateEndpointId = null;

        /**
         * Unique EKMS private endpoint identifier.
         *
         * @param ekmsPrivateEndpointId the value to set
         * @return this builder instance
         */
        public Builder ekmsPrivateEndpointId(String ekmsPrivateEndpointId) {
            this.ekmsPrivateEndpointId = ekmsPrivateEndpointId;
            return this;
        }

        /** The information to be updated in EKMS private endpoint */
        private com.oracle.bmc.keymanagement.model.UpdateEkmsPrivateEndpointDetails
                updateEkmsPrivateEndpointDetails = null;

        /**
         * The information to be updated in EKMS private endpoint
         *
         * @param updateEkmsPrivateEndpointDetails the value to set
         * @return this builder instance
         */
        public Builder updateEkmsPrivateEndpointDetails(
                com.oracle.bmc.keymanagement.model.UpdateEkmsPrivateEndpointDetails
                        updateEkmsPrivateEndpointDetails) {
            this.updateEkmsPrivateEndpointDetails = updateEkmsPrivateEndpointDetails;
            return this;
        }

        /**
         * For optimistic concurrency control. In the PUT or DELETE call for a resource, set the
         * {@code if-match} parameter to the value of the etag from a previous GET or POST response
         * for that resource. The resource will be updated or deleted only if the etag you provide
         * matches the resource's current etag value.
         */
        private String ifMatch = null;

        /**
         * For optimistic concurrency control. In the PUT or DELETE call for a resource, set the
         * {@code if-match} parameter to the value of the etag from a previous GET or POST response
         * for that resource. The resource will be updated or deleted only if the etag you provide
         * matches the resource's current etag value.
         *
         * @param ifMatch the value to set
         * @return this builder instance
         */
        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        /**
         * Unique identifier for the request. If provided, the returned request ID will include this
         * value. Otherwise, a random request ID will be generated by the service.
         */
        private String opcRequestId = null;

        /**
         * Unique identifier for the request. If provided, the returned request ID will include this
         * value. Otherwise, a random request ID will be generated by the service.
         *
         * @param opcRequestId the value to set
         * @return this builder instance
         */
        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        /**
         * Set the invocation callback for the request to be built.
         *
         * @param invocationCallback the invocation callback to be set for the request
         * @return this builder instance
         */
        public Builder invocationCallback(
                com.oracle.bmc.http.client.RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        /**
         * Set the retry configuration for the request to be built.
         *
         * @param retryConfiguration the retry configuration to be used for the request
         * @return this builder instance
         */
        public Builder retryConfiguration(
                com.oracle.bmc.retrier.RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        /**
         * Copy method to populate the builder with values from the given instance.
         *
         * @return this builder instance
         */
        public Builder copy(UpdateEkmsPrivateEndpointRequest o) {
            ekmsPrivateEndpointId(o.getEkmsPrivateEndpointId());
            updateEkmsPrivateEndpointDetails(o.getUpdateEkmsPrivateEndpointDetails());
            ifMatch(o.getIfMatch());
            opcRequestId(o.getOpcRequestId());
            invocationCallback(o.getInvocationCallback());
            retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        /**
         * Build the instance of UpdateEkmsPrivateEndpointRequest as configured by this builder
         *
         * <p>Note that this method takes calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#buildWithoutInvocationCallback} does not.
         *
         * <p>This is the preferred method to build an instance.
         *
         * @return instance of UpdateEkmsPrivateEndpointRequest
         */
        public UpdateEkmsPrivateEndpointRequest build() {
            UpdateEkmsPrivateEndpointRequest request = buildWithoutInvocationCallback();
            request.setInvocationCallback(invocationCallback);
            request.setRetryConfiguration(retryConfiguration);
            return request;
        }

        /**
         * Alternative setter for the body parameter.
         *
         * @param body the body parameter
         * @return this builder instance
         */
        @com.oracle.bmc.InternalSdk
        public Builder body$(
                com.oracle.bmc.keymanagement.model.UpdateEkmsPrivateEndpointDetails body) {
            updateEkmsPrivateEndpointDetails(body);
            return this;
        }

        /**
         * Build the instance of UpdateEkmsPrivateEndpointRequest as configured by this builder
         *
         * <p>Note that this method does not take calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#build} does
         *
         * @return instance of UpdateEkmsPrivateEndpointRequest
         */
        public UpdateEkmsPrivateEndpointRequest buildWithoutInvocationCallback() {
            UpdateEkmsPrivateEndpointRequest request = new UpdateEkmsPrivateEndpointRequest();
            request.ekmsPrivateEndpointId = ekmsPrivateEndpointId;
            request.updateEkmsPrivateEndpointDetails = updateEkmsPrivateEndpointDetails;
            request.ifMatch = ifMatch;
            request.opcRequestId = opcRequestId;
            return request;
            // new UpdateEkmsPrivateEndpointRequest(ekmsPrivateEndpointId,
            // updateEkmsPrivateEndpointDetails, ifMatch, opcRequestId);
        }
    }

    /**
     * Return an instance of {@link Builder} that allows you to modify request properties.
     *
     * @return instance of {@link Builder} that allows you to modify request properties.
     */
    public Builder toBuilder() {
        return new Builder()
                .ekmsPrivateEndpointId(ekmsPrivateEndpointId)
                .updateEkmsPrivateEndpointDetails(updateEkmsPrivateEndpointDetails)
                .ifMatch(ifMatch)
                .opcRequestId(opcRequestId);
    }

    /**
     * Return a new builder for this request object.
     *
     * @return builder for the request object
     */
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",ekmsPrivateEndpointId=").append(String.valueOf(this.ekmsPrivateEndpointId));
        sb.append(",updateEkmsPrivateEndpointDetails=")
                .append(String.valueOf(this.updateEkmsPrivateEndpointDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateEkmsPrivateEndpointRequest)) {
            return false;
        }

        UpdateEkmsPrivateEndpointRequest other = (UpdateEkmsPrivateEndpointRequest) o;
        return super.equals(o)
                && java.util.Objects.equals(this.ekmsPrivateEndpointId, other.ekmsPrivateEndpointId)
                && java.util.Objects.equals(
                        this.updateEkmsPrivateEndpointDetails,
                        other.updateEkmsPrivateEndpointDetails)
                && java.util.Objects.equals(this.ifMatch, other.ifMatch)
                && java.util.Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result =
                (result * PRIME)
                        + (this.ekmsPrivateEndpointId == null
                                ? 43
                                : this.ekmsPrivateEndpointId.hashCode());
        result =
                (result * PRIME)
                        + (this.updateEkmsPrivateEndpointDetails == null
                                ? 43
                                : this.updateEkmsPrivateEndpointDetails.hashCode());
        result = (result * PRIME) + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = (result * PRIME) + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }
}
