/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.objectstorage.model;

/**
 * Details of the targets that can be accessed by the private endpoint. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20160918")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = AccessTargetDetails.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class AccessTargetDetails
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({"namespace", "compartmentId", "bucket"})
    public AccessTargetDetails(String namespace, String compartmentId, String bucket) {
        super();
        this.namespace = namespace;
        this.compartmentId = compartmentId;
        this.bucket = bucket;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /**
         * The Object Storage namespace which the private endpoint can access. Wildcards ('*') are
         * allowed. If value is '*', it means all namespaces can be accessed. It cannot be a regex.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("namespace")
        private String namespace;

        /**
         * The Object Storage namespace which the private endpoint can access. Wildcards ('*') are
         * allowed. If value is '*', it means all namespaces can be accessed. It cannot be a regex.
         *
         * @param namespace the value to set
         * @return this builder
         */
        public Builder namespace(String namespace) {
            this.namespace = namespace;
            this.__explicitlySet__.add("namespace");
            return this;
        }
        /**
         * The compartment ID which the private endpoint can access. Wildcards ('*') are allowed. If
         * value is '*', it means all compartments in the specified namespace can be accessed. It
         * cannot be a regex.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
        private String compartmentId;

        /**
         * The compartment ID which the private endpoint can access. Wildcards ('*') are allowed. If
         * value is '*', it means all compartments in the specified namespace can be accessed. It
         * cannot be a regex.
         *
         * @param compartmentId the value to set
         * @return this builder
         */
        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }
        /**
         * The name of the bucket. Avoid entering confidential information. Wildcards ('*') are
         * allowed. If value is '*', it means all buckets in the specified namespace and compartment
         * can be accessed. It cannot be a regex. Example: my-new-bucket1
         */
        @com.fasterxml.jackson.annotation.JsonProperty("bucket")
        private String bucket;

        /**
         * The name of the bucket. Avoid entering confidential information. Wildcards ('*') are
         * allowed. If value is '*', it means all buckets in the specified namespace and compartment
         * can be accessed. It cannot be a regex. Example: my-new-bucket1
         *
         * @param bucket the value to set
         * @return this builder
         */
        public Builder bucket(String bucket) {
            this.bucket = bucket;
            this.__explicitlySet__.add("bucket");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public AccessTargetDetails build() {
            AccessTargetDetails model =
                    new AccessTargetDetails(this.namespace, this.compartmentId, this.bucket);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(AccessTargetDetails model) {
            if (model.wasPropertyExplicitlySet("namespace")) {
                this.namespace(model.getNamespace());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("bucket")) {
                this.bucket(model.getBucket());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /**
     * The Object Storage namespace which the private endpoint can access. Wildcards ('*') are
     * allowed. If value is '*', it means all namespaces can be accessed. It cannot be a regex.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("namespace")
    private final String namespace;

    /**
     * The Object Storage namespace which the private endpoint can access. Wildcards ('*') are
     * allowed. If value is '*', it means all namespaces can be accessed. It cannot be a regex.
     *
     * @return the value
     */
    public String getNamespace() {
        return namespace;
    }

    /**
     * The compartment ID which the private endpoint can access. Wildcards ('*') are allowed. If
     * value is '*', it means all compartments in the specified namespace can be accessed. It cannot
     * be a regex.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
    private final String compartmentId;

    /**
     * The compartment ID which the private endpoint can access. Wildcards ('*') are allowed. If
     * value is '*', it means all compartments in the specified namespace can be accessed. It cannot
     * be a regex.
     *
     * @return the value
     */
    public String getCompartmentId() {
        return compartmentId;
    }

    /**
     * The name of the bucket. Avoid entering confidential information. Wildcards ('*') are allowed.
     * If value is '*', it means all buckets in the specified namespace and compartment can be
     * accessed. It cannot be a regex. Example: my-new-bucket1
     */
    @com.fasterxml.jackson.annotation.JsonProperty("bucket")
    private final String bucket;

    /**
     * The name of the bucket. Avoid entering confidential information. Wildcards ('*') are allowed.
     * If value is '*', it means all buckets in the specified namespace and compartment can be
     * accessed. It cannot be a regex. Example: my-new-bucket1
     *
     * @return the value
     */
    public String getBucket() {
        return bucket;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("AccessTargetDetails(");
        sb.append("super=").append(super.toString());
        sb.append("namespace=").append(String.valueOf(this.namespace));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", bucket=").append(String.valueOf(this.bucket));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccessTargetDetails)) {
            return false;
        }

        AccessTargetDetails other = (AccessTargetDetails) o;
        return java.util.Objects.equals(this.namespace, other.namespace)
                && java.util.Objects.equals(this.compartmentId, other.compartmentId)
                && java.util.Objects.equals(this.bucket, other.bucket)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.namespace == null ? 43 : this.namespace.hashCode());
        result =
                (result * PRIME)
                        + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = (result * PRIME) + (this.bucket == null ? 43 : this.bucket.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
