/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.opsi.model;

/**
 * Insights response containing current/projected groups for storage or CPU. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20200630")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = SummarizeDatabaseInsightResourceUtilizationInsightAggregation.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class SummarizeDatabaseInsightResourceUtilizationInsightAggregation
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "timeIntervalStart",
        "timeIntervalEnd",
        "highUtilizationThreshold",
        "lowUtilizationThreshold",
        "resourceMetric",
        "projectedUtilization",
        "currentUtilization"
    })
    public SummarizeDatabaseInsightResourceUtilizationInsightAggregation(
            java.util.Date timeIntervalStart,
            java.util.Date timeIntervalEnd,
            Integer highUtilizationThreshold,
            Integer lowUtilizationThreshold,
            ResourceMetric resourceMetric,
            ResourceInsightProjectedUtilization projectedUtilization,
            ResourceInsightCurrentUtilization currentUtilization) {
        super();
        this.timeIntervalStart = timeIntervalStart;
        this.timeIntervalEnd = timeIntervalEnd;
        this.highUtilizationThreshold = highUtilizationThreshold;
        this.lowUtilizationThreshold = lowUtilizationThreshold;
        this.resourceMetric = resourceMetric;
        this.projectedUtilization = projectedUtilization;
        this.currentUtilization = currentUtilization;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /** The start timestamp that was passed into the request. */
        @com.fasterxml.jackson.annotation.JsonProperty("timeIntervalStart")
        private java.util.Date timeIntervalStart;

        /**
         * The start timestamp that was passed into the request.
         *
         * @param timeIntervalStart the value to set
         * @return this builder
         */
        public Builder timeIntervalStart(java.util.Date timeIntervalStart) {
            this.timeIntervalStart = timeIntervalStart;
            this.__explicitlySet__.add("timeIntervalStart");
            return this;
        }
        /** The end timestamp that was passed into the request. */
        @com.fasterxml.jackson.annotation.JsonProperty("timeIntervalEnd")
        private java.util.Date timeIntervalEnd;

        /**
         * The end timestamp that was passed into the request.
         *
         * @param timeIntervalEnd the value to set
         * @return this builder
         */
        public Builder timeIntervalEnd(java.util.Date timeIntervalEnd) {
            this.timeIntervalEnd = timeIntervalEnd;
            this.__explicitlySet__.add("timeIntervalEnd");
            return this;
        }
        /** Percent value in which a resource metric is considered highly utilized. */
        @com.fasterxml.jackson.annotation.JsonProperty("highUtilizationThreshold")
        private Integer highUtilizationThreshold;

        /**
         * Percent value in which a resource metric is considered highly utilized.
         *
         * @param highUtilizationThreshold the value to set
         * @return this builder
         */
        public Builder highUtilizationThreshold(Integer highUtilizationThreshold) {
            this.highUtilizationThreshold = highUtilizationThreshold;
            this.__explicitlySet__.add("highUtilizationThreshold");
            return this;
        }
        /** Percent value in which a resource metric is considered lowly utilized. */
        @com.fasterxml.jackson.annotation.JsonProperty("lowUtilizationThreshold")
        private Integer lowUtilizationThreshold;

        /**
         * Percent value in which a resource metric is considered lowly utilized.
         *
         * @param lowUtilizationThreshold the value to set
         * @return this builder
         */
        public Builder lowUtilizationThreshold(Integer lowUtilizationThreshold) {
            this.lowUtilizationThreshold = lowUtilizationThreshold;
            this.__explicitlySet__.add("lowUtilizationThreshold");
            return this;
        }
        /** Defines the type of resource metric (example: CPU, STORAGE) */
        @com.fasterxml.jackson.annotation.JsonProperty("resourceMetric")
        private ResourceMetric resourceMetric;

        /**
         * Defines the type of resource metric (example: CPU, STORAGE)
         *
         * @param resourceMetric the value to set
         * @return this builder
         */
        public Builder resourceMetric(ResourceMetric resourceMetric) {
            this.resourceMetric = resourceMetric;
            this.__explicitlySet__.add("resourceMetric");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("projectedUtilization")
        private ResourceInsightProjectedUtilization projectedUtilization;

        public Builder projectedUtilization(
                ResourceInsightProjectedUtilization projectedUtilization) {
            this.projectedUtilization = projectedUtilization;
            this.__explicitlySet__.add("projectedUtilization");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("currentUtilization")
        private ResourceInsightCurrentUtilization currentUtilization;

        public Builder currentUtilization(ResourceInsightCurrentUtilization currentUtilization) {
            this.currentUtilization = currentUtilization;
            this.__explicitlySet__.add("currentUtilization");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public SummarizeDatabaseInsightResourceUtilizationInsightAggregation build() {
            SummarizeDatabaseInsightResourceUtilizationInsightAggregation model =
                    new SummarizeDatabaseInsightResourceUtilizationInsightAggregation(
                            this.timeIntervalStart,
                            this.timeIntervalEnd,
                            this.highUtilizationThreshold,
                            this.lowUtilizationThreshold,
                            this.resourceMetric,
                            this.projectedUtilization,
                            this.currentUtilization);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(SummarizeDatabaseInsightResourceUtilizationInsightAggregation model) {
            if (model.wasPropertyExplicitlySet("timeIntervalStart")) {
                this.timeIntervalStart(model.getTimeIntervalStart());
            }
            if (model.wasPropertyExplicitlySet("timeIntervalEnd")) {
                this.timeIntervalEnd(model.getTimeIntervalEnd());
            }
            if (model.wasPropertyExplicitlySet("highUtilizationThreshold")) {
                this.highUtilizationThreshold(model.getHighUtilizationThreshold());
            }
            if (model.wasPropertyExplicitlySet("lowUtilizationThreshold")) {
                this.lowUtilizationThreshold(model.getLowUtilizationThreshold());
            }
            if (model.wasPropertyExplicitlySet("resourceMetric")) {
                this.resourceMetric(model.getResourceMetric());
            }
            if (model.wasPropertyExplicitlySet("projectedUtilization")) {
                this.projectedUtilization(model.getProjectedUtilization());
            }
            if (model.wasPropertyExplicitlySet("currentUtilization")) {
                this.currentUtilization(model.getCurrentUtilization());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /** The start timestamp that was passed into the request. */
    @com.fasterxml.jackson.annotation.JsonProperty("timeIntervalStart")
    private final java.util.Date timeIntervalStart;

    /**
     * The start timestamp that was passed into the request.
     *
     * @return the value
     */
    public java.util.Date getTimeIntervalStart() {
        return timeIntervalStart;
    }

    /** The end timestamp that was passed into the request. */
    @com.fasterxml.jackson.annotation.JsonProperty("timeIntervalEnd")
    private final java.util.Date timeIntervalEnd;

    /**
     * The end timestamp that was passed into the request.
     *
     * @return the value
     */
    public java.util.Date getTimeIntervalEnd() {
        return timeIntervalEnd;
    }

    /** Percent value in which a resource metric is considered highly utilized. */
    @com.fasterxml.jackson.annotation.JsonProperty("highUtilizationThreshold")
    private final Integer highUtilizationThreshold;

    /**
     * Percent value in which a resource metric is considered highly utilized.
     *
     * @return the value
     */
    public Integer getHighUtilizationThreshold() {
        return highUtilizationThreshold;
    }

    /** Percent value in which a resource metric is considered lowly utilized. */
    @com.fasterxml.jackson.annotation.JsonProperty("lowUtilizationThreshold")
    private final Integer lowUtilizationThreshold;

    /**
     * Percent value in which a resource metric is considered lowly utilized.
     *
     * @return the value
     */
    public Integer getLowUtilizationThreshold() {
        return lowUtilizationThreshold;
    }

    /** Defines the type of resource metric (example: CPU, STORAGE) */
    public enum ResourceMetric implements com.oracle.bmc.http.internal.BmcEnum {
        Cpu("CPU"),
        Storage("STORAGE"),
        Io("IO"),
        Memory("MEMORY"),
        MemoryPga("MEMORY_PGA"),
        MemorySga("MEMORY_SGA"),

        /**
         * This value is used if a service returns a value for this enum that is not recognized by
         * this version of the SDK.
         */
        UnknownEnumValue(null);

        private static final org.slf4j.Logger LOG =
                org.slf4j.LoggerFactory.getLogger(ResourceMetric.class);

        private final String value;
        private static java.util.Map<String, ResourceMetric> map;

        static {
            map = new java.util.HashMap<>();
            for (ResourceMetric v : ResourceMetric.values()) {
                if (v != UnknownEnumValue) {
                    map.put(v.getValue(), v);
                }
            }
        }

        ResourceMetric(String value) {
            this.value = value;
        }

        @com.fasterxml.jackson.annotation.JsonValue
        public String getValue() {
            return value;
        }

        @com.fasterxml.jackson.annotation.JsonCreator
        public static ResourceMetric create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn(
                    "Received unknown value '{}' for enum 'ResourceMetric', returning UnknownEnumValue",
                    key);
            return UnknownEnumValue;
        }
    };
    /** Defines the type of resource metric (example: CPU, STORAGE) */
    @com.fasterxml.jackson.annotation.JsonProperty("resourceMetric")
    private final ResourceMetric resourceMetric;

    /**
     * Defines the type of resource metric (example: CPU, STORAGE)
     *
     * @return the value
     */
    public ResourceMetric getResourceMetric() {
        return resourceMetric;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("projectedUtilization")
    private final ResourceInsightProjectedUtilization projectedUtilization;

    public ResourceInsightProjectedUtilization getProjectedUtilization() {
        return projectedUtilization;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("currentUtilization")
    private final ResourceInsightCurrentUtilization currentUtilization;

    public ResourceInsightCurrentUtilization getCurrentUtilization() {
        return currentUtilization;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("SummarizeDatabaseInsightResourceUtilizationInsightAggregation(");
        sb.append("super=").append(super.toString());
        sb.append("timeIntervalStart=").append(String.valueOf(this.timeIntervalStart));
        sb.append(", timeIntervalEnd=").append(String.valueOf(this.timeIntervalEnd));
        sb.append(", highUtilizationThreshold=")
                .append(String.valueOf(this.highUtilizationThreshold));
        sb.append(", lowUtilizationThreshold=")
                .append(String.valueOf(this.lowUtilizationThreshold));
        sb.append(", resourceMetric=").append(String.valueOf(this.resourceMetric));
        sb.append(", projectedUtilization=").append(String.valueOf(this.projectedUtilization));
        sb.append(", currentUtilization=").append(String.valueOf(this.currentUtilization));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeDatabaseInsightResourceUtilizationInsightAggregation)) {
            return false;
        }

        SummarizeDatabaseInsightResourceUtilizationInsightAggregation other =
                (SummarizeDatabaseInsightResourceUtilizationInsightAggregation) o;
        return java.util.Objects.equals(this.timeIntervalStart, other.timeIntervalStart)
                && java.util.Objects.equals(this.timeIntervalEnd, other.timeIntervalEnd)
                && java.util.Objects.equals(
                        this.highUtilizationThreshold, other.highUtilizationThreshold)
                && java.util.Objects.equals(
                        this.lowUtilizationThreshold, other.lowUtilizationThreshold)
                && java.util.Objects.equals(this.resourceMetric, other.resourceMetric)
                && java.util.Objects.equals(this.projectedUtilization, other.projectedUtilization)
                && java.util.Objects.equals(this.currentUtilization, other.currentUtilization)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result =
                (result * PRIME)
                        + (this.timeIntervalStart == null ? 43 : this.timeIntervalStart.hashCode());
        result =
                (result * PRIME)
                        + (this.timeIntervalEnd == null ? 43 : this.timeIntervalEnd.hashCode());
        result =
                (result * PRIME)
                        + (this.highUtilizationThreshold == null
                                ? 43
                                : this.highUtilizationThreshold.hashCode());
        result =
                (result * PRIME)
                        + (this.lowUtilizationThreshold == null
                                ? 43
                                : this.lowUtilizationThreshold.hashCode());
        result =
                (result * PRIME)
                        + (this.resourceMetric == null ? 43 : this.resourceMetric.hashCode());
        result =
                (result * PRIME)
                        + (this.projectedUtilization == null
                                ? 43
                                : this.projectedUtilization.hashCode());
        result =
                (result * PRIME)
                        + (this.currentUtilization == null
                                ? 43
                                : this.currentUtilization.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
