/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.opsi.model;

/**
 * Details of a TABLE type data object in a Warehouse. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20200630")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = WarehouseTableDataObjectDetails.Builder.class)
@com.fasterxml.jackson.annotation.JsonTypeInfo(
        use = com.fasterxml.jackson.annotation.JsonTypeInfo.Id.NAME,
        include = com.fasterxml.jackson.annotation.JsonTypeInfo.As.PROPERTY,
        property = "dataObjectType")
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class WarehouseTableDataObjectDetails extends WarehouseDataObjectDetails {
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /** Metadata of columns in the data object. */
        @com.fasterxml.jackson.annotation.JsonProperty("columnsMetadata")
        private java.util.List<DataObjectColumnMetadata> columnsMetadata;

        /**
         * Metadata of columns in the data object.
         *
         * @param columnsMetadata the value to set
         * @return this builder
         */
        public Builder columnsMetadata(java.util.List<DataObjectColumnMetadata> columnsMetadata) {
            this.columnsMetadata = columnsMetadata;
            this.__explicitlySet__.add("columnsMetadata");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public WarehouseTableDataObjectDetails build() {
            WarehouseTableDataObjectDetails model =
                    new WarehouseTableDataObjectDetails(this.columnsMetadata);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(WarehouseTableDataObjectDetails model) {
            if (model.wasPropertyExplicitlySet("columnsMetadata")) {
                this.columnsMetadata(model.getColumnsMetadata());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public WarehouseTableDataObjectDetails(
            java.util.List<DataObjectColumnMetadata> columnsMetadata) {
        super();
        this.columnsMetadata = columnsMetadata;
    }

    /** Metadata of columns in the data object. */
    @com.fasterxml.jackson.annotation.JsonProperty("columnsMetadata")
    private final java.util.List<DataObjectColumnMetadata> columnsMetadata;

    /**
     * Metadata of columns in the data object.
     *
     * @return the value
     */
    public java.util.List<DataObjectColumnMetadata> getColumnsMetadata() {
        return columnsMetadata;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("WarehouseTableDataObjectDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", columnsMetadata=").append(String.valueOf(this.columnsMetadata));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WarehouseTableDataObjectDetails)) {
            return false;
        }

        WarehouseTableDataObjectDetails other = (WarehouseTableDataObjectDetails) o;
        return java.util.Objects.equals(this.columnsMetadata, other.columnsMetadata)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result =
                (result * PRIME)
                        + (this.columnsMetadata == null ? 43 : this.columnsMetadata.hashCode());
        return result;
    }
}
