/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.servicemesh.model;

/**
 * Ingress gateway target that virtual services in mesh receive traffic from. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20220615")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = IngressGatewayAccessPolicyTargetDetails.Builder.class)
@com.fasterxml.jackson.annotation.JsonTypeInfo(
        use = com.fasterxml.jackson.annotation.JsonTypeInfo.Id.NAME,
        include = com.fasterxml.jackson.annotation.JsonTypeInfo.As.PROPERTY,
        property = "type")
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class IngressGatewayAccessPolicyTargetDetails extends AccessPolicyTargetDetails {
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /** The OCID of the ingress gateway resource. */
        @com.fasterxml.jackson.annotation.JsonProperty("ingressGatewayId")
        private String ingressGatewayId;

        /**
         * The OCID of the ingress gateway resource.
         *
         * @param ingressGatewayId the value to set
         * @return this builder
         */
        public Builder ingressGatewayId(String ingressGatewayId) {
            this.ingressGatewayId = ingressGatewayId;
            this.__explicitlySet__.add("ingressGatewayId");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public IngressGatewayAccessPolicyTargetDetails build() {
            IngressGatewayAccessPolicyTargetDetails model =
                    new IngressGatewayAccessPolicyTargetDetails(this.ingressGatewayId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(IngressGatewayAccessPolicyTargetDetails model) {
            if (model.wasPropertyExplicitlySet("ingressGatewayId")) {
                this.ingressGatewayId(model.getIngressGatewayId());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public IngressGatewayAccessPolicyTargetDetails(String ingressGatewayId) {
        super();
        this.ingressGatewayId = ingressGatewayId;
    }

    /** The OCID of the ingress gateway resource. */
    @com.fasterxml.jackson.annotation.JsonProperty("ingressGatewayId")
    private final String ingressGatewayId;

    /**
     * The OCID of the ingress gateway resource.
     *
     * @return the value
     */
    public String getIngressGatewayId() {
        return ingressGatewayId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("IngressGatewayAccessPolicyTargetDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", ingressGatewayId=").append(String.valueOf(this.ingressGatewayId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IngressGatewayAccessPolicyTargetDetails)) {
            return false;
        }

        IngressGatewayAccessPolicyTargetDetails other = (IngressGatewayAccessPolicyTargetDetails) o;
        return java.util.Objects.equals(this.ingressGatewayId, other.ingressGatewayId)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result =
                (result * PRIME)
                        + (this.ingressGatewayId == null ? 43 : this.ingressGatewayId.hashCode());
        return result;
    }
}
