/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.stackmonitoring.model;

/**
 * Specific resource mapping configurations for Agent Extension Handlers. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210330")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = AgentExtensionHandlerConfiguration.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class AgentExtensionHandlerConfiguration
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "collectorTypes",
        "metricUploadIntervalInSeconds",
        "telemetryResourceGroup",
        "telegrafResourceNameConfig",
        "collectdResourceNameConfig",
        "metricNameConfig",
        "metricMappings",
        "handlerProperties"
    })
    public AgentExtensionHandlerConfiguration(
            java.util.List<String> collectorTypes,
            Integer metricUploadIntervalInSeconds,
            String telemetryResourceGroup,
            TelegrafResourceNameConfigurationDetails telegrafResourceNameConfig,
            CollectdResourceNameConfigurationDetails collectdResourceNameConfig,
            MetricNameConfigurationDetails metricNameConfig,
            java.util.List<AgentExtensionHandlerMetricMappingDetails> metricMappings,
            java.util.List<AgentExtensionHandlerConfigurationProperty> handlerProperties) {
        super();
        this.collectorTypes = collectorTypes;
        this.metricUploadIntervalInSeconds = metricUploadIntervalInSeconds;
        this.telemetryResourceGroup = telemetryResourceGroup;
        this.telegrafResourceNameConfig = telegrafResourceNameConfig;
        this.collectdResourceNameConfig = collectdResourceNameConfig;
        this.metricNameConfig = metricNameConfig;
        this.metricMappings = metricMappings;
        this.handlerProperties = handlerProperties;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /** List of collector/plugin names. */
        @com.fasterxml.jackson.annotation.JsonProperty("collectorTypes")
        private java.util.List<String> collectorTypes;

        /**
         * List of collector/plugin names.
         *
         * @param collectorTypes the value to set
         * @return this builder
         */
        public Builder collectorTypes(java.util.List<String> collectorTypes) {
            this.collectorTypes = collectorTypes;
            this.__explicitlySet__.add("collectorTypes");
            return this;
        }
        /**
         * Metric upload interval in seconds. Any metric sent by telegraf/collectd before the
         * configured interval expires will be dropped.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("metricUploadIntervalInSeconds")
        private Integer metricUploadIntervalInSeconds;

        /**
         * Metric upload interval in seconds. Any metric sent by telegraf/collectd before the
         * configured interval expires will be dropped.
         *
         * @param metricUploadIntervalInSeconds the value to set
         * @return this builder
         */
        public Builder metricUploadIntervalInSeconds(Integer metricUploadIntervalInSeconds) {
            this.metricUploadIntervalInSeconds = metricUploadIntervalInSeconds;
            this.__explicitlySet__.add("metricUploadIntervalInSeconds");
            return this;
        }
        /**
         * Resource group string; if not specified, the resource group string will be generated by
         * the handler.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("telemetryResourceGroup")
        private String telemetryResourceGroup;

        /**
         * Resource group string; if not specified, the resource group string will be generated by
         * the handler.
         *
         * @param telemetryResourceGroup the value to set
         * @return this builder
         */
        public Builder telemetryResourceGroup(String telemetryResourceGroup) {
            this.telemetryResourceGroup = telemetryResourceGroup;
            this.__explicitlySet__.add("telemetryResourceGroup");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("telegrafResourceNameConfig")
        private TelegrafResourceNameConfigurationDetails telegrafResourceNameConfig;

        public Builder telegrafResourceNameConfig(
                TelegrafResourceNameConfigurationDetails telegrafResourceNameConfig) {
            this.telegrafResourceNameConfig = telegrafResourceNameConfig;
            this.__explicitlySet__.add("telegrafResourceNameConfig");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("collectdResourceNameConfig")
        private CollectdResourceNameConfigurationDetails collectdResourceNameConfig;

        public Builder collectdResourceNameConfig(
                CollectdResourceNameConfigurationDetails collectdResourceNameConfig) {
            this.collectdResourceNameConfig = collectdResourceNameConfig;
            this.__explicitlySet__.add("collectdResourceNameConfig");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("metricNameConfig")
        private MetricNameConfigurationDetails metricNameConfig;

        public Builder metricNameConfig(MetricNameConfigurationDetails metricNameConfig) {
            this.metricNameConfig = metricNameConfig;
            this.__explicitlySet__.add("metricNameConfig");
            return this;
        }
        /** List of AgentExtensionHandlerMetricMappingDetails. */
        @com.fasterxml.jackson.annotation.JsonProperty("metricMappings")
        private java.util.List<AgentExtensionHandlerMetricMappingDetails> metricMappings;

        /**
         * List of AgentExtensionHandlerMetricMappingDetails.
         *
         * @param metricMappings the value to set
         * @return this builder
         */
        public Builder metricMappings(
                java.util.List<AgentExtensionHandlerMetricMappingDetails> metricMappings) {
            this.metricMappings = metricMappings;
            this.__explicitlySet__.add("metricMappings");
            return this;
        }
        /** List of handler configuration properties */
        @com.fasterxml.jackson.annotation.JsonProperty("handlerProperties")
        private java.util.List<AgentExtensionHandlerConfigurationProperty> handlerProperties;

        /**
         * List of handler configuration properties
         *
         * @param handlerProperties the value to set
         * @return this builder
         */
        public Builder handlerProperties(
                java.util.List<AgentExtensionHandlerConfigurationProperty> handlerProperties) {
            this.handlerProperties = handlerProperties;
            this.__explicitlySet__.add("handlerProperties");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public AgentExtensionHandlerConfiguration build() {
            AgentExtensionHandlerConfiguration model =
                    new AgentExtensionHandlerConfiguration(
                            this.collectorTypes,
                            this.metricUploadIntervalInSeconds,
                            this.telemetryResourceGroup,
                            this.telegrafResourceNameConfig,
                            this.collectdResourceNameConfig,
                            this.metricNameConfig,
                            this.metricMappings,
                            this.handlerProperties);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(AgentExtensionHandlerConfiguration model) {
            if (model.wasPropertyExplicitlySet("collectorTypes")) {
                this.collectorTypes(model.getCollectorTypes());
            }
            if (model.wasPropertyExplicitlySet("metricUploadIntervalInSeconds")) {
                this.metricUploadIntervalInSeconds(model.getMetricUploadIntervalInSeconds());
            }
            if (model.wasPropertyExplicitlySet("telemetryResourceGroup")) {
                this.telemetryResourceGroup(model.getTelemetryResourceGroup());
            }
            if (model.wasPropertyExplicitlySet("telegrafResourceNameConfig")) {
                this.telegrafResourceNameConfig(model.getTelegrafResourceNameConfig());
            }
            if (model.wasPropertyExplicitlySet("collectdResourceNameConfig")) {
                this.collectdResourceNameConfig(model.getCollectdResourceNameConfig());
            }
            if (model.wasPropertyExplicitlySet("metricNameConfig")) {
                this.metricNameConfig(model.getMetricNameConfig());
            }
            if (model.wasPropertyExplicitlySet("metricMappings")) {
                this.metricMappings(model.getMetricMappings());
            }
            if (model.wasPropertyExplicitlySet("handlerProperties")) {
                this.handlerProperties(model.getHandlerProperties());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /** List of collector/plugin names. */
    @com.fasterxml.jackson.annotation.JsonProperty("collectorTypes")
    private final java.util.List<String> collectorTypes;

    /**
     * List of collector/plugin names.
     *
     * @return the value
     */
    public java.util.List<String> getCollectorTypes() {
        return collectorTypes;
    }

    /**
     * Metric upload interval in seconds. Any metric sent by telegraf/collectd before the configured
     * interval expires will be dropped.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("metricUploadIntervalInSeconds")
    private final Integer metricUploadIntervalInSeconds;

    /**
     * Metric upload interval in seconds. Any metric sent by telegraf/collectd before the configured
     * interval expires will be dropped.
     *
     * @return the value
     */
    public Integer getMetricUploadIntervalInSeconds() {
        return metricUploadIntervalInSeconds;
    }

    /**
     * Resource group string; if not specified, the resource group string will be generated by the
     * handler.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("telemetryResourceGroup")
    private final String telemetryResourceGroup;

    /**
     * Resource group string; if not specified, the resource group string will be generated by the
     * handler.
     *
     * @return the value
     */
    public String getTelemetryResourceGroup() {
        return telemetryResourceGroup;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("telegrafResourceNameConfig")
    private final TelegrafResourceNameConfigurationDetails telegrafResourceNameConfig;

    public TelegrafResourceNameConfigurationDetails getTelegrafResourceNameConfig() {
        return telegrafResourceNameConfig;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("collectdResourceNameConfig")
    private final CollectdResourceNameConfigurationDetails collectdResourceNameConfig;

    public CollectdResourceNameConfigurationDetails getCollectdResourceNameConfig() {
        return collectdResourceNameConfig;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("metricNameConfig")
    private final MetricNameConfigurationDetails metricNameConfig;

    public MetricNameConfigurationDetails getMetricNameConfig() {
        return metricNameConfig;
    }

    /** List of AgentExtensionHandlerMetricMappingDetails. */
    @com.fasterxml.jackson.annotation.JsonProperty("metricMappings")
    private final java.util.List<AgentExtensionHandlerMetricMappingDetails> metricMappings;

    /**
     * List of AgentExtensionHandlerMetricMappingDetails.
     *
     * @return the value
     */
    public java.util.List<AgentExtensionHandlerMetricMappingDetails> getMetricMappings() {
        return metricMappings;
    }

    /** List of handler configuration properties */
    @com.fasterxml.jackson.annotation.JsonProperty("handlerProperties")
    private final java.util.List<AgentExtensionHandlerConfigurationProperty> handlerProperties;

    /**
     * List of handler configuration properties
     *
     * @return the value
     */
    public java.util.List<AgentExtensionHandlerConfigurationProperty> getHandlerProperties() {
        return handlerProperties;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("AgentExtensionHandlerConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("collectorTypes=").append(String.valueOf(this.collectorTypes));
        sb.append(", metricUploadIntervalInSeconds=")
                .append(String.valueOf(this.metricUploadIntervalInSeconds));
        sb.append(", telemetryResourceGroup=").append(String.valueOf(this.telemetryResourceGroup));
        sb.append(", telegrafResourceNameConfig=")
                .append(String.valueOf(this.telegrafResourceNameConfig));
        sb.append(", collectdResourceNameConfig=")
                .append(String.valueOf(this.collectdResourceNameConfig));
        sb.append(", metricNameConfig=").append(String.valueOf(this.metricNameConfig));
        sb.append(", metricMappings=").append(String.valueOf(this.metricMappings));
        sb.append(", handlerProperties=").append(String.valueOf(this.handlerProperties));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AgentExtensionHandlerConfiguration)) {
            return false;
        }

        AgentExtensionHandlerConfiguration other = (AgentExtensionHandlerConfiguration) o;
        return java.util.Objects.equals(this.collectorTypes, other.collectorTypes)
                && java.util.Objects.equals(
                        this.metricUploadIntervalInSeconds, other.metricUploadIntervalInSeconds)
                && java.util.Objects.equals(
                        this.telemetryResourceGroup, other.telemetryResourceGroup)
                && java.util.Objects.equals(
                        this.telegrafResourceNameConfig, other.telegrafResourceNameConfig)
                && java.util.Objects.equals(
                        this.collectdResourceNameConfig, other.collectdResourceNameConfig)
                && java.util.Objects.equals(this.metricNameConfig, other.metricNameConfig)
                && java.util.Objects.equals(this.metricMappings, other.metricMappings)
                && java.util.Objects.equals(this.handlerProperties, other.handlerProperties)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result =
                (result * PRIME)
                        + (this.collectorTypes == null ? 43 : this.collectorTypes.hashCode());
        result =
                (result * PRIME)
                        + (this.metricUploadIntervalInSeconds == null
                                ? 43
                                : this.metricUploadIntervalInSeconds.hashCode());
        result =
                (result * PRIME)
                        + (this.telemetryResourceGroup == null
                                ? 43
                                : this.telemetryResourceGroup.hashCode());
        result =
                (result * PRIME)
                        + (this.telegrafResourceNameConfig == null
                                ? 43
                                : this.telegrafResourceNameConfig.hashCode());
        result =
                (result * PRIME)
                        + (this.collectdResourceNameConfig == null
                                ? 43
                                : this.collectdResourceNameConfig.hashCode());
        result =
                (result * PRIME)
                        + (this.metricNameConfig == null ? 43 : this.metricNameConfig.hashCode());
        result =
                (result * PRIME)
                        + (this.metricMappings == null ? 43 : this.metricMappings.hashCode());
        result =
                (result * PRIME)
                        + (this.handlerProperties == null ? 43 : this.handlerProperties.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
