/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.usageapi;

import com.oracle.bmc.usageapi.requests.*;
import com.oracle.bmc.usageapi.responses.*;

/**
 * Collection of helper methods to produce {@link com.oracle.bmc.waiter.Waiter}s for different
 * resources of Usageapi.
 *
 * <p>The default configuration used is defined by {@link
 * com.oracle.bmc.waiter.Waiters.Waiters#DEFAULT_POLLING_WAITER}.
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20200107")
public class UsageapiWaiters {
    private final java.util.concurrent.ExecutorService executorService;
    private final Usageapi client;

    public UsageapiWaiters(java.util.concurrent.ExecutorService executorService, Usageapi client) {
        this.executorService = executorService;
        this.client = client;
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the default configuration.
     *
     * @param request the request to send
     * @param targetStates the desired states to wait for. If multiple states are provided then the
     *     waiter will return once the resource reaches any of the provided states
     * @return a new {@code Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetEmailRecipientsGroupRequest, GetEmailRecipientsGroupResponse>
            forEmailRecipientsGroup(
                    GetEmailRecipientsGroupRequest request,
                    com.oracle.bmc.usageapi.model.EmailRecipientsGroup.LifecycleState...
                            targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forEmailRecipientsGroup(
                com.oracle.bmc.waiter.Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param targetState the desired state to wait for
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetEmailRecipientsGroupRequest, GetEmailRecipientsGroupResponse>
            forEmailRecipientsGroup(
                    GetEmailRecipientsGroupRequest request,
                    com.oracle.bmc.usageapi.model.EmailRecipientsGroup.LifecycleState targetState,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy) {
        com.oracle.bmc.util.internal.Validate.notNull(
                targetState, "The targetState cannot be null");

        return forEmailRecipientsGroup(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetState);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @param targetStates the desired states to wait for. The waiter will return once the resource
     *     reaches any of the provided states
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetEmailRecipientsGroupRequest, GetEmailRecipientsGroupResponse>
            forEmailRecipientsGroup(
                    GetEmailRecipientsGroupRequest request,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy,
                    com.oracle.bmc.usageapi.model.EmailRecipientsGroup.LifecycleState...
                            targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one target state must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null target states are not permitted");

        return forEmailRecipientsGroup(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetStates);
    }

    // Helper method to create a new Waiter for EmailRecipientsGroup.
    private com.oracle.bmc.waiter.Waiter<
                    GetEmailRecipientsGroupRequest, GetEmailRecipientsGroupResponse>
            forEmailRecipientsGroup(
                    com.oracle.bmc.waiter.BmcGenericWaiter waiter,
                    final GetEmailRecipientsGroupRequest request,
                    final com.oracle.bmc.usageapi.model.EmailRecipientsGroup.LifecycleState...
                            targetStates) {
        final java.util.Set<com.oracle.bmc.usageapi.model.EmailRecipientsGroup.LifecycleState>
                targetStatesSet = new java.util.HashSet<>(java.util.Arrays.asList(targetStates));

        return new com.oracle.bmc.waiter.internal.SimpleWaiterImpl<>(
                executorService,
                waiter.toCallable(
                        () -> request,
                        new java.util.function.Function<
                                GetEmailRecipientsGroupRequest, GetEmailRecipientsGroupResponse>() {
                            @Override
                            public GetEmailRecipientsGroupResponse apply(
                                    GetEmailRecipientsGroupRequest request) {
                                return client.getEmailRecipientsGroup(request);
                            }
                        },
                        new java.util.function.Predicate<GetEmailRecipientsGroupResponse>() {
                            @Override
                            public boolean test(GetEmailRecipientsGroupResponse response) {
                                return targetStatesSet.contains(
                                        response.getEmailRecipientsGroup().getLifecycleState());
                            }
                        },
                        false),
                request);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the default configuration.
     *
     * @param request the request to send
     * @param targetStates the desired states to wait for. If multiple states are provided then the
     *     waiter will return once the resource reaches any of the provided states
     * @return a new {@code Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetScheduleRequest, GetScheduleResponse> forSchedule(
            GetScheduleRequest request,
            com.oracle.bmc.usageapi.model.Schedule.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forSchedule(
                com.oracle.bmc.waiter.Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param targetState the desired state to wait for
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetScheduleRequest, GetScheduleResponse> forSchedule(
            GetScheduleRequest request,
            com.oracle.bmc.usageapi.model.Schedule.LifecycleState targetState,
            com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
            com.oracle.bmc.waiter.DelayStrategy delayStrategy) {
        com.oracle.bmc.util.internal.Validate.notNull(
                targetState, "The targetState cannot be null");

        return forSchedule(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetState);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @param targetStates the desired states to wait for. The waiter will return once the resource
     *     reaches any of the provided states
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetScheduleRequest, GetScheduleResponse> forSchedule(
            GetScheduleRequest request,
            com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
            com.oracle.bmc.waiter.DelayStrategy delayStrategy,
            com.oracle.bmc.usageapi.model.Schedule.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one target state must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null target states are not permitted");

        return forSchedule(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetStates);
    }

    // Helper method to create a new Waiter for Schedule.
    private com.oracle.bmc.waiter.Waiter<GetScheduleRequest, GetScheduleResponse> forSchedule(
            com.oracle.bmc.waiter.BmcGenericWaiter waiter,
            final GetScheduleRequest request,
            final com.oracle.bmc.usageapi.model.Schedule.LifecycleState... targetStates) {
        final java.util.Set<com.oracle.bmc.usageapi.model.Schedule.LifecycleState> targetStatesSet =
                new java.util.HashSet<>(java.util.Arrays.asList(targetStates));

        return new com.oracle.bmc.waiter.internal.SimpleWaiterImpl<>(
                executorService,
                waiter.toCallable(
                        () -> request,
                        new java.util.function.Function<GetScheduleRequest, GetScheduleResponse>() {
                            @Override
                            public GetScheduleResponse apply(GetScheduleRequest request) {
                                return client.getSchedule(request);
                            }
                        },
                        new java.util.function.Predicate<GetScheduleResponse>() {
                            @Override
                            public boolean test(GetScheduleResponse response) {
                                return targetStatesSet.contains(
                                        response.getSchedule().getLifecycleState());
                            }
                        },
                        false),
                request);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the default configuration.
     *
     * @param request the request to send
     * @param targetStates the desired states to wait for. If multiple states are provided then the
     *     waiter will return once the resource reaches any of the provided states
     * @return a new {@code Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetScheduledRunRequest, GetScheduledRunResponse>
            forScheduledRun(
                    GetScheduledRunRequest request,
                    com.oracle.bmc.usageapi.model.ScheduledRun.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forScheduledRun(
                com.oracle.bmc.waiter.Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param targetState the desired state to wait for
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetScheduledRunRequest, GetScheduledRunResponse>
            forScheduledRun(
                    GetScheduledRunRequest request,
                    com.oracle.bmc.usageapi.model.ScheduledRun.LifecycleState targetState,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy) {
        com.oracle.bmc.util.internal.Validate.notNull(
                targetState, "The targetState cannot be null");

        return forScheduledRun(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetState);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @param targetStates the desired states to wait for. The waiter will return once the resource
     *     reaches any of the provided states
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetScheduledRunRequest, GetScheduledRunResponse>
            forScheduledRun(
                    GetScheduledRunRequest request,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy,
                    com.oracle.bmc.usageapi.model.ScheduledRun.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one target state must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null target states are not permitted");

        return forScheduledRun(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetStates);
    }

    // Helper method to create a new Waiter for ScheduledRun.
    private com.oracle.bmc.waiter.Waiter<GetScheduledRunRequest, GetScheduledRunResponse>
            forScheduledRun(
                    com.oracle.bmc.waiter.BmcGenericWaiter waiter,
                    final GetScheduledRunRequest request,
                    final com.oracle.bmc.usageapi.model.ScheduledRun.LifecycleState...
                            targetStates) {
        final java.util.Set<com.oracle.bmc.usageapi.model.ScheduledRun.LifecycleState>
                targetStatesSet = new java.util.HashSet<>(java.util.Arrays.asList(targetStates));

        return new com.oracle.bmc.waiter.internal.SimpleWaiterImpl<>(
                executorService,
                waiter.toCallable(
                        () -> request,
                        new java.util.function.Function<
                                GetScheduledRunRequest, GetScheduledRunResponse>() {
                            @Override
                            public GetScheduledRunResponse apply(GetScheduledRunRequest request) {
                                return client.getScheduledRun(request);
                            }
                        },
                        new java.util.function.Predicate<GetScheduledRunResponse>() {
                            @Override
                            public boolean test(GetScheduledRunResponse response) {
                                return targetStatesSet.contains(
                                        response.getScheduledRun().getLifecycleState());
                            }
                        },
                        false),
                request);
    }
}
