/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vault.requests;

import com.oracle.bmc.vault.model.*;
/**
 * <b>Example: </b>Click <a
 * href="https://docs.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/vault/ScheduleSecretVersionDeletionExample.java.html"
 * target="_blank" rel="noopener noreferrer">here</a> to see how to use
 * ScheduleSecretVersionDeletionRequest.
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20180608")
public class ScheduleSecretVersionDeletionRequest
        extends com.oracle.bmc.requests.BmcRequest<
                com.oracle.bmc.vault.model.ScheduleSecretVersionDeletionDetails> {

    /** The OCID of the secret. */
    private String secretId;

    /** The OCID of the secret. */
    public String getSecretId() {
        return secretId;
    }
    /** The version number of the secret. */
    private Long secretVersionNumber;

    /** The version number of the secret. */
    public Long getSecretVersionNumber() {
        return secretVersionNumber;
    }
    /** Request to delete a secret version. */
    private com.oracle.bmc.vault.model.ScheduleSecretVersionDeletionDetails
            scheduleSecretVersionDeletionDetails;

    /** Request to delete a secret version. */
    public com.oracle.bmc.vault.model.ScheduleSecretVersionDeletionDetails
            getScheduleSecretVersionDeletionDetails() {
        return scheduleSecretVersionDeletionDetails;
    }
    /**
     * For optimistic concurrency control. In the PUT or DELETE call for a resource, set the {@code
     * if-match} parameter to the value of the etag from a previous GET or POST response for that
     * resource. The resource will be updated or deleted only if the etag you provide matches the
     * resource's current etag value.
     */
    private String ifMatch;

    /**
     * For optimistic concurrency control. In the PUT or DELETE call for a resource, set the {@code
     * if-match} parameter to the value of the etag from a previous GET or POST response for that
     * resource. The resource will be updated or deleted only if the etag you provide matches the
     * resource's current etag value.
     */
    public String getIfMatch() {
        return ifMatch;
    }
    /**
     * Unique identifier for the request. If provided, the returned request ID will include this
     * value. Otherwise, a random request ID will be generated by the service.
     */
    private String opcRequestId;

    /**
     * Unique identifier for the request. If provided, the returned request ID will include this
     * value. Otherwise, a random request ID will be generated by the service.
     */
    public String getOpcRequestId() {
        return opcRequestId;
    }

    /**
     * Alternative accessor for the body parameter.
     *
     * @return body parameter
     */
    @Override
    @com.oracle.bmc.InternalSdk
    public com.oracle.bmc.vault.model.ScheduleSecretVersionDeletionDetails getBody$() {
        return scheduleSecretVersionDeletionDetails;
    }

    public static class Builder
            implements com.oracle.bmc.requests.BmcRequest.Builder<
                    ScheduleSecretVersionDeletionRequest,
                    com.oracle.bmc.vault.model.ScheduleSecretVersionDeletionDetails> {
        private com.oracle.bmc.http.client.RequestInterceptor invocationCallback = null;
        private com.oracle.bmc.retrier.RetryConfiguration retryConfiguration = null;

        /** The OCID of the secret. */
        private String secretId = null;

        /**
         * The OCID of the secret.
         *
         * @param secretId the value to set
         * @return this builder instance
         */
        public Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        /** The version number of the secret. */
        private Long secretVersionNumber = null;

        /**
         * The version number of the secret.
         *
         * @param secretVersionNumber the value to set
         * @return this builder instance
         */
        public Builder secretVersionNumber(Long secretVersionNumber) {
            this.secretVersionNumber = secretVersionNumber;
            return this;
        }

        /** Request to delete a secret version. */
        private com.oracle.bmc.vault.model.ScheduleSecretVersionDeletionDetails
                scheduleSecretVersionDeletionDetails = null;

        /**
         * Request to delete a secret version.
         *
         * @param scheduleSecretVersionDeletionDetails the value to set
         * @return this builder instance
         */
        public Builder scheduleSecretVersionDeletionDetails(
                com.oracle.bmc.vault.model.ScheduleSecretVersionDeletionDetails
                        scheduleSecretVersionDeletionDetails) {
            this.scheduleSecretVersionDeletionDetails = scheduleSecretVersionDeletionDetails;
            return this;
        }

        /**
         * For optimistic concurrency control. In the PUT or DELETE call for a resource, set the
         * {@code if-match} parameter to the value of the etag from a previous GET or POST response
         * for that resource. The resource will be updated or deleted only if the etag you provide
         * matches the resource's current etag value.
         */
        private String ifMatch = null;

        /**
         * For optimistic concurrency control. In the PUT or DELETE call for a resource, set the
         * {@code if-match} parameter to the value of the etag from a previous GET or POST response
         * for that resource. The resource will be updated or deleted only if the etag you provide
         * matches the resource's current etag value.
         *
         * @param ifMatch the value to set
         * @return this builder instance
         */
        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        /**
         * Unique identifier for the request. If provided, the returned request ID will include this
         * value. Otherwise, a random request ID will be generated by the service.
         */
        private String opcRequestId = null;

        /**
         * Unique identifier for the request. If provided, the returned request ID will include this
         * value. Otherwise, a random request ID will be generated by the service.
         *
         * @param opcRequestId the value to set
         * @return this builder instance
         */
        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        /**
         * Set the invocation callback for the request to be built.
         *
         * @param invocationCallback the invocation callback to be set for the request
         * @return this builder instance
         */
        public Builder invocationCallback(
                com.oracle.bmc.http.client.RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        /**
         * Set the retry configuration for the request to be built.
         *
         * @param retryConfiguration the retry configuration to be used for the request
         * @return this builder instance
         */
        public Builder retryConfiguration(
                com.oracle.bmc.retrier.RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        /**
         * Copy method to populate the builder with values from the given instance.
         *
         * @return this builder instance
         */
        public Builder copy(ScheduleSecretVersionDeletionRequest o) {
            secretId(o.getSecretId());
            secretVersionNumber(o.getSecretVersionNumber());
            scheduleSecretVersionDeletionDetails(o.getScheduleSecretVersionDeletionDetails());
            ifMatch(o.getIfMatch());
            opcRequestId(o.getOpcRequestId());
            invocationCallback(o.getInvocationCallback());
            retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        /**
         * Build the instance of ScheduleSecretVersionDeletionRequest as configured by this builder
         *
         * <p>Note that this method takes calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#buildWithoutInvocationCallback} does not.
         *
         * <p>This is the preferred method to build an instance.
         *
         * @return instance of ScheduleSecretVersionDeletionRequest
         */
        public ScheduleSecretVersionDeletionRequest build() {
            ScheduleSecretVersionDeletionRequest request = buildWithoutInvocationCallback();
            request.setInvocationCallback(invocationCallback);
            request.setRetryConfiguration(retryConfiguration);
            return request;
        }

        /**
         * Alternative setter for the body parameter.
         *
         * @param body the body parameter
         * @return this builder instance
         */
        @com.oracle.bmc.InternalSdk
        public Builder body$(com.oracle.bmc.vault.model.ScheduleSecretVersionDeletionDetails body) {
            scheduleSecretVersionDeletionDetails(body);
            return this;
        }

        /**
         * Build the instance of ScheduleSecretVersionDeletionRequest as configured by this builder
         *
         * <p>Note that this method does not take calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#build} does
         *
         * @return instance of ScheduleSecretVersionDeletionRequest
         */
        public ScheduleSecretVersionDeletionRequest buildWithoutInvocationCallback() {
            ScheduleSecretVersionDeletionRequest request =
                    new ScheduleSecretVersionDeletionRequest();
            request.secretId = secretId;
            request.secretVersionNumber = secretVersionNumber;
            request.scheduleSecretVersionDeletionDetails = scheduleSecretVersionDeletionDetails;
            request.ifMatch = ifMatch;
            request.opcRequestId = opcRequestId;
            return request;
            // new ScheduleSecretVersionDeletionRequest(secretId, secretVersionNumber,
            // scheduleSecretVersionDeletionDetails, ifMatch, opcRequestId);
        }
    }

    /**
     * Return an instance of {@link Builder} that allows you to modify request properties.
     *
     * @return instance of {@link Builder} that allows you to modify request properties.
     */
    public Builder toBuilder() {
        return new Builder()
                .secretId(secretId)
                .secretVersionNumber(secretVersionNumber)
                .scheduleSecretVersionDeletionDetails(scheduleSecretVersionDeletionDetails)
                .ifMatch(ifMatch)
                .opcRequestId(opcRequestId);
    }

    /**
     * Return a new builder for this request object.
     *
     * @return builder for the request object
     */
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",secretId=").append(String.valueOf(this.secretId));
        sb.append(",secretVersionNumber=").append(String.valueOf(this.secretVersionNumber));
        sb.append(",scheduleSecretVersionDeletionDetails=")
                .append(String.valueOf(this.scheduleSecretVersionDeletionDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduleSecretVersionDeletionRequest)) {
            return false;
        }

        ScheduleSecretVersionDeletionRequest other = (ScheduleSecretVersionDeletionRequest) o;
        return super.equals(o)
                && java.util.Objects.equals(this.secretId, other.secretId)
                && java.util.Objects.equals(this.secretVersionNumber, other.secretVersionNumber)
                && java.util.Objects.equals(
                        this.scheduleSecretVersionDeletionDetails,
                        other.scheduleSecretVersionDeletionDetails)
                && java.util.Objects.equals(this.ifMatch, other.ifMatch)
                && java.util.Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result = (result * PRIME) + (this.secretId == null ? 43 : this.secretId.hashCode());
        result =
                (result * PRIME)
                        + (this.secretVersionNumber == null
                                ? 43
                                : this.secretVersionNumber.hashCode());
        result =
                (result * PRIME)
                        + (this.scheduleSecretVersionDeletionDetails == null
                                ? 43
                                : this.scheduleSecretVersionDeletionDetails.hashCode());
        result = (result * PRIME) + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = (result * PRIME) + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }
}
