/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning;

import com.oracle.bmc.vulnerabilityscanning.requests.*;
import com.oracle.bmc.vulnerabilityscanning.responses.*;

/**
 * Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports.
 * For more information, see [the Vulnerability Scanning
 * documentation](https://docs.oracle.com/iaas/scanning/home.htm).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
public interface VulnerabilityScanningAsync extends AutoCloseable {

    /** Rebuilds the client from scratch. Useful to refresh certificates. */
    void refreshClient();

    /**
     * Sets the endpoint to call (ex, https://www.example.com).
     *
     * @param endpoint The endpoint of the serice.
     */
    void setEndpoint(String endpoint);

    /** Gets the set endpoint for REST call (ex, https://www.example.com) */
    String getEndpoint();

    /**
     * Sets the region to call (ex, Region.US_PHOENIX_1).
     *
     * <p>Note, this will call {@link #setEndpoint(String) setEndpoint} after resolving the
     * endpoint. If the service is not available in this region, however, an
     * IllegalArgumentException will be raised.
     *
     * @param region The region of the service.
     */
    void setRegion(com.oracle.bmc.Region region);

    /**
     * Sets the region to call (ex, 'us-phoenix-1').
     *
     * <p>Note, this will first try to map the region ID to a known Region and call {@link
     * #setRegion(Region) setRegion}.
     *
     * <p>If no known Region could be determined, it will create an endpoint based on the default
     * endpoint format ({@link com.oracle.bmc.Region#formatDefaultRegionEndpoint(Service, String)}
     * and then call {@link #setEndpoint(String) setEndpoint}.
     *
     * @param regionId The public region ID.
     */
    void setRegion(String regionId);

    /**
     * Determines whether realm specific endpoint should be used or not. Set
     * realmSpecificEndpointTemplateEnabled to "true" if the user wants to enable use of realm
     * specific endpoint template, otherwise set it to "false"
     *
     * @param realmSpecificEndpointTemplateEnabled flag to enable the use of realm specific endpoint
     *     template
     */
    void useRealmSpecificEndpointTemplate(boolean realmSpecificEndpointTemplateEnabled);

    /**
     * Moves a ContainerScanRecipe into a different compartment. When provided, If-Match is checked
     * against ETag values of the resource.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ChangeContainerScanRecipeCompartmentResponse>
            changeContainerScanRecipeCompartment(
                    ChangeContainerScanRecipeCompartmentRequest request,
                    com.oracle.bmc.responses.AsyncHandler<
                                    ChangeContainerScanRecipeCompartmentRequest,
                                    ChangeContainerScanRecipeCompartmentResponse>
                            handler);

    /**
     * Moves a ContainerScanResult into a different compartment. When provided, If-Match is checked
     * against ETag values of the resource.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ChangeContainerScanResultCompartmentResponse>
            changeContainerScanResultCompartment(
                    ChangeContainerScanResultCompartmentRequest request,
                    com.oracle.bmc.responses.AsyncHandler<
                                    ChangeContainerScanResultCompartmentRequest,
                                    ChangeContainerScanResultCompartmentResponse>
                            handler);

    /**
     * Moves a ContainerScanTarget into a different compartment. When provided, If-Match is checked
     * against ETag values of the resource.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ChangeContainerScanTargetCompartmentResponse>
            changeContainerScanTargetCompartment(
                    ChangeContainerScanTargetCompartmentRequest request,
                    com.oracle.bmc.responses.AsyncHandler<
                                    ChangeContainerScanTargetCompartmentRequest,
                                    ChangeContainerScanTargetCompartmentResponse>
                            handler);

    /**
     * Moves a HostAgentScanResult into a different compartment. When provided, If-Match is checked
     * against ETag values of the resource.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ChangeHostAgentScanResultCompartmentResponse>
            changeHostAgentScanResultCompartment(
                    ChangeHostAgentScanResultCompartmentRequest request,
                    com.oracle.bmc.responses.AsyncHandler<
                                    ChangeHostAgentScanResultCompartmentRequest,
                                    ChangeHostAgentScanResultCompartmentResponse>
                            handler);

    /**
     * Moves a HostCisBenchmarkScanResult into a different compartment. When provided, If-Match is
     * checked against ETag values of the resource.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ChangeHostCisBenchmarkScanResultCompartmentResponse>
            changeHostCisBenchmarkScanResultCompartment(
                    ChangeHostCisBenchmarkScanResultCompartmentRequest request,
                    com.oracle.bmc.responses.AsyncHandler<
                                    ChangeHostCisBenchmarkScanResultCompartmentRequest,
                                    ChangeHostCisBenchmarkScanResultCompartmentResponse>
                            handler);

    /**
     * Moves a HostEndpointProtectionScanResult into a different compartment. When provided,
     * If-Match is checked against ETag values of the resource.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ChangeHostEndpointProtectionScanResultCompartmentResponse>
            changeHostEndpointProtectionScanResultCompartment(
                    ChangeHostEndpointProtectionScanResultCompartmentRequest request,
                    com.oracle.bmc.responses.AsyncHandler<
                                    ChangeHostEndpointProtectionScanResultCompartmentRequest,
                                    ChangeHostEndpointProtectionScanResultCompartmentResponse>
                            handler);

    /**
     * Moves a HostPortScanResult into a different compartment. When provided, If-Match is checked
     * against ETag values of the resource.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ChangeHostPortScanResultCompartmentResponse>
            changeHostPortScanResultCompartment(
                    ChangeHostPortScanResultCompartmentRequest request,
                    com.oracle.bmc.responses.AsyncHandler<
                                    ChangeHostPortScanResultCompartmentRequest,
                                    ChangeHostPortScanResultCompartmentResponse>
                            handler);

    /**
     * Moves a HostScanRecipe into a different compartment. When provided, If-Match is checked
     * against ETag values of the resource.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ChangeHostScanRecipeCompartmentResponse>
            changeHostScanRecipeCompartment(
                    ChangeHostScanRecipeCompartmentRequest request,
                    com.oracle.bmc.responses.AsyncHandler<
                                    ChangeHostScanRecipeCompartmentRequest,
                                    ChangeHostScanRecipeCompartmentResponse>
                            handler);

    /**
     * Moves a HostScanTarget into a different compartment. When provided, If-Match is checked
     * against ETag values of the resource.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ChangeHostScanTargetCompartmentResponse>
            changeHostScanTargetCompartment(
                    ChangeHostScanTargetCompartmentRequest request,
                    com.oracle.bmc.responses.AsyncHandler<
                                    ChangeHostScanTargetCompartmentRequest,
                                    ChangeHostScanTargetCompartmentResponse>
                            handler);

    /**
     * Creates a new ContainerScanRecipe. A recipe determines the types of security issues that you
     * want scanned.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<CreateContainerScanRecipeResponse> createContainerScanRecipe(
            CreateContainerScanRecipeRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            CreateContainerScanRecipeRequest, CreateContainerScanRecipeResponse>
                    handler);

    /**
     * Creates a new ContainerScanTarget. A container scan target specifies a group of one or more
     * Docker image repositories in Oracle Cloud Infrastructure Registry (OCIR) that you want
     * routinely scanned for security vulnerabilities.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<CreateContainerScanTargetResponse> createContainerScanTarget(
            CreateContainerScanTargetRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            CreateContainerScanTargetRequest, CreateContainerScanTargetResponse>
                    handler);

    /**
     * Creates a new HostScanRecipe. A recipe determines the types of security issues that you want
     * scanned, and how often to scan.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<CreateHostScanRecipeResponse> createHostScanRecipe(
            CreateHostScanRecipeRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            CreateHostScanRecipeRequest, CreateHostScanRecipeResponse>
                    handler);

    /**
     * Creates a new HostScanTarget. A host scan target is a collection of compute instances that
     * you want routinely scanned for security vulnerabilities.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<CreateHostScanTargetResponse> createHostScanTarget(
            CreateHostScanTargetRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            CreateHostScanTargetRequest, CreateHostScanTargetResponse>
                    handler);

    /**
     * Deletes the ContainerScanRecipe identified by the recipe ID.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<DeleteContainerScanRecipeResponse> deleteContainerScanRecipe(
            DeleteContainerScanRecipeRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            DeleteContainerScanRecipeRequest, DeleteContainerScanRecipeResponse>
                    handler);

    /**
     * Deletes the ContainerScanResult identified by the container scan ID.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<DeleteContainerScanResultResponse> deleteContainerScanResult(
            DeleteContainerScanResultRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            DeleteContainerScanResultRequest, DeleteContainerScanResultResponse>
                    handler);

    /**
     * Deletes the ContainerScanTarget identified by the target ID.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<DeleteContainerScanTargetResponse> deleteContainerScanTarget(
            DeleteContainerScanTargetRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            DeleteContainerScanTargetRequest, DeleteContainerScanTargetResponse>
                    handler);

    /**
     * Deletes the HostAgentScanResult identified by the host agent scan ID.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<DeleteHostAgentScanResultResponse> deleteHostAgentScanResult(
            DeleteHostAgentScanResultRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            DeleteHostAgentScanResultRequest, DeleteHostAgentScanResultResponse>
                    handler);

    /**
     * Deletes the HostCisBenchmarkScanResult identified by the benchmark scan result ID.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<DeleteHostCisBenchmarkScanResultResponse>
            deleteHostCisBenchmarkScanResult(
                    DeleteHostCisBenchmarkScanResultRequest request,
                    com.oracle.bmc.responses.AsyncHandler<
                                    DeleteHostCisBenchmarkScanResultRequest,
                                    DeleteHostCisBenchmarkScanResultResponse>
                            handler);

    /**
     * Deletes the HostEndpointProtectionScanResult identified by the id
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<DeleteHostEndpointProtectionScanResultResponse>
            deleteHostEndpointProtectionScanResult(
                    DeleteHostEndpointProtectionScanResultRequest request,
                    com.oracle.bmc.responses.AsyncHandler<
                                    DeleteHostEndpointProtectionScanResultRequest,
                                    DeleteHostEndpointProtectionScanResultResponse>
                            handler);

    /**
     * Deletes the HostPortScanResult identified by the host port scan ID.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<DeleteHostPortScanResultResponse> deleteHostPortScanResult(
            DeleteHostPortScanResultRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            DeleteHostPortScanResultRequest, DeleteHostPortScanResultResponse>
                    handler);

    /**
     * Deletes the HostScanRecipe identified by the recipe ID.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<DeleteHostScanRecipeResponse> deleteHostScanRecipe(
            DeleteHostScanRecipeRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            DeleteHostScanRecipeRequest, DeleteHostScanRecipeResponse>
                    handler);

    /**
     * Deletes the HostScanTarget identified by the target ID.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<DeleteHostScanTargetResponse> deleteHostScanTarget(
            DeleteHostScanTargetRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            DeleteHostScanTargetRequest, DeleteHostScanTargetResponse>
                    handler);

    /**
     * Exports a list of HostAgentScanResultSummary objects within a compartment and during a
     * specified time range in CSV format. You can filter the results by problem severity.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ExportHostAgentScanResultCsvResponse> exportHostAgentScanResultCsv(
            ExportHostAgentScanResultCsvRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ExportHostAgentScanResultCsvRequest,
                            ExportHostAgentScanResultCsvResponse>
                    handler);

    /**
     * Exports a list of HostVulnerabilitySummary objects in a compartment in CSV format.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ExportHostVulnerabilityCsvResponse> exportHostVulnerabilityCsv(
            ExportHostVulnerabilityCsvRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ExportHostVulnerabilityCsvRequest, ExportHostVulnerabilityCsvResponse>
                    handler);

    /**
     * Retrieves a ContainerScanRecipe identified by the recipe ID. A recipe determines the types of
     * security issues that you want scanned.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetContainerScanRecipeResponse> getContainerScanRecipe(
            GetContainerScanRecipeRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            GetContainerScanRecipeRequest, GetContainerScanRecipeResponse>
                    handler);

    /**
     * Retrieves a ContainerScanResult identified by the container scan ID. The result includes a
     * list of problems found in a specific image in a Docker repository.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetContainerScanResultResponse> getContainerScanResult(
            GetContainerScanResultRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            GetContainerScanResultRequest, GetContainerScanResultResponse>
                    handler);

    /**
     * Gets a ContainerScanTarget identified by the target ID. A container scan target specifies a
     * group of one or more Docker image repositories in Oracle Cloud Infrastructure Registry (OCIR)
     * that you want routinely scanned for security vulnerabilities.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetContainerScanTargetResponse> getContainerScanTarget(
            GetContainerScanTargetRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            GetContainerScanTargetRequest, GetContainerScanTargetResponse>
                    handler);

    /**
     * Retrieves a HostAgentScanResult identified by the host agent scan ID. The result includes a
     * list of CVEs detected in a specific compute instance.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetHostAgentScanResultResponse> getHostAgentScanResult(
            GetHostAgentScanResultRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            GetHostAgentScanResultRequest, GetHostAgentScanResultResponse>
                    handler);

    /**
     * Retrieves a HostCisBenchmarkScanResult identified by the benchmark scan result ID. A CIS
     * (Center for Internet Security) benchmark scan result includes a list of benchmarks that were
     * tested on a specific compute instance, and whether each test passed or failed.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetHostCisBenchmarkScanResultResponse>
            getHostCisBenchmarkScanResult(
                    GetHostCisBenchmarkScanResultRequest request,
                    com.oracle.bmc.responses.AsyncHandler<
                                    GetHostCisBenchmarkScanResultRequest,
                                    GetHostCisBenchmarkScanResultResponse>
                            handler);

    /**
     * Returns HostEndpointProtectionScanResults for the given host endpoint protection scan result
     * ID.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetHostEndpointProtectionScanResultResponse>
            getHostEndpointProtectionScanResult(
                    GetHostEndpointProtectionScanResultRequest request,
                    com.oracle.bmc.responses.AsyncHandler<
                                    GetHostEndpointProtectionScanResultRequest,
                                    GetHostEndpointProtectionScanResultResponse>
                            handler);

    /**
     * Retrieves a HostPortScanResult identified by the host port scan ID. The result includes a
     * list of open ports that were detected in a specific compute instance.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetHostPortScanResultResponse> getHostPortScanResult(
            GetHostPortScanResultRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            GetHostPortScanResultRequest, GetHostPortScanResultResponse>
                    handler);

    /**
     * Retrieves a HostScanRecipe identified by the recipe ID. A recipe determines the types of
     * security issues that you want scanned, and how often to scan.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetHostScanRecipeResponse> getHostScanRecipe(
            GetHostScanRecipeRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            GetHostScanRecipeRequest, GetHostScanRecipeResponse>
                    handler);

    /**
     * Retrieves a HostScanTarget identified by the target ID. A host scan target is a collection of
     * compute instances that you want routinely scanned for security vulnerabilities.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetHostScanTargetResponse> getHostScanTarget(
            GetHostScanTargetRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            GetHostScanTargetRequest, GetHostScanTargetResponse>
                    handler);

    /**
     * Retrieves a HostVulnerability identified by the host vulnerability ID. A host vulnerability
     * describes a security issue that was detected in scans of one or more compute instances.
     * Common Vulnerabilities and Exposures (CVE) numbers identify security vulnerabilities for
     * operating systems and other software, including Critical Patch Updates and Security Alert
     * advisories.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetHostVulnerabilityResponse> getHostVulnerability(
            GetHostVulnerabilityRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            GetHostVulnerabilityRequest, GetHostVulnerabilityResponse>
                    handler);

    /**
     * Retrieves a Vulnerability identified by the vulnerability ID. A vulnerability describes a
     * security issue that was detected in scans of one or more compute instances, container scan
     * repositories. Common Vulnerabilities and Exposures (CVE) numbers identify security
     * vulnerabilities for operating systems and other software, including Critical Patch Updates
     * and Security Alert advisories.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetVulnerabilityResponse> getVulnerability(
            GetVulnerabilityRequest request,
            com.oracle.bmc.responses.AsyncHandler<GetVulnerabilityRequest, GetVulnerabilityResponse>
                    handler);

    /**
     * Gets the status of the work request with the given ID.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetWorkRequestResponse> getWorkRequest(
            GetWorkRequestRequest request,
            com.oracle.bmc.responses.AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse>
                    handler);

    /**
     * Retrieves a list of ContainerScanRecipeSummary objects in a compartment. A recipe determines
     * the types of security issues that you want scanned.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListContainerScanRecipesResponse> listContainerScanRecipes(
            ListContainerScanRecipesRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ListContainerScanRecipesRequest, ListContainerScanRecipesResponse>
                    handler);

    /**
     * Retrieves a list of ContainerScanResultSummary objects in a compartment. You can filter and
     * sort the results by problem severity and time. A container scan result includes a list of
     * problems detected in a specific image in a Docker repository.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListContainerScanResultsResponse> listContainerScanResults(
            ListContainerScanResultsRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ListContainerScanResultsRequest, ListContainerScanResultsResponse>
                    handler);

    /**
     * Retrieves a list of ContainerScanTargetSummary objects in a compartment. A container scan
     * target specifies a group of one or more Docker image repositories in Oracle Cloud
     * Infrastructure Registry (OCIR) that you want routinely scanned for security vulnerabilities.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListContainerScanTargetsResponse> listContainerScanTargets(
            ListContainerScanTargetsRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ListContainerScanTargetsRequest, ListContainerScanTargetsResponse>
                    handler);

    /**
     * Retrieves a list of HostAgentScanResultSummary objects in a compartment. You can filter and
     * sort the results by problem severity and time. An agent scan result includes a list of CVEs
     * detected in a specific compute instance.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListHostAgentScanResultsResponse> listHostAgentScanResults(
            ListHostAgentScanResultsRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ListHostAgentScanResultsRequest, ListHostAgentScanResultsResponse>
                    handler);

    /**
     * Retrieves a list of HostCisBenchmarkScanResultSummary objects in a compartment. You can
     * filter and sort the results by problem severity and time. A CIS (Center for Internet
     * Security) benchmark scan result includes the number of failed benchmark tests on a specific
     * compute instance.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListHostCisBenchmarkScanResultsResponse>
            listHostCisBenchmarkScanResults(
                    ListHostCisBenchmarkScanResultsRequest request,
                    com.oracle.bmc.responses.AsyncHandler<
                                    ListHostCisBenchmarkScanResultsRequest,
                                    ListHostCisBenchmarkScanResultsResponse>
                            handler);

    /**
     * Returns a collection of HostEndpointProtectionScanResultSummary objects
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListHostEndpointProtectionScanResultsResponse>
            listHostEndpointProtectionScanResults(
                    ListHostEndpointProtectionScanResultsRequest request,
                    com.oracle.bmc.responses.AsyncHandler<
                                    ListHostEndpointProtectionScanResultsRequest,
                                    ListHostEndpointProtectionScanResultsResponse>
                            handler);

    /**
     * Retrieves a list of HostPortScanResultSummary objects in a compartment. You can filter and
     * sort the results by problem severity and time. A port scan result includes a list of open
     * ports that were detected in a specific compute instance.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListHostPortScanResultsResponse> listHostPortScanResults(
            ListHostPortScanResultsRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ListHostPortScanResultsRequest, ListHostPortScanResultsResponse>
                    handler);

    /**
     * Retrieves a list of HostScanRecipeSummary objects in a compartment. A recipe determines the
     * types of security issues that you want scanned, and how often to scan.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListHostScanRecipesResponse> listHostScanRecipes(
            ListHostScanRecipesRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ListHostScanRecipesRequest, ListHostScanRecipesResponse>
                    handler);

    /**
     * Retrieves list of errors during scanning on instances associated with HostScanTarget
     * identified by the target ID. A host scan target is a collection of compute instances that you
     * want routinely scanned for security vulnerabilities.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListHostScanTargetErrorsResponse> listHostScanTargetErrors(
            ListHostScanTargetErrorsRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ListHostScanTargetErrorsRequest, ListHostScanTargetErrorsResponse>
                    handler);

    /**
     * Retrieves a list of HostScanTargetSummary objects in a compartment. A host scan target is a
     * collection of compute instances that you want routinely scanned for security vulnerabilities.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListHostScanTargetsResponse> listHostScanTargets(
            ListHostScanTargetsRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ListHostScanTargetsRequest, ListHostScanTargetsResponse>
                    handler);

    /**
     * Retrieves a list of HostVulnerabilitySummary objects in a compartment. You can filter and
     * sort the vulnerabilities by problem severity and time. A host vulnerability describes a
     * security issue that was detected in scans of one or more compute instances.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListHostVulnerabilitiesResponse> listHostVulnerabilities(
            ListHostVulnerabilitiesRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ListHostVulnerabilitiesRequest, ListHostVulnerabilitiesResponse>
                    handler);

    /**
     * Retrieves a list of HostVulnerabilityImpactedHostSummary objects for a specific host
     * vulnerability ID. An impacted host summary identifies a compute instance on which the
     * specified vulnerability was detected.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListHostVulnerabilityImpactedHostsResponse>
            listHostVulnerabilityImpactedHosts(
                    ListHostVulnerabilityImpactedHostsRequest request,
                    com.oracle.bmc.responses.AsyncHandler<
                                    ListHostVulnerabilityImpactedHostsRequest,
                                    ListHostVulnerabilityImpactedHostsResponse>
                            handler);

    /**
     * Retrieves a list of VulnerabilitySummary objects in a compartment. You can filter and sort
     * the vulnerabilities by problem severity and time and type. A vulnerability describes a
     * security issue that was detected in scans of one or more compute instances, container images.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListVulnerabilitiesResponse> listVulnerabilities(
            ListVulnerabilitiesRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ListVulnerabilitiesRequest, ListVulnerabilitiesResponse>
                    handler);

    /**
     * Retrieves a list of VulnerabilityImpactedContainerSummary objects for a specific
     * vulnerability ID. An impacted container image summary identifies container images on which
     * the specified vulnerability was detected.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListVulnerabilityImpactedContainersResponse>
            listVulnerabilityImpactedContainers(
                    ListVulnerabilityImpactedContainersRequest request,
                    com.oracle.bmc.responses.AsyncHandler<
                                    ListVulnerabilityImpactedContainersRequest,
                                    ListVulnerabilityImpactedContainersResponse>
                            handler);

    /**
     * Retrieves a list of VulnerabilityImpactedHostSummary objects for a specific host
     * vulnerability ID. An impacted host summary identifies a compute instance on which the
     * specified vulnerability was detected.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListVulnerabilityImpactedHostsResponse>
            listVulnerabilityImpactedHosts(
                    ListVulnerabilityImpactedHostsRequest request,
                    com.oracle.bmc.responses.AsyncHandler<
                                    ListVulnerabilityImpactedHostsRequest,
                                    ListVulnerabilityImpactedHostsResponse>
                            handler);

    /**
     * Return a (paginated) list of errors for a given work request.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(
            ListWorkRequestErrorsRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>
                    handler);

    /**
     * Return a (paginated) list of logs for a given work request.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListWorkRequestLogsResponse> listWorkRequestLogs(
            ListWorkRequestLogsRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>
                    handler);

    /**
     * Lists the work requests in a compartment.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListWorkRequestsResponse> listWorkRequests(
            ListWorkRequestsRequest request,
            com.oracle.bmc.responses.AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse>
                    handler);

    /**
     * Updates the ContainerScanRecipe identified by the recipe ID. A recipe determines the types of
     * security issues that you want scanned.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateContainerScanRecipeResponse> updateContainerScanRecipe(
            UpdateContainerScanRecipeRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            UpdateContainerScanRecipeRequest, UpdateContainerScanRecipeResponse>
                    handler);

    /**
     * Updates the ContainerScanTarget identified by the target ID. A container scan target
     * specifies a group of one or more Docker image repositories in Oracle Cloud Infrastructure
     * Registry (OCIR) that you want routinely scanned for security vulnerabilities.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateContainerScanTargetResponse> updateContainerScanTarget(
            UpdateContainerScanTargetRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            UpdateContainerScanTargetRequest, UpdateContainerScanTargetResponse>
                    handler);

    /**
     * Updates the HostScanRecipe identified by the recipe ID. A recipe determines the types of
     * security issues that you want scanned, and how often to scan.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateHostScanRecipeResponse> updateHostScanRecipe(
            UpdateHostScanRecipeRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            UpdateHostScanRecipeRequest, UpdateHostScanRecipeResponse>
                    handler);

    /**
     * Updates the HostScanTarget identified by the target ID. A host scan target is a collection of
     * compute instances that you want routinely scanned for security vulnerabilities.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateHostScanTargetResponse> updateHostScanTarget(
            UpdateHostScanTargetRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            UpdateHostScanTargetRequest, UpdateHostScanTargetResponse>
                    handler);
}
