/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning;

import com.oracle.bmc.vulnerabilityscanning.requests.*;
import com.oracle.bmc.vulnerabilityscanning.responses.*;

/**
 * Collection of helper methods to produce {@link com.oracle.bmc.waiter.Waiter}s for different
 * resources of VulnerabilityScanning.
 *
 * <p>The default configuration used is defined by {@link
 * com.oracle.bmc.waiter.Waiters.Waiters#DEFAULT_POLLING_WAITER}.
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
public class VulnerabilityScanningWaiters {
    private final java.util.concurrent.ExecutorService executorService;
    private final VulnerabilityScanning client;

    public VulnerabilityScanningWaiters(
            java.util.concurrent.ExecutorService executorService, VulnerabilityScanning client) {
        this.executorService = executorService;
        this.client = client;
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the default configuration.
     *
     * @param request the request to send
     * @param targetState the desired states to wait for. If multiple states are provided then the
     *     waiter will return once the resource reaches any of the provided states
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetContainerScanRecipeRequest, GetContainerScanRecipeResponse>
            forContainerScanRecipe(
                    GetContainerScanRecipeRequest request,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forContainerScanRecipe(
                com.oracle.bmc.waiter.Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param targetState the desired state to wait for
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetContainerScanRecipeRequest, GetContainerScanRecipeResponse>
            forContainerScanRecipe(
                    GetContainerScanRecipeRequest request,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState targetState,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy) {
        com.oracle.bmc.util.internal.Validate.notNull(
                targetState, "The targetState cannot be null");

        return forContainerScanRecipe(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetState);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @param targetStates the desired states to wait for. The waiter will return once the resource
     *     reaches any of the provided states
     * @return a new {@code Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetContainerScanRecipeRequest, GetContainerScanRecipeResponse>
            forContainerScanRecipe(
                    GetContainerScanRecipeRequest request,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forContainerScanRecipe(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetStates);
    }

    // Helper method to create a new Waiter for ContainerScanRecipe.
    private com.oracle.bmc.waiter.Waiter<
                    GetContainerScanRecipeRequest, GetContainerScanRecipeResponse>
            forContainerScanRecipe(
                    com.oracle.bmc.waiter.BmcGenericWaiter waiter,
                    final GetContainerScanRecipeRequest request,
                    final com.oracle.bmc.vulnerabilityscanning.model.LifecycleState...
                            targetStates) {
        final java.util.Set<com.oracle.bmc.vulnerabilityscanning.model.LifecycleState>
                targetStatesSet = new java.util.HashSet<>(java.util.Arrays.asList(targetStates));

        return new com.oracle.bmc.waiter.internal.SimpleWaiterImpl<>(
                executorService,
                waiter.toCallable(
                        () -> request,
                        new java.util.function.Function<
                                GetContainerScanRecipeRequest, GetContainerScanRecipeResponse>() {
                            @Override
                            public GetContainerScanRecipeResponse apply(
                                    GetContainerScanRecipeRequest request) {
                                return client.getContainerScanRecipe(request);
                            }
                        },
                        new java.util.function.Predicate<GetContainerScanRecipeResponse>() {
                            @Override
                            public boolean test(GetContainerScanRecipeResponse response) {
                                return targetStatesSet.contains(
                                        response.getContainerScanRecipe().getLifecycleState());
                            }
                        },
                        targetStatesSet.contains(
                                com.oracle.bmc.vulnerabilityscanning.model.LifecycleState.Deleted)),
                request);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the default configuration.
     *
     * @param request the request to send
     * @param targetState the desired states to wait for. If multiple states are provided then the
     *     waiter will return once the resource reaches any of the provided states
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetContainerScanTargetRequest, GetContainerScanTargetResponse>
            forContainerScanTarget(
                    GetContainerScanTargetRequest request,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forContainerScanTarget(
                com.oracle.bmc.waiter.Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param targetState the desired state to wait for
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetContainerScanTargetRequest, GetContainerScanTargetResponse>
            forContainerScanTarget(
                    GetContainerScanTargetRequest request,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState targetState,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy) {
        com.oracle.bmc.util.internal.Validate.notNull(
                targetState, "The targetState cannot be null");

        return forContainerScanTarget(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetState);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @param targetStates the desired states to wait for. The waiter will return once the resource
     *     reaches any of the provided states
     * @return a new {@code Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetContainerScanTargetRequest, GetContainerScanTargetResponse>
            forContainerScanTarget(
                    GetContainerScanTargetRequest request,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forContainerScanTarget(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetStates);
    }

    // Helper method to create a new Waiter for ContainerScanTarget.
    private com.oracle.bmc.waiter.Waiter<
                    GetContainerScanTargetRequest, GetContainerScanTargetResponse>
            forContainerScanTarget(
                    com.oracle.bmc.waiter.BmcGenericWaiter waiter,
                    final GetContainerScanTargetRequest request,
                    final com.oracle.bmc.vulnerabilityscanning.model.LifecycleState...
                            targetStates) {
        final java.util.Set<com.oracle.bmc.vulnerabilityscanning.model.LifecycleState>
                targetStatesSet = new java.util.HashSet<>(java.util.Arrays.asList(targetStates));

        return new com.oracle.bmc.waiter.internal.SimpleWaiterImpl<>(
                executorService,
                waiter.toCallable(
                        () -> request,
                        new java.util.function.Function<
                                GetContainerScanTargetRequest, GetContainerScanTargetResponse>() {
                            @Override
                            public GetContainerScanTargetResponse apply(
                                    GetContainerScanTargetRequest request) {
                                return client.getContainerScanTarget(request);
                            }
                        },
                        new java.util.function.Predicate<GetContainerScanTargetResponse>() {
                            @Override
                            public boolean test(GetContainerScanTargetResponse response) {
                                return targetStatesSet.contains(
                                        response.getContainerScanTarget().getLifecycleState());
                            }
                        },
                        targetStatesSet.contains(
                                com.oracle.bmc.vulnerabilityscanning.model.LifecycleState.Deleted)),
                request);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the default configuration.
     *
     * @param request the request to send
     * @param targetState the desired states to wait for. If multiple states are provided then the
     *     waiter will return once the resource reaches any of the provided states
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetHostAgentScanResultRequest, GetHostAgentScanResultResponse>
            forHostAgentScanResult(
                    GetHostAgentScanResultRequest request,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forHostAgentScanResult(
                com.oracle.bmc.waiter.Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param targetState the desired state to wait for
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetHostAgentScanResultRequest, GetHostAgentScanResultResponse>
            forHostAgentScanResult(
                    GetHostAgentScanResultRequest request,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState targetState,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy) {
        com.oracle.bmc.util.internal.Validate.notNull(
                targetState, "The targetState cannot be null");

        return forHostAgentScanResult(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetState);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @param targetStates the desired states to wait for. The waiter will return once the resource
     *     reaches any of the provided states
     * @return a new {@code Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetHostAgentScanResultRequest, GetHostAgentScanResultResponse>
            forHostAgentScanResult(
                    GetHostAgentScanResultRequest request,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forHostAgentScanResult(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetStates);
    }

    // Helper method to create a new Waiter for HostAgentScanResult.
    private com.oracle.bmc.waiter.Waiter<
                    GetHostAgentScanResultRequest, GetHostAgentScanResultResponse>
            forHostAgentScanResult(
                    com.oracle.bmc.waiter.BmcGenericWaiter waiter,
                    final GetHostAgentScanResultRequest request,
                    final com.oracle.bmc.vulnerabilityscanning.model.LifecycleState...
                            targetStates) {
        final java.util.Set<com.oracle.bmc.vulnerabilityscanning.model.LifecycleState>
                targetStatesSet = new java.util.HashSet<>(java.util.Arrays.asList(targetStates));

        return new com.oracle.bmc.waiter.internal.SimpleWaiterImpl<>(
                executorService,
                waiter.toCallable(
                        () -> request,
                        new java.util.function.Function<
                                GetHostAgentScanResultRequest, GetHostAgentScanResultResponse>() {
                            @Override
                            public GetHostAgentScanResultResponse apply(
                                    GetHostAgentScanResultRequest request) {
                                return client.getHostAgentScanResult(request);
                            }
                        },
                        new java.util.function.Predicate<GetHostAgentScanResultResponse>() {
                            @Override
                            public boolean test(GetHostAgentScanResultResponse response) {
                                return targetStatesSet.contains(
                                        response.getHostAgentScanResult().getLifecycleState());
                            }
                        },
                        targetStatesSet.contains(
                                com.oracle.bmc.vulnerabilityscanning.model.LifecycleState.Deleted)),
                request);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the default configuration.
     *
     * @param request the request to send
     * @param targetState the desired states to wait for. If multiple states are provided then the
     *     waiter will return once the resource reaches any of the provided states
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetHostCisBenchmarkScanResultRequest, GetHostCisBenchmarkScanResultResponse>
            forHostCisBenchmarkScanResult(
                    GetHostCisBenchmarkScanResultRequest request,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forHostCisBenchmarkScanResult(
                com.oracle.bmc.waiter.Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param targetState the desired state to wait for
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetHostCisBenchmarkScanResultRequest, GetHostCisBenchmarkScanResultResponse>
            forHostCisBenchmarkScanResult(
                    GetHostCisBenchmarkScanResultRequest request,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState targetState,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy) {
        com.oracle.bmc.util.internal.Validate.notNull(
                targetState, "The targetState cannot be null");

        return forHostCisBenchmarkScanResult(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetState);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @param targetStates the desired states to wait for. The waiter will return once the resource
     *     reaches any of the provided states
     * @return a new {@code Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetHostCisBenchmarkScanResultRequest, GetHostCisBenchmarkScanResultResponse>
            forHostCisBenchmarkScanResult(
                    GetHostCisBenchmarkScanResultRequest request,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forHostCisBenchmarkScanResult(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetStates);
    }

    // Helper method to create a new Waiter for HostCisBenchmarkScanResult.
    private com.oracle.bmc.waiter.Waiter<
                    GetHostCisBenchmarkScanResultRequest, GetHostCisBenchmarkScanResultResponse>
            forHostCisBenchmarkScanResult(
                    com.oracle.bmc.waiter.BmcGenericWaiter waiter,
                    final GetHostCisBenchmarkScanResultRequest request,
                    final com.oracle.bmc.vulnerabilityscanning.model.LifecycleState...
                            targetStates) {
        final java.util.Set<com.oracle.bmc.vulnerabilityscanning.model.LifecycleState>
                targetStatesSet = new java.util.HashSet<>(java.util.Arrays.asList(targetStates));

        return new com.oracle.bmc.waiter.internal.SimpleWaiterImpl<>(
                executorService,
                waiter.toCallable(
                        () -> request,
                        new java.util.function.Function<
                                GetHostCisBenchmarkScanResultRequest,
                                GetHostCisBenchmarkScanResultResponse>() {
                            @Override
                            public GetHostCisBenchmarkScanResultResponse apply(
                                    GetHostCisBenchmarkScanResultRequest request) {
                                return client.getHostCisBenchmarkScanResult(request);
                            }
                        },
                        new java.util.function.Predicate<GetHostCisBenchmarkScanResultResponse>() {
                            @Override
                            public boolean test(GetHostCisBenchmarkScanResultResponse response) {
                                return targetStatesSet.contains(
                                        response.getHostCisBenchmarkScanResult()
                                                .getLifecycleState());
                            }
                        },
                        targetStatesSet.contains(
                                com.oracle.bmc.vulnerabilityscanning.model.LifecycleState.Deleted)),
                request);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the default configuration.
     *
     * @param request the request to send
     * @param targetState the desired states to wait for. If multiple states are provided then the
     *     waiter will return once the resource reaches any of the provided states
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetHostEndpointProtectionScanResultRequest,
                    GetHostEndpointProtectionScanResultResponse>
            forHostEndpointProtectionScanResult(
                    GetHostEndpointProtectionScanResultRequest request,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forHostEndpointProtectionScanResult(
                com.oracle.bmc.waiter.Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param targetState the desired state to wait for
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetHostEndpointProtectionScanResultRequest,
                    GetHostEndpointProtectionScanResultResponse>
            forHostEndpointProtectionScanResult(
                    GetHostEndpointProtectionScanResultRequest request,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState targetState,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy) {
        com.oracle.bmc.util.internal.Validate.notNull(
                targetState, "The targetState cannot be null");

        return forHostEndpointProtectionScanResult(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetState);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @param targetStates the desired states to wait for. The waiter will return once the resource
     *     reaches any of the provided states
     * @return a new {@code Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetHostEndpointProtectionScanResultRequest,
                    GetHostEndpointProtectionScanResultResponse>
            forHostEndpointProtectionScanResult(
                    GetHostEndpointProtectionScanResultRequest request,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forHostEndpointProtectionScanResult(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetStates);
    }

    // Helper method to create a new Waiter for HostEndpointProtectionScanResult.
    private com.oracle.bmc.waiter.Waiter<
                    GetHostEndpointProtectionScanResultRequest,
                    GetHostEndpointProtectionScanResultResponse>
            forHostEndpointProtectionScanResult(
                    com.oracle.bmc.waiter.BmcGenericWaiter waiter,
                    final GetHostEndpointProtectionScanResultRequest request,
                    final com.oracle.bmc.vulnerabilityscanning.model.LifecycleState...
                            targetStates) {
        final java.util.Set<com.oracle.bmc.vulnerabilityscanning.model.LifecycleState>
                targetStatesSet = new java.util.HashSet<>(java.util.Arrays.asList(targetStates));

        return new com.oracle.bmc.waiter.internal.SimpleWaiterImpl<>(
                executorService,
                waiter.toCallable(
                        () -> request,
                        new java.util.function.Function<
                                GetHostEndpointProtectionScanResultRequest,
                                GetHostEndpointProtectionScanResultResponse>() {
                            @Override
                            public GetHostEndpointProtectionScanResultResponse apply(
                                    GetHostEndpointProtectionScanResultRequest request) {
                                return client.getHostEndpointProtectionScanResult(request);
                            }
                        },
                        new java.util.function.Predicate<
                                GetHostEndpointProtectionScanResultResponse>() {
                            @Override
                            public boolean test(
                                    GetHostEndpointProtectionScanResultResponse response) {
                                return targetStatesSet.contains(
                                        response.getHostEndpointProtectionScanResult()
                                                .getLifecycleState());
                            }
                        },
                        targetStatesSet.contains(
                                com.oracle.bmc.vulnerabilityscanning.model.LifecycleState.Deleted)),
                request);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the default configuration.
     *
     * @param request the request to send
     * @param targetState the desired states to wait for. If multiple states are provided then the
     *     waiter will return once the resource reaches any of the provided states
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetHostPortScanResultRequest, GetHostPortScanResultResponse>
            forHostPortScanResult(
                    GetHostPortScanResultRequest request,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forHostPortScanResult(
                com.oracle.bmc.waiter.Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param targetState the desired state to wait for
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetHostPortScanResultRequest, GetHostPortScanResultResponse>
            forHostPortScanResult(
                    GetHostPortScanResultRequest request,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState targetState,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy) {
        com.oracle.bmc.util.internal.Validate.notNull(
                targetState, "The targetState cannot be null");

        return forHostPortScanResult(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetState);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @param targetStates the desired states to wait for. The waiter will return once the resource
     *     reaches any of the provided states
     * @return a new {@code Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetHostPortScanResultRequest, GetHostPortScanResultResponse>
            forHostPortScanResult(
                    GetHostPortScanResultRequest request,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forHostPortScanResult(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetStates);
    }

    // Helper method to create a new Waiter for HostPortScanResult.
    private com.oracle.bmc.waiter.Waiter<
                    GetHostPortScanResultRequest, GetHostPortScanResultResponse>
            forHostPortScanResult(
                    com.oracle.bmc.waiter.BmcGenericWaiter waiter,
                    final GetHostPortScanResultRequest request,
                    final com.oracle.bmc.vulnerabilityscanning.model.LifecycleState...
                            targetStates) {
        final java.util.Set<com.oracle.bmc.vulnerabilityscanning.model.LifecycleState>
                targetStatesSet = new java.util.HashSet<>(java.util.Arrays.asList(targetStates));

        return new com.oracle.bmc.waiter.internal.SimpleWaiterImpl<>(
                executorService,
                waiter.toCallable(
                        () -> request,
                        new java.util.function.Function<
                                GetHostPortScanResultRequest, GetHostPortScanResultResponse>() {
                            @Override
                            public GetHostPortScanResultResponse apply(
                                    GetHostPortScanResultRequest request) {
                                return client.getHostPortScanResult(request);
                            }
                        },
                        new java.util.function.Predicate<GetHostPortScanResultResponse>() {
                            @Override
                            public boolean test(GetHostPortScanResultResponse response) {
                                return targetStatesSet.contains(
                                        response.getHostPortScanResult().getLifecycleState());
                            }
                        },
                        targetStatesSet.contains(
                                com.oracle.bmc.vulnerabilityscanning.model.LifecycleState.Deleted)),
                request);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the default configuration.
     *
     * @param request the request to send
     * @param targetState the desired states to wait for. If multiple states are provided then the
     *     waiter will return once the resource reaches any of the provided states
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetHostScanRecipeRequest, GetHostScanRecipeResponse>
            forHostScanRecipe(
                    GetHostScanRecipeRequest request,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forHostScanRecipe(
                com.oracle.bmc.waiter.Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param targetState the desired state to wait for
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetHostScanRecipeRequest, GetHostScanRecipeResponse>
            forHostScanRecipe(
                    GetHostScanRecipeRequest request,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState targetState,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy) {
        com.oracle.bmc.util.internal.Validate.notNull(
                targetState, "The targetState cannot be null");

        return forHostScanRecipe(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetState);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @param targetStates the desired states to wait for. The waiter will return once the resource
     *     reaches any of the provided states
     * @return a new {@code Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetHostScanRecipeRequest, GetHostScanRecipeResponse>
            forHostScanRecipe(
                    GetHostScanRecipeRequest request,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forHostScanRecipe(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetStates);
    }

    // Helper method to create a new Waiter for HostScanRecipe.
    private com.oracle.bmc.waiter.Waiter<GetHostScanRecipeRequest, GetHostScanRecipeResponse>
            forHostScanRecipe(
                    com.oracle.bmc.waiter.BmcGenericWaiter waiter,
                    final GetHostScanRecipeRequest request,
                    final com.oracle.bmc.vulnerabilityscanning.model.LifecycleState...
                            targetStates) {
        final java.util.Set<com.oracle.bmc.vulnerabilityscanning.model.LifecycleState>
                targetStatesSet = new java.util.HashSet<>(java.util.Arrays.asList(targetStates));

        return new com.oracle.bmc.waiter.internal.SimpleWaiterImpl<>(
                executorService,
                waiter.toCallable(
                        () -> request,
                        new java.util.function.Function<
                                GetHostScanRecipeRequest, GetHostScanRecipeResponse>() {
                            @Override
                            public GetHostScanRecipeResponse apply(
                                    GetHostScanRecipeRequest request) {
                                return client.getHostScanRecipe(request);
                            }
                        },
                        new java.util.function.Predicate<GetHostScanRecipeResponse>() {
                            @Override
                            public boolean test(GetHostScanRecipeResponse response) {
                                return targetStatesSet.contains(
                                        response.getHostScanRecipe().getLifecycleState());
                            }
                        },
                        targetStatesSet.contains(
                                com.oracle.bmc.vulnerabilityscanning.model.LifecycleState.Deleted)),
                request);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the default configuration.
     *
     * @param request the request to send
     * @param targetState the desired states to wait for. If multiple states are provided then the
     *     waiter will return once the resource reaches any of the provided states
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetHostScanTargetRequest, GetHostScanTargetResponse>
            forHostScanTarget(
                    GetHostScanTargetRequest request,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forHostScanTarget(
                com.oracle.bmc.waiter.Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param targetState the desired state to wait for
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetHostScanTargetRequest, GetHostScanTargetResponse>
            forHostScanTarget(
                    GetHostScanTargetRequest request,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState targetState,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy) {
        com.oracle.bmc.util.internal.Validate.notNull(
                targetState, "The targetState cannot be null");

        return forHostScanTarget(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetState);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @param targetStates the desired states to wait for. The waiter will return once the resource
     *     reaches any of the provided states
     * @return a new {@code Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetHostScanTargetRequest, GetHostScanTargetResponse>
            forHostScanTarget(
                    GetHostScanTargetRequest request,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forHostScanTarget(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetStates);
    }

    // Helper method to create a new Waiter for HostScanTarget.
    private com.oracle.bmc.waiter.Waiter<GetHostScanTargetRequest, GetHostScanTargetResponse>
            forHostScanTarget(
                    com.oracle.bmc.waiter.BmcGenericWaiter waiter,
                    final GetHostScanTargetRequest request,
                    final com.oracle.bmc.vulnerabilityscanning.model.LifecycleState...
                            targetStates) {
        final java.util.Set<com.oracle.bmc.vulnerabilityscanning.model.LifecycleState>
                targetStatesSet = new java.util.HashSet<>(java.util.Arrays.asList(targetStates));

        return new com.oracle.bmc.waiter.internal.SimpleWaiterImpl<>(
                executorService,
                waiter.toCallable(
                        () -> request,
                        new java.util.function.Function<
                                GetHostScanTargetRequest, GetHostScanTargetResponse>() {
                            @Override
                            public GetHostScanTargetResponse apply(
                                    GetHostScanTargetRequest request) {
                                return client.getHostScanTarget(request);
                            }
                        },
                        new java.util.function.Predicate<GetHostScanTargetResponse>() {
                            @Override
                            public boolean test(GetHostScanTargetResponse response) {
                                return targetStatesSet.contains(
                                        response.getHostScanTarget().getLifecycleState());
                            }
                        },
                        targetStatesSet.contains(
                                com.oracle.bmc.vulnerabilityscanning.model.LifecycleState.Deleted)),
                request);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the default configuration.
     *
     * @param request the request to send
     * @param targetState the desired states to wait for. If multiple states are provided then the
     *     waiter will return once the resource reaches any of the provided states
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetHostVulnerabilityRequest, GetHostVulnerabilityResponse>
            forHostVulnerability(
                    GetHostVulnerabilityRequest request,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forHostVulnerability(
                com.oracle.bmc.waiter.Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param targetState the desired state to wait for
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetHostVulnerabilityRequest, GetHostVulnerabilityResponse>
            forHostVulnerability(
                    GetHostVulnerabilityRequest request,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState targetState,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy) {
        com.oracle.bmc.util.internal.Validate.notNull(
                targetState, "The targetState cannot be null");

        return forHostVulnerability(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetState);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @param targetStates the desired states to wait for. The waiter will return once the resource
     *     reaches any of the provided states
     * @return a new {@code Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetHostVulnerabilityRequest, GetHostVulnerabilityResponse>
            forHostVulnerability(
                    GetHostVulnerabilityRequest request,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forHostVulnerability(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetStates);
    }

    // Helper method to create a new Waiter for HostVulnerability.
    private com.oracle.bmc.waiter.Waiter<GetHostVulnerabilityRequest, GetHostVulnerabilityResponse>
            forHostVulnerability(
                    com.oracle.bmc.waiter.BmcGenericWaiter waiter,
                    final GetHostVulnerabilityRequest request,
                    final com.oracle.bmc.vulnerabilityscanning.model.LifecycleState...
                            targetStates) {
        final java.util.Set<com.oracle.bmc.vulnerabilityscanning.model.LifecycleState>
                targetStatesSet = new java.util.HashSet<>(java.util.Arrays.asList(targetStates));

        return new com.oracle.bmc.waiter.internal.SimpleWaiterImpl<>(
                executorService,
                waiter.toCallable(
                        () -> request,
                        new java.util.function.Function<
                                GetHostVulnerabilityRequest, GetHostVulnerabilityResponse>() {
                            @Override
                            public GetHostVulnerabilityResponse apply(
                                    GetHostVulnerabilityRequest request) {
                                return client.getHostVulnerability(request);
                            }
                        },
                        new java.util.function.Predicate<GetHostVulnerabilityResponse>() {
                            @Override
                            public boolean test(GetHostVulnerabilityResponse response) {
                                return targetStatesSet.contains(
                                        response.getHostVulnerability().getLifecycleState());
                            }
                        },
                        targetStatesSet.contains(
                                com.oracle.bmc.vulnerabilityscanning.model.LifecycleState.Deleted)),
                request);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the default configuration.
     *
     * @param request the request to send
     * @param targetState the desired states to wait for. If multiple states are provided then the
     *     waiter will return once the resource reaches any of the provided states
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetVulnerabilityRequest, GetVulnerabilityResponse>
            forVulnerability(
                    GetVulnerabilityRequest request,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forVulnerability(
                com.oracle.bmc.waiter.Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param targetState the desired state to wait for
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetVulnerabilityRequest, GetVulnerabilityResponse>
            forVulnerability(
                    GetVulnerabilityRequest request,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState targetState,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy) {
        com.oracle.bmc.util.internal.Validate.notNull(
                targetState, "The targetState cannot be null");

        return forVulnerability(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetState);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @param targetStates the desired states to wait for. The waiter will return once the resource
     *     reaches any of the provided states
     * @return a new {@code Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetVulnerabilityRequest, GetVulnerabilityResponse>
            forVulnerability(
                    GetVulnerabilityRequest request,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy,
                    com.oracle.bmc.vulnerabilityscanning.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forVulnerability(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetStates);
    }

    // Helper method to create a new Waiter for Vulnerability.
    private com.oracle.bmc.waiter.Waiter<GetVulnerabilityRequest, GetVulnerabilityResponse>
            forVulnerability(
                    com.oracle.bmc.waiter.BmcGenericWaiter waiter,
                    final GetVulnerabilityRequest request,
                    final com.oracle.bmc.vulnerabilityscanning.model.LifecycleState...
                            targetStates) {
        final java.util.Set<com.oracle.bmc.vulnerabilityscanning.model.LifecycleState>
                targetStatesSet = new java.util.HashSet<>(java.util.Arrays.asList(targetStates));

        return new com.oracle.bmc.waiter.internal.SimpleWaiterImpl<>(
                executorService,
                waiter.toCallable(
                        () -> request,
                        new java.util.function.Function<
                                GetVulnerabilityRequest, GetVulnerabilityResponse>() {
                            @Override
                            public GetVulnerabilityResponse apply(GetVulnerabilityRequest request) {
                                return client.getVulnerability(request);
                            }
                        },
                        new java.util.function.Predicate<GetVulnerabilityResponse>() {
                            @Override
                            public boolean test(GetVulnerabilityResponse response) {
                                return targetStatesSet.contains(
                                        response.getVulnerability().getLifecycleState());
                            }
                        },
                        targetStatesSet.contains(
                                com.oracle.bmc.vulnerabilityscanning.model.LifecycleState.Deleted)),
                request);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using default configuration.
     *
     * @param request the request to send
     * @return a new {@code Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetWorkRequestRequest, GetWorkRequestResponse>
            forWorkRequest(GetWorkRequestRequest request) {
        return forWorkRequest(com.oracle.bmc.waiter.Waiters.DEFAULT_POLLING_WAITER, request);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@linkcom.oracle.bmc.waiter. DelayStrategy} to use
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetWorkRequestRequest, GetWorkRequestResponse>
            forWorkRequest(
                    GetWorkRequestRequest request,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy) {
        return forWorkRequest(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request);
    }

    // Helper method to create a new Waiter for WorkRequest.
    private com.oracle.bmc.waiter.Waiter<GetWorkRequestRequest, GetWorkRequestResponse>
            forWorkRequest(
                    com.oracle.bmc.waiter.BmcGenericWaiter waiter,
                    final GetWorkRequestRequest request) {
        return new com.oracle.bmc.waiter.internal.SimpleWaiterImpl<>(
                executorService,
                waiter.toCallable(
                        () -> request,
                        new java.util.function.Function<
                                GetWorkRequestRequest, GetWorkRequestResponse>() {
                            @Override
                            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                                return client.getWorkRequest(request);
                            }
                        },
                        new java.util.function.Predicate<GetWorkRequestResponse>() {
                            @Override
                            public boolean test(GetWorkRequestResponse response) {
                                // work requests are complete once the time finished is available
                                return response.getWorkRequest().getTimeFinished() != null;
                            }
                        },
                        false),
                request);
    }
}
