/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

/**
 * Agent scan settings for applicaiton scan <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = ApplicationScanSettings.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class ApplicationScanSettings
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({"applicationScanRecurrence", "isEnabled", "foldersToScan"})
    public ApplicationScanSettings(
            String applicationScanRecurrence,
            Boolean isEnabled,
            java.util.List<FolderToScan> foldersToScan) {
        super();
        this.applicationScanRecurrence = applicationScanRecurrence;
        this.isEnabled = isEnabled;
        this.foldersToScan = foldersToScan;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /**
         * Scan recurrences in RFC-5545 section 3.3.10 format. Only supported input are weekly,
         * biweekly, monthly listed below FREQ=WEEKLY;WKST=<weekday>;INTERVAL=1 - This weekly scan
         * on the specified weekday (e.g. Sunday) FREQ=WEEKLY;WKST=<weekday>;INTERVAL=2 - This
         * bi-weekly scan on the specified weekday (e.g. Sunday)
         * FREQ=MONTHLY;WKST=<weekday>;INTERVAL=1 - This monthly scan on the specified weekday (e.g.
         * Sunday, starting from the next such weekday based on the time of setting creation)
         */
        @com.fasterxml.jackson.annotation.JsonProperty("applicationScanRecurrence")
        private String applicationScanRecurrence;

        /**
         * Scan recurrences in RFC-5545 section 3.3.10 format. Only supported input are weekly,
         * biweekly, monthly listed below FREQ=WEEKLY;WKST=<weekday>;INTERVAL=1 - This weekly scan
         * on the specified weekday (e.g. Sunday) FREQ=WEEKLY;WKST=<weekday>;INTERVAL=2 - This
         * bi-weekly scan on the specified weekday (e.g. Sunday)
         * FREQ=MONTHLY;WKST=<weekday>;INTERVAL=1 - This monthly scan on the specified weekday (e.g.
         * Sunday, starting from the next such weekday based on the time of setting creation)
         *
         * @param applicationScanRecurrence the value to set
         * @return this builder
         */
        public Builder applicationScanRecurrence(String applicationScanRecurrence) {
            this.applicationScanRecurrence = applicationScanRecurrence;
            this.__explicitlySet__.add("applicationScanRecurrence");
            return this;
        }
        /** Enable or disable application scan */
        @com.fasterxml.jackson.annotation.JsonProperty("isEnabled")
        private Boolean isEnabled;

        /**
         * Enable or disable application scan
         *
         * @param isEnabled the value to set
         * @return this builder
         */
        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }
        /** List of folders selected for scanning */
        @com.fasterxml.jackson.annotation.JsonProperty("foldersToScan")
        private java.util.List<FolderToScan> foldersToScan;

        /**
         * List of folders selected for scanning
         *
         * @param foldersToScan the value to set
         * @return this builder
         */
        public Builder foldersToScan(java.util.List<FolderToScan> foldersToScan) {
            this.foldersToScan = foldersToScan;
            this.__explicitlySet__.add("foldersToScan");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public ApplicationScanSettings build() {
            ApplicationScanSettings model =
                    new ApplicationScanSettings(
                            this.applicationScanRecurrence, this.isEnabled, this.foldersToScan);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(ApplicationScanSettings model) {
            if (model.wasPropertyExplicitlySet("applicationScanRecurrence")) {
                this.applicationScanRecurrence(model.getApplicationScanRecurrence());
            }
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("foldersToScan")) {
                this.foldersToScan(model.getFoldersToScan());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /**
     * Scan recurrences in RFC-5545 section 3.3.10 format. Only supported input are weekly,
     * biweekly, monthly listed below FREQ=WEEKLY;WKST=<weekday>;INTERVAL=1 - This weekly scan on
     * the specified weekday (e.g. Sunday) FREQ=WEEKLY;WKST=<weekday>;INTERVAL=2 - This bi-weekly
     * scan on the specified weekday (e.g. Sunday) FREQ=MONTHLY;WKST=<weekday>;INTERVAL=1 - This
     * monthly scan on the specified weekday (e.g. Sunday, starting from the next such weekday based
     * on the time of setting creation)
     */
    @com.fasterxml.jackson.annotation.JsonProperty("applicationScanRecurrence")
    private final String applicationScanRecurrence;

    /**
     * Scan recurrences in RFC-5545 section 3.3.10 format. Only supported input are weekly,
     * biweekly, monthly listed below FREQ=WEEKLY;WKST=<weekday>;INTERVAL=1 - This weekly scan on
     * the specified weekday (e.g. Sunday) FREQ=WEEKLY;WKST=<weekday>;INTERVAL=2 - This bi-weekly
     * scan on the specified weekday (e.g. Sunday) FREQ=MONTHLY;WKST=<weekday>;INTERVAL=1 - This
     * monthly scan on the specified weekday (e.g. Sunday, starting from the next such weekday based
     * on the time of setting creation)
     *
     * @return the value
     */
    public String getApplicationScanRecurrence() {
        return applicationScanRecurrence;
    }

    /** Enable or disable application scan */
    @com.fasterxml.jackson.annotation.JsonProperty("isEnabled")
    private final Boolean isEnabled;

    /**
     * Enable or disable application scan
     *
     * @return the value
     */
    public Boolean getIsEnabled() {
        return isEnabled;
    }

    /** List of folders selected for scanning */
    @com.fasterxml.jackson.annotation.JsonProperty("foldersToScan")
    private final java.util.List<FolderToScan> foldersToScan;

    /**
     * List of folders selected for scanning
     *
     * @return the value
     */
    public java.util.List<FolderToScan> getFoldersToScan() {
        return foldersToScan;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("ApplicationScanSettings(");
        sb.append("super=").append(super.toString());
        sb.append("applicationScanRecurrence=")
                .append(String.valueOf(this.applicationScanRecurrence));
        sb.append(", isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", foldersToScan=").append(String.valueOf(this.foldersToScan));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplicationScanSettings)) {
            return false;
        }

        ApplicationScanSettings other = (ApplicationScanSettings) o;
        return java.util.Objects.equals(
                        this.applicationScanRecurrence, other.applicationScanRecurrence)
                && java.util.Objects.equals(this.isEnabled, other.isEnabled)
                && java.util.Objects.equals(this.foldersToScan, other.foldersToScan)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result =
                (result * PRIME)
                        + (this.applicationScanRecurrence == null
                                ? 43
                                : this.applicationScanRecurrence.hashCode());
        result = (result * PRIME) + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result =
                (result * PRIME)
                        + (this.foldersToScan == null ? 43 : this.foldersToScan.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
