/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

/**
 * Details for a HostAgentScan list export to CSV action <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = ExportHostAgentScanResultCsvDetails.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class ExportHostAgentScanResultCsvDetails
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "compartmentId",
        "timeStartedAfter",
        "timeStartedBefore",
        "highestProblemSeverity",
        "instanceId",
        "operatingSystem"
    })
    public ExportHostAgentScanResultCsvDetails(
            String compartmentId,
            java.util.Date timeStartedAfter,
            java.util.Date timeStartedBefore,
            ScanResultProblemSeverity highestProblemSeverity,
            String instanceId,
            String operatingSystem) {
        super();
        this.compartmentId = compartmentId;
        this.timeStartedAfter = timeStartedAfter;
        this.timeStartedBefore = timeStartedBefore;
        this.highestProblemSeverity = highestProblemSeverity;
        this.instanceId = instanceId;
        this.operatingSystem = operatingSystem;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /**
         * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
         * compartment to list scans in.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
        private String compartmentId;

        /**
         * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
         * compartment to list scans in.
         *
         * @param compartmentId the value to set
         * @return this builder
         */
        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }
        /**
         * Date and time after which scans were started, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         */
        @com.fasterxml.jackson.annotation.JsonProperty("timeStartedAfter")
        private java.util.Date timeStartedAfter;

        /**
         * Date and time after which scans were started, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         *
         * @param timeStartedAfter the value to set
         * @return this builder
         */
        public Builder timeStartedAfter(java.util.Date timeStartedAfter) {
            this.timeStartedAfter = timeStartedAfter;
            this.__explicitlySet__.add("timeStartedAfter");
            return this;
        }
        /**
         * Date and time before which scans were started, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         */
        @com.fasterxml.jackson.annotation.JsonProperty("timeStartedBefore")
        private java.util.Date timeStartedBefore;

        /**
         * Date and time before which scans were started, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         *
         * @param timeStartedBefore the value to set
         * @return this builder
         */
        public Builder timeStartedBefore(java.util.Date timeStartedBefore) {
            this.timeStartedBefore = timeStartedBefore;
            this.__explicitlySet__.add("timeStartedBefore");
            return this;
        }
        /** Parameter to filter by highestProblemSeverity for scan results */
        @com.fasterxml.jackson.annotation.JsonProperty("highestProblemSeverity")
        private ScanResultProblemSeverity highestProblemSeverity;

        /**
         * Parameter to filter by highestProblemSeverity for scan results
         *
         * @param highestProblemSeverity the value to set
         * @return this builder
         */
        public Builder highestProblemSeverity(ScanResultProblemSeverity highestProblemSeverity) {
            this.highestProblemSeverity = highestProblemSeverity;
            this.__explicitlySet__.add("highestProblemSeverity");
            return this;
        }
        /** Parameter to filter by a single compute instance ID for scan results */
        @com.fasterxml.jackson.annotation.JsonProperty("instanceId")
        private String instanceId;

        /**
         * Parameter to filter by a single compute instance ID for scan results
         *
         * @param instanceId the value to set
         * @return this builder
         */
        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            this.__explicitlySet__.add("instanceId");
            return this;
        }
        /** Parameter to filter by operating system for scan results */
        @com.fasterxml.jackson.annotation.JsonProperty("operatingSystem")
        private String operatingSystem;

        /**
         * Parameter to filter by operating system for scan results
         *
         * @param operatingSystem the value to set
         * @return this builder
         */
        public Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            this.__explicitlySet__.add("operatingSystem");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public ExportHostAgentScanResultCsvDetails build() {
            ExportHostAgentScanResultCsvDetails model =
                    new ExportHostAgentScanResultCsvDetails(
                            this.compartmentId,
                            this.timeStartedAfter,
                            this.timeStartedBefore,
                            this.highestProblemSeverity,
                            this.instanceId,
                            this.operatingSystem);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(ExportHostAgentScanResultCsvDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("timeStartedAfter")) {
                this.timeStartedAfter(model.getTimeStartedAfter());
            }
            if (model.wasPropertyExplicitlySet("timeStartedBefore")) {
                this.timeStartedBefore(model.getTimeStartedBefore());
            }
            if (model.wasPropertyExplicitlySet("highestProblemSeverity")) {
                this.highestProblemSeverity(model.getHighestProblemSeverity());
            }
            if (model.wasPropertyExplicitlySet("instanceId")) {
                this.instanceId(model.getInstanceId());
            }
            if (model.wasPropertyExplicitlySet("operatingSystem")) {
                this.operatingSystem(model.getOperatingSystem());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /**
     * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
     * compartment to list scans in.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
    private final String compartmentId;

    /**
     * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
     * compartment to list scans in.
     *
     * @return the value
     */
    public String getCompartmentId() {
        return compartmentId;
    }

    /**
     * Date and time after which scans were started, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     */
    @com.fasterxml.jackson.annotation.JsonProperty("timeStartedAfter")
    private final java.util.Date timeStartedAfter;

    /**
     * Date and time after which scans were started, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     *
     * @return the value
     */
    public java.util.Date getTimeStartedAfter() {
        return timeStartedAfter;
    }

    /**
     * Date and time before which scans were started, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     */
    @com.fasterxml.jackson.annotation.JsonProperty("timeStartedBefore")
    private final java.util.Date timeStartedBefore;

    /**
     * Date and time before which scans were started, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     *
     * @return the value
     */
    public java.util.Date getTimeStartedBefore() {
        return timeStartedBefore;
    }

    /** Parameter to filter by highestProblemSeverity for scan results */
    @com.fasterxml.jackson.annotation.JsonProperty("highestProblemSeverity")
    private final ScanResultProblemSeverity highestProblemSeverity;

    /**
     * Parameter to filter by highestProblemSeverity for scan results
     *
     * @return the value
     */
    public ScanResultProblemSeverity getHighestProblemSeverity() {
        return highestProblemSeverity;
    }

    /** Parameter to filter by a single compute instance ID for scan results */
    @com.fasterxml.jackson.annotation.JsonProperty("instanceId")
    private final String instanceId;

    /**
     * Parameter to filter by a single compute instance ID for scan results
     *
     * @return the value
     */
    public String getInstanceId() {
        return instanceId;
    }

    /** Parameter to filter by operating system for scan results */
    @com.fasterxml.jackson.annotation.JsonProperty("operatingSystem")
    private final String operatingSystem;

    /**
     * Parameter to filter by operating system for scan results
     *
     * @return the value
     */
    public String getOperatingSystem() {
        return operatingSystem;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("ExportHostAgentScanResultCsvDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", timeStartedAfter=").append(String.valueOf(this.timeStartedAfter));
        sb.append(", timeStartedBefore=").append(String.valueOf(this.timeStartedBefore));
        sb.append(", highestProblemSeverity=").append(String.valueOf(this.highestProblemSeverity));
        sb.append(", instanceId=").append(String.valueOf(this.instanceId));
        sb.append(", operatingSystem=").append(String.valueOf(this.operatingSystem));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExportHostAgentScanResultCsvDetails)) {
            return false;
        }

        ExportHostAgentScanResultCsvDetails other = (ExportHostAgentScanResultCsvDetails) o;
        return java.util.Objects.equals(this.compartmentId, other.compartmentId)
                && java.util.Objects.equals(this.timeStartedAfter, other.timeStartedAfter)
                && java.util.Objects.equals(this.timeStartedBefore, other.timeStartedBefore)
                && java.util.Objects.equals(
                        this.highestProblemSeverity, other.highestProblemSeverity)
                && java.util.Objects.equals(this.instanceId, other.instanceId)
                && java.util.Objects.equals(this.operatingSystem, other.operatingSystem)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result =
                (result * PRIME)
                        + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result =
                (result * PRIME)
                        + (this.timeStartedAfter == null ? 43 : this.timeStartedAfter.hashCode());
        result =
                (result * PRIME)
                        + (this.timeStartedBefore == null ? 43 : this.timeStartedBefore.hashCode());
        result =
                (result * PRIME)
                        + (this.highestProblemSeverity == null
                                ? 43
                                : this.highestProblemSeverity.hashCode());
        result = (result * PRIME) + (this.instanceId == null ? 43 : this.instanceId.hashCode());
        result =
                (result * PRIME)
                        + (this.operatingSystem == null ? 43 : this.operatingSystem.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
