/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

/**
 * Details for a Host Vulnerability list export to CSV action <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = ExportHostVulnerabilityCsvDetails.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class ExportHostVulnerabilityCsvDetails
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "compartmentId",
        "timeLastDetectedGreaterThanOrEqualTo",
        "timeLastDetectedLessThanOrEqualTo"
    })
    public ExportHostVulnerabilityCsvDetails(
            String compartmentId,
            java.util.Date timeLastDetectedGreaterThanOrEqualTo,
            java.util.Date timeLastDetectedLessThanOrEqualTo) {
        super();
        this.compartmentId = compartmentId;
        this.timeLastDetectedGreaterThanOrEqualTo = timeLastDetectedGreaterThanOrEqualTo;
        this.timeLastDetectedLessThanOrEqualTo = timeLastDetectedLessThanOrEqualTo;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /**
         * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
         * compartment to list vulnerabilities in.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
        private String compartmentId;

        /**
         * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
         * compartment to list vulnerabilities in.
         *
         * @param compartmentId the value to set
         * @return this builder
         */
        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }
        /**
         * Date and time on or after which this vulnerability was last detected, as described in
         * [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
         */
        @com.fasterxml.jackson.annotation.JsonProperty("timeLastDetectedGreaterThanOrEqualTo")
        private java.util.Date timeLastDetectedGreaterThanOrEqualTo;

        /**
         * Date and time on or after which this vulnerability was last detected, as described in
         * [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
         *
         * @param timeLastDetectedGreaterThanOrEqualTo the value to set
         * @return this builder
         */
        public Builder timeLastDetectedGreaterThanOrEqualTo(
                java.util.Date timeLastDetectedGreaterThanOrEqualTo) {
            this.timeLastDetectedGreaterThanOrEqualTo = timeLastDetectedGreaterThanOrEqualTo;
            this.__explicitlySet__.add("timeLastDetectedGreaterThanOrEqualTo");
            return this;
        }
        /**
         * Date and time on or before which this vulnerability was last detected, as described in
         * [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
         */
        @com.fasterxml.jackson.annotation.JsonProperty("timeLastDetectedLessThanOrEqualTo")
        private java.util.Date timeLastDetectedLessThanOrEqualTo;

        /**
         * Date and time on or before which this vulnerability was last detected, as described in
         * [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
         *
         * @param timeLastDetectedLessThanOrEqualTo the value to set
         * @return this builder
         */
        public Builder timeLastDetectedLessThanOrEqualTo(
                java.util.Date timeLastDetectedLessThanOrEqualTo) {
            this.timeLastDetectedLessThanOrEqualTo = timeLastDetectedLessThanOrEqualTo;
            this.__explicitlySet__.add("timeLastDetectedLessThanOrEqualTo");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public ExportHostVulnerabilityCsvDetails build() {
            ExportHostVulnerabilityCsvDetails model =
                    new ExportHostVulnerabilityCsvDetails(
                            this.compartmentId,
                            this.timeLastDetectedGreaterThanOrEqualTo,
                            this.timeLastDetectedLessThanOrEqualTo);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(ExportHostVulnerabilityCsvDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("timeLastDetectedGreaterThanOrEqualTo")) {
                this.timeLastDetectedGreaterThanOrEqualTo(
                        model.getTimeLastDetectedGreaterThanOrEqualTo());
            }
            if (model.wasPropertyExplicitlySet("timeLastDetectedLessThanOrEqualTo")) {
                this.timeLastDetectedLessThanOrEqualTo(
                        model.getTimeLastDetectedLessThanOrEqualTo());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /**
     * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
     * compartment to list vulnerabilities in.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
    private final String compartmentId;

    /**
     * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
     * compartment to list vulnerabilities in.
     *
     * @return the value
     */
    public String getCompartmentId() {
        return compartmentId;
    }

    /**
     * Date and time on or after which this vulnerability was last detected, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     */
    @com.fasterxml.jackson.annotation.JsonProperty("timeLastDetectedGreaterThanOrEqualTo")
    private final java.util.Date timeLastDetectedGreaterThanOrEqualTo;

    /**
     * Date and time on or after which this vulnerability was last detected, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     *
     * @return the value
     */
    public java.util.Date getTimeLastDetectedGreaterThanOrEqualTo() {
        return timeLastDetectedGreaterThanOrEqualTo;
    }

    /**
     * Date and time on or before which this vulnerability was last detected, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     */
    @com.fasterxml.jackson.annotation.JsonProperty("timeLastDetectedLessThanOrEqualTo")
    private final java.util.Date timeLastDetectedLessThanOrEqualTo;

    /**
     * Date and time on or before which this vulnerability was last detected, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     *
     * @return the value
     */
    public java.util.Date getTimeLastDetectedLessThanOrEqualTo() {
        return timeLastDetectedLessThanOrEqualTo;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("ExportHostVulnerabilityCsvDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", timeLastDetectedGreaterThanOrEqualTo=")
                .append(String.valueOf(this.timeLastDetectedGreaterThanOrEqualTo));
        sb.append(", timeLastDetectedLessThanOrEqualTo=")
                .append(String.valueOf(this.timeLastDetectedLessThanOrEqualTo));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExportHostVulnerabilityCsvDetails)) {
            return false;
        }

        ExportHostVulnerabilityCsvDetails other = (ExportHostVulnerabilityCsvDetails) o;
        return java.util.Objects.equals(this.compartmentId, other.compartmentId)
                && java.util.Objects.equals(
                        this.timeLastDetectedGreaterThanOrEqualTo,
                        other.timeLastDetectedGreaterThanOrEqualTo)
                && java.util.Objects.equals(
                        this.timeLastDetectedLessThanOrEqualTo,
                        other.timeLastDetectedLessThanOrEqualTo)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result =
                (result * PRIME)
                        + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result =
                (result * PRIME)
                        + (this.timeLastDetectedGreaterThanOrEqualTo == null
                                ? 43
                                : this.timeLastDetectedGreaterThanOrEqualTo.hashCode());
        result =
                (result * PRIME)
                        + (this.timeLastDetectedLessThanOrEqualTo == null
                                ? 43
                                : this.timeLastDetectedLessThanOrEqualTo.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
