/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

/**
 * A problem found in a host agent scan <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = HostAgentScanResultProblem.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class HostAgentScanResultProblem
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "name",
        "description",
        "severity",
        "state",
        "cveReference",
        "issueId",
        "timeFirstDetected",
        "timeLastDetected",
        "vulnerablePackages"
    })
    public HostAgentScanResultProblem(
            String name,
            String description,
            ScanResultProblemSeverity severity,
            ScanResultVulnerabilityState state,
            String cveReference,
            Integer issueId,
            java.util.Date timeFirstDetected,
            java.util.Date timeLastDetected,
            java.util.List<Package> vulnerablePackages) {
        super();
        this.name = name;
        this.description = description;
        this.severity = severity;
        this.state = state;
        this.cveReference = cveReference;
        this.issueId = issueId;
        this.timeFirstDetected = timeFirstDetected;
        this.timeLastDetected = timeLastDetected;
        this.vulnerablePackages = vulnerablePackages;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /** Name of the problem */
        @com.fasterxml.jackson.annotation.JsonProperty("name")
        private String name;

        /**
         * Name of the problem
         *
         * @param name the value to set
         * @return this builder
         */
        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }
        /** Problem description */
        @com.fasterxml.jackson.annotation.JsonProperty("description")
        private String description;

        /**
         * Problem description
         *
         * @param description the value to set
         * @return this builder
         */
        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }
        /** Problem severity */
        @com.fasterxml.jackson.annotation.JsonProperty("severity")
        private ScanResultProblemSeverity severity;

        /**
         * Problem severity
         *
         * @param severity the value to set
         * @return this builder
         */
        public Builder severity(ScanResultProblemSeverity severity) {
            this.severity = severity;
            this.__explicitlySet__.add("severity");
            return this;
        }
        /** State of the vulnerability */
        @com.fasterxml.jackson.annotation.JsonProperty("state")
        private ScanResultVulnerabilityState state;

        /**
         * State of the vulnerability
         *
         * @param state the value to set
         * @return this builder
         */
        public Builder state(ScanResultVulnerabilityState state) {
            this.state = state;
            this.__explicitlySet__.add("state");
            return this;
        }
        /** Reference to problem MITRE CVE ID */
        @com.fasterxml.jackson.annotation.JsonProperty("cveReference")
        private String cveReference;

        /**
         * Reference to problem MITRE CVE ID
         *
         * @param cveReference the value to set
         * @return this builder
         */
        public Builder cveReference(String cveReference) {
            this.cveReference = cveReference;
            this.__explicitlySet__.add("cveReference");
            return this;
        }
        /** Reference to problem issue ID */
        @com.fasterxml.jackson.annotation.JsonProperty("issueId")
        private Integer issueId;

        /**
         * Reference to problem issue ID
         *
         * @param issueId the value to set
         * @return this builder
         */
        public Builder issueId(Integer issueId) {
            this.issueId = issueId;
            this.__explicitlySet__.add("issueId");
            return this;
        }
        /** Date of scan result that first reported the vulnerability */
        @com.fasterxml.jackson.annotation.JsonProperty("timeFirstDetected")
        private java.util.Date timeFirstDetected;

        /**
         * Date of scan result that first reported the vulnerability
         *
         * @param timeFirstDetected the value to set
         * @return this builder
         */
        public Builder timeFirstDetected(java.util.Date timeFirstDetected) {
            this.timeFirstDetected = timeFirstDetected;
            this.__explicitlySet__.add("timeFirstDetected");
            return this;
        }
        /** Date of scan result that most recently reported the vulnerability */
        @com.fasterxml.jackson.annotation.JsonProperty("timeLastDetected")
        private java.util.Date timeLastDetected;

        /**
         * Date of scan result that most recently reported the vulnerability
         *
         * @param timeLastDetected the value to set
         * @return this builder
         */
        public Builder timeLastDetected(java.util.Date timeLastDetected) {
            this.timeLastDetected = timeLastDetected;
            this.__explicitlySet__.add("timeLastDetected");
            return this;
        }
        /** Packages in which the problem is detected */
        @com.fasterxml.jackson.annotation.JsonProperty("vulnerablePackages")
        private java.util.List<Package> vulnerablePackages;

        /**
         * Packages in which the problem is detected
         *
         * @param vulnerablePackages the value to set
         * @return this builder
         */
        public Builder vulnerablePackages(java.util.List<Package> vulnerablePackages) {
            this.vulnerablePackages = vulnerablePackages;
            this.__explicitlySet__.add("vulnerablePackages");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public HostAgentScanResultProblem build() {
            HostAgentScanResultProblem model =
                    new HostAgentScanResultProblem(
                            this.name,
                            this.description,
                            this.severity,
                            this.state,
                            this.cveReference,
                            this.issueId,
                            this.timeFirstDetected,
                            this.timeLastDetected,
                            this.vulnerablePackages);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(HostAgentScanResultProblem model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("severity")) {
                this.severity(model.getSeverity());
            }
            if (model.wasPropertyExplicitlySet("state")) {
                this.state(model.getState());
            }
            if (model.wasPropertyExplicitlySet("cveReference")) {
                this.cveReference(model.getCveReference());
            }
            if (model.wasPropertyExplicitlySet("issueId")) {
                this.issueId(model.getIssueId());
            }
            if (model.wasPropertyExplicitlySet("timeFirstDetected")) {
                this.timeFirstDetected(model.getTimeFirstDetected());
            }
            if (model.wasPropertyExplicitlySet("timeLastDetected")) {
                this.timeLastDetected(model.getTimeLastDetected());
            }
            if (model.wasPropertyExplicitlySet("vulnerablePackages")) {
                this.vulnerablePackages(model.getVulnerablePackages());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /** Name of the problem */
    @com.fasterxml.jackson.annotation.JsonProperty("name")
    private final String name;

    /**
     * Name of the problem
     *
     * @return the value
     */
    public String getName() {
        return name;
    }

    /** Problem description */
    @com.fasterxml.jackson.annotation.JsonProperty("description")
    private final String description;

    /**
     * Problem description
     *
     * @return the value
     */
    public String getDescription() {
        return description;
    }

    /** Problem severity */
    @com.fasterxml.jackson.annotation.JsonProperty("severity")
    private final ScanResultProblemSeverity severity;

    /**
     * Problem severity
     *
     * @return the value
     */
    public ScanResultProblemSeverity getSeverity() {
        return severity;
    }

    /** State of the vulnerability */
    @com.fasterxml.jackson.annotation.JsonProperty("state")
    private final ScanResultVulnerabilityState state;

    /**
     * State of the vulnerability
     *
     * @return the value
     */
    public ScanResultVulnerabilityState getState() {
        return state;
    }

    /** Reference to problem MITRE CVE ID */
    @com.fasterxml.jackson.annotation.JsonProperty("cveReference")
    private final String cveReference;

    /**
     * Reference to problem MITRE CVE ID
     *
     * @return the value
     */
    public String getCveReference() {
        return cveReference;
    }

    /** Reference to problem issue ID */
    @com.fasterxml.jackson.annotation.JsonProperty("issueId")
    private final Integer issueId;

    /**
     * Reference to problem issue ID
     *
     * @return the value
     */
    public Integer getIssueId() {
        return issueId;
    }

    /** Date of scan result that first reported the vulnerability */
    @com.fasterxml.jackson.annotation.JsonProperty("timeFirstDetected")
    private final java.util.Date timeFirstDetected;

    /**
     * Date of scan result that first reported the vulnerability
     *
     * @return the value
     */
    public java.util.Date getTimeFirstDetected() {
        return timeFirstDetected;
    }

    /** Date of scan result that most recently reported the vulnerability */
    @com.fasterxml.jackson.annotation.JsonProperty("timeLastDetected")
    private final java.util.Date timeLastDetected;

    /**
     * Date of scan result that most recently reported the vulnerability
     *
     * @return the value
     */
    public java.util.Date getTimeLastDetected() {
        return timeLastDetected;
    }

    /** Packages in which the problem is detected */
    @com.fasterxml.jackson.annotation.JsonProperty("vulnerablePackages")
    private final java.util.List<Package> vulnerablePackages;

    /**
     * Packages in which the problem is detected
     *
     * @return the value
     */
    public java.util.List<Package> getVulnerablePackages() {
        return vulnerablePackages;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("HostAgentScanResultProblem(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", severity=").append(String.valueOf(this.severity));
        sb.append(", state=").append(String.valueOf(this.state));
        sb.append(", cveReference=").append(String.valueOf(this.cveReference));
        sb.append(", issueId=").append(String.valueOf(this.issueId));
        sb.append(", timeFirstDetected=").append(String.valueOf(this.timeFirstDetected));
        sb.append(", timeLastDetected=").append(String.valueOf(this.timeLastDetected));
        sb.append(", vulnerablePackages=").append(String.valueOf(this.vulnerablePackages));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostAgentScanResultProblem)) {
            return false;
        }

        HostAgentScanResultProblem other = (HostAgentScanResultProblem) o;
        return java.util.Objects.equals(this.name, other.name)
                && java.util.Objects.equals(this.description, other.description)
                && java.util.Objects.equals(this.severity, other.severity)
                && java.util.Objects.equals(this.state, other.state)
                && java.util.Objects.equals(this.cveReference, other.cveReference)
                && java.util.Objects.equals(this.issueId, other.issueId)
                && java.util.Objects.equals(this.timeFirstDetected, other.timeFirstDetected)
                && java.util.Objects.equals(this.timeLastDetected, other.timeLastDetected)
                && java.util.Objects.equals(this.vulnerablePackages, other.vulnerablePackages)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.name == null ? 43 : this.name.hashCode());
        result = (result * PRIME) + (this.description == null ? 43 : this.description.hashCode());
        result = (result * PRIME) + (this.severity == null ? 43 : this.severity.hashCode());
        result = (result * PRIME) + (this.state == null ? 43 : this.state.hashCode());
        result = (result * PRIME) + (this.cveReference == null ? 43 : this.cveReference.hashCode());
        result = (result * PRIME) + (this.issueId == null ? 43 : this.issueId.hashCode());
        result =
                (result * PRIME)
                        + (this.timeFirstDetected == null ? 43 : this.timeFirstDetected.hashCode());
        result =
                (result * PRIME)
                        + (this.timeLastDetected == null ? 43 : this.timeLastDetected.hashCode());
        result =
                (result * PRIME)
                        + (this.vulnerablePackages == null
                                ? 43
                                : this.vulnerablePackages.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
