/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

/**
 * Host CIS (Center for Internet Security) Benchmark scan level. STRICT - More than 20% of the
 * benchmarks failing is a critical risk. MEDIUM - More than 40% of the benchmarks failing is a high
 * risk. LIGHT - More than 80% of the benchmarks failing is a high risk.
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
public enum HostCisBenchmarkScanLevel implements com.oracle.bmc.http.internal.BmcEnum {
    None("NONE"),
    Light("LIGHT"),
    Medium("MEDIUM"),
    Strict("STRICT"),

    /**
     * This value is used if a service returns a value for this enum that is not recognized by this
     * version of the SDK.
     */
    UnknownEnumValue(null);

    private static final org.slf4j.Logger LOG =
            org.slf4j.LoggerFactory.getLogger(HostCisBenchmarkScanLevel.class);

    private final String value;
    private static java.util.Map<String, HostCisBenchmarkScanLevel> map;

    static {
        map = new java.util.HashMap<>();
        for (HostCisBenchmarkScanLevel v : HostCisBenchmarkScanLevel.values()) {
            if (v != UnknownEnumValue) {
                map.put(v.getValue(), v);
            }
        }
    }

    HostCisBenchmarkScanLevel(String value) {
        this.value = value;
    }

    @com.fasterxml.jackson.annotation.JsonValue
    public String getValue() {
        return value;
    }

    @com.fasterxml.jackson.annotation.JsonCreator
    public static HostCisBenchmarkScanLevel create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        LOG.warn(
                "Received unknown value '{}' for enum 'HostCisBenchmarkScanLevel', returning UnknownEnumValue",
                key);
        return UnknownEnumValue;
    }
}
