/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

/**
 * Agent configuration for host scan agent settings. This model is polymorphic, presenting different
 * configuration options based on selected agent vendor. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
@com.fasterxml.jackson.annotation.JsonTypeInfo(
        use = com.fasterxml.jackson.annotation.JsonTypeInfo.Id.NAME,
        include = com.fasterxml.jackson.annotation.JsonTypeInfo.As.PROPERTY,
        property = "vendor",
        defaultImpl = HostScanAgentConfiguration.class)
@com.fasterxml.jackson.annotation.JsonSubTypes({
    @com.fasterxml.jackson.annotation.JsonSubTypes.Type(
            value = HostScanAgentConfigurationQualys.class,
            name = "QUALYS"),
    @com.fasterxml.jackson.annotation.JsonSubTypes.Type(
            value = HostScanAgentConfigurationOCI.class,
            name = "OCI")
})
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public class HostScanAgentConfiguration
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({"vendorType"})
    protected HostScanAgentConfiguration(VendorType vendorType) {
        super();
        this.vendorType = vendorType;
    }

    /** Vendor to use for the host scan agent. */
    @com.fasterxml.jackson.annotation.JsonProperty("vendorType")
    private final VendorType vendorType;

    /**
     * Vendor to use for the host scan agent.
     *
     * @return the value
     */
    public VendorType getVendorType() {
        return vendorType;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("HostScanAgentConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("vendorType=").append(String.valueOf(this.vendorType));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostScanAgentConfiguration)) {
            return false;
        }

        HostScanAgentConfiguration other = (HostScanAgentConfiguration) o;
        return java.util.Objects.equals(this.vendorType, other.vendorType) && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.vendorType == null ? 43 : this.vendorType.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
