/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

/**
 * Agent configuration options for vendor Qualys. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = HostScanAgentConfigurationQualys.Builder.class)
@com.fasterxml.jackson.annotation.JsonTypeInfo(
        use = com.fasterxml.jackson.annotation.JsonTypeInfo.Id.NAME,
        include = com.fasterxml.jackson.annotation.JsonTypeInfo.As.PROPERTY,
        property = "vendor")
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class HostScanAgentConfigurationQualys extends HostScanAgentConfiguration {
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        @com.fasterxml.jackson.annotation.JsonProperty("vendorType")
        private VendorType vendorType;

        public Builder vendorType(VendorType vendorType) {
            this.vendorType = vendorType;
            this.__explicitlySet__.add("vendorType");
            return this;
        }
        /**
         * Vault secret OCID which stores license information. Content inside this secret in vault
         * would be base64 string containing information about customer's Qualys susbcription
         * license.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("vaultSecretId")
        private String vaultSecretId;

        /**
         * Vault secret OCID which stores license information. Content inside this secret in vault
         * would be base64 string containing information about customer's Qualys susbcription
         * license.
         *
         * @param vaultSecretId the value to set
         * @return this builder
         */
        public Builder vaultSecretId(String vaultSecretId) {
            this.vaultSecretId = vaultSecretId;
            this.__explicitlySet__.add("vaultSecretId");
            return this;
        }
        /**
         * Boolean flag letting agent know if it should un-install the Qualys agent when it is
         * stopped.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("shouldUnInstall")
        private Boolean shouldUnInstall;

        /**
         * Boolean flag letting agent know if it should un-install the Qualys agent when it is
         * stopped.
         *
         * @param shouldUnInstall the value to set
         * @return this builder
         */
        public Builder shouldUnInstall(Boolean shouldUnInstall) {
            this.shouldUnInstall = shouldUnInstall;
            this.__explicitlySet__.add("shouldUnInstall");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public HostScanAgentConfigurationQualys build() {
            HostScanAgentConfigurationQualys model =
                    new HostScanAgentConfigurationQualys(
                            this.vendorType, this.vaultSecretId, this.shouldUnInstall);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(HostScanAgentConfigurationQualys model) {
            if (model.wasPropertyExplicitlySet("vendorType")) {
                this.vendorType(model.getVendorType());
            }
            if (model.wasPropertyExplicitlySet("vaultSecretId")) {
                this.vaultSecretId(model.getVaultSecretId());
            }
            if (model.wasPropertyExplicitlySet("shouldUnInstall")) {
                this.shouldUnInstall(model.getShouldUnInstall());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostScanAgentConfigurationQualys(
            VendorType vendorType, String vaultSecretId, Boolean shouldUnInstall) {
        super(vendorType);
        this.vaultSecretId = vaultSecretId;
        this.shouldUnInstall = shouldUnInstall;
    }

    /**
     * Vault secret OCID which stores license information. Content inside this secret in vault would
     * be base64 string containing information about customer's Qualys susbcription license.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("vaultSecretId")
    private final String vaultSecretId;

    /**
     * Vault secret OCID which stores license information. Content inside this secret in vault would
     * be base64 string containing information about customer's Qualys susbcription license.
     *
     * @return the value
     */
    public String getVaultSecretId() {
        return vaultSecretId;
    }

    /**
     * Boolean flag letting agent know if it should un-install the Qualys agent when it is stopped.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("shouldUnInstall")
    private final Boolean shouldUnInstall;

    /**
     * Boolean flag letting agent know if it should un-install the Qualys agent when it is stopped.
     *
     * @return the value
     */
    public Boolean getShouldUnInstall() {
        return shouldUnInstall;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("HostScanAgentConfigurationQualys(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", vaultSecretId=").append(String.valueOf(this.vaultSecretId));
        sb.append(", shouldUnInstall=").append(String.valueOf(this.shouldUnInstall));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostScanAgentConfigurationQualys)) {
            return false;
        }

        HostScanAgentConfigurationQualys other = (HostScanAgentConfigurationQualys) o;
        return java.util.Objects.equals(this.vaultSecretId, other.vaultSecretId)
                && java.util.Objects.equals(this.shouldUnInstall, other.shouldUnInstall)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result =
                (result * PRIME)
                        + (this.vaultSecretId == null ? 43 : this.vaultSecretId.hashCode());
        result =
                (result * PRIME)
                        + (this.shouldUnInstall == null ? 43 : this.shouldUnInstall.hashCode());
        return result;
    }
}
