/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

/**
 * Number of resources impacted in this compartment whose scan results currently report this
 * vulnerability <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = ImpactedResourcesCount.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class ImpactedResourcesCount
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({"hostCount", "imageCount"})
    public ImpactedResourcesCount(Integer hostCount, Integer imageCount) {
        super();
        this.hostCount = hostCount;
        this.imageCount = imageCount;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /**
         * Number of scanned hosts in this compartment whose scan results currently report this
         * vulnerability
         */
        @com.fasterxml.jackson.annotation.JsonProperty("hostCount")
        private Integer hostCount;

        /**
         * Number of scanned hosts in this compartment whose scan results currently report this
         * vulnerability
         *
         * @param hostCount the value to set
         * @return this builder
         */
        public Builder hostCount(Integer hostCount) {
            this.hostCount = hostCount;
            this.__explicitlySet__.add("hostCount");
            return this;
        }
        /**
         * Number of scanned container images in this compartment whose scan results currently
         * report this vulnerability
         */
        @com.fasterxml.jackson.annotation.JsonProperty("imageCount")
        private Integer imageCount;

        /**
         * Number of scanned container images in this compartment whose scan results currently
         * report this vulnerability
         *
         * @param imageCount the value to set
         * @return this builder
         */
        public Builder imageCount(Integer imageCount) {
            this.imageCount = imageCount;
            this.__explicitlySet__.add("imageCount");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public ImpactedResourcesCount build() {
            ImpactedResourcesCount model =
                    new ImpactedResourcesCount(this.hostCount, this.imageCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(ImpactedResourcesCount model) {
            if (model.wasPropertyExplicitlySet("hostCount")) {
                this.hostCount(model.getHostCount());
            }
            if (model.wasPropertyExplicitlySet("imageCount")) {
                this.imageCount(model.getImageCount());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /**
     * Number of scanned hosts in this compartment whose scan results currently report this
     * vulnerability
     */
    @com.fasterxml.jackson.annotation.JsonProperty("hostCount")
    private final Integer hostCount;

    /**
     * Number of scanned hosts in this compartment whose scan results currently report this
     * vulnerability
     *
     * @return the value
     */
    public Integer getHostCount() {
        return hostCount;
    }

    /**
     * Number of scanned container images in this compartment whose scan results currently report
     * this vulnerability
     */
    @com.fasterxml.jackson.annotation.JsonProperty("imageCount")
    private final Integer imageCount;

    /**
     * Number of scanned container images in this compartment whose scan results currently report
     * this vulnerability
     *
     * @return the value
     */
    public Integer getImageCount() {
        return imageCount;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("ImpactedResourcesCount(");
        sb.append("super=").append(super.toString());
        sb.append("hostCount=").append(String.valueOf(this.hostCount));
        sb.append(", imageCount=").append(String.valueOf(this.imageCount));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImpactedResourcesCount)) {
            return false;
        }

        ImpactedResourcesCount other = (ImpactedResourcesCount) o;
        return java.util.Objects.equals(this.hostCount, other.hostCount)
                && java.util.Objects.equals(this.imageCount, other.imageCount)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.hostCount == null ? 43 : this.hostCount.hashCode());
        result = (result * PRIME) + (this.imageCount == null ? 43 : this.imageCount.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
