/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

/** Possible operation types. */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
public enum OperationType implements com.oracle.bmc.http.internal.BmcEnum {
    CreateHostScanRecipe("CREATE_HOST_SCAN_RECIPE"),
    UpdateHostScanRecipe("UPDATE_HOST_SCAN_RECIPE"),
    DeleteHostScanRecipe("DELETE_HOST_SCAN_RECIPE"),
    CreateHostScanTarget("CREATE_HOST_SCAN_TARGET"),
    UpdateHostScanTarget("UPDATE_HOST_SCAN_TARGET"),
    DeleteHostScanTarget("DELETE_HOST_SCAN_TARGET"),
    CreateContainerScanRecipe("CREATE_CONTAINER_SCAN_RECIPE"),
    UpdateContainerScanRecipe("UPDATE_CONTAINER_SCAN_RECIPE"),
    DeleteContainerScanRecipe("DELETE_CONTAINER_SCAN_RECIPE"),
    CreateContainerScanTarget("CREATE_CONTAINER_SCAN_TARGET"),
    UpdateContainerScanTarget("UPDATE_CONTAINER_SCAN_TARGET"),
    DeleteContainerScanTarget("DELETE_CONTAINER_SCAN_TARGET"),
    DeleteHostAgentScanResult("DELETE_HOST_AGENT_SCAN_RESULT"),
    DeleteHostPortScanResult("DELETE_HOST_PORT_SCAN_RESULT"),
    DeleteHostCisBenchmarkScanResult("DELETE_HOST_CIS_BENCHMARK_SCAN_RESULT"),
    DeleteContainerScanResult("DELETE_CONTAINER_SCAN_RESULT"),

    /**
     * This value is used if a service returns a value for this enum that is not recognized by this
     * version of the SDK.
     */
    UnknownEnumValue(null);

    private static final org.slf4j.Logger LOG =
            org.slf4j.LoggerFactory.getLogger(OperationType.class);

    private final String value;
    private static java.util.Map<String, OperationType> map;

    static {
        map = new java.util.HashMap<>();
        for (OperationType v : OperationType.values()) {
            if (v != UnknownEnumValue) {
                map.put(v.getValue(), v);
            }
        }
    }

    OperationType(String value) {
        this.value = value;
    }

    @com.fasterxml.jackson.annotation.JsonValue
    public String getValue() {
        return value;
    }

    @com.fasterxml.jackson.annotation.JsonCreator
    public static OperationType create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        LOG.warn(
                "Received unknown value '{}' for enum 'OperationType', returning UnknownEnumValue",
                key);
        return UnknownEnumValue;
    }
}
