/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.requests;

import com.oracle.bmc.vulnerabilityscanning.model.*;
/**
 * <b>Example: </b>Click <a
 * href="https://docs.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/vulnerabilityscanning/ListHostVulnerabilitiesExample.java.html"
 * target="_blank" rel="noopener noreferrer">here</a> to see how to use
 * ListHostVulnerabilitiesRequest.
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
public class ListHostVulnerabilitiesRequest
        extends com.oracle.bmc.requests.BmcRequest<java.lang.Void> {

    /** The ID of the compartment in which to list resources. */
    private String compartmentId;

    /** The ID of the compartment in which to list resources. */
    public String getCompartmentId() {
        return compartmentId;
    }
    /** The maximum number of items to return. */
    private Integer limit;

    /** The maximum number of items to return. */
    public Integer getLimit() {
        return limit;
    }
    /**
     * The page token representing the page at which to start retrieving results. This is usually
     * retrieved from a previous list call.
     */
    private String page;

    /**
     * The page token representing the page at which to start retrieving results. This is usually
     * retrieved from a previous list call.
     */
    public String getPage() {
        return page;
    }
    /** A filter to return only resources that have a severity that matches the given severity */
    private com.oracle.bmc.vulnerabilityscanning.model.ScanResultProblemSeverity severity;

    /** A filter to return only resources that have a severity that matches the given severity */
    public com.oracle.bmc.vulnerabilityscanning.model.ScanResultProblemSeverity getSeverity() {
        return severity;
    }
    /** A filter to return only resources that match the entire name given. */
    private String name;

    /** A filter to return only resources that match the entire name given. */
    public String getName() {
        return name;
    }
    /** Parameter to filter by CVE reference number for vulnerabilities */
    private String cveReference;

    /** Parameter to filter by CVE reference number for vulnerabilities */
    public String getCveReference() {
        return cveReference;
    }
    /** The field to filter vulnerabilities based on its type. Only one value can be provided. */
    private com.oracle.bmc.vulnerabilityscanning.model.VulnerabilityType vulnerabilityType;

    /** The field to filter vulnerabilities based on its type. Only one value can be provided. */
    public com.oracle.bmc.vulnerabilityscanning.model.VulnerabilityType getVulnerabilityType() {
        return vulnerabilityType;
    }
    /** The sort order to use, either 'ASC' or 'DESC'. */
    private com.oracle.bmc.vulnerabilityscanning.model.SortOrder sortOrder;

    /** The sort order to use, either 'ASC' or 'DESC'. */
    public com.oracle.bmc.vulnerabilityscanning.model.SortOrder getSortOrder() {
        return sortOrder;
    }
    /**
     * The field to sort by. Only one sort order may be provided. Default order for 'name' is
     * Ascending. Default order for other values is descending. If no value is specified name is
     * default.
     */
    private com.oracle.bmc.vulnerabilityscanning.model.HostVulnerabilitySortBy sortBy;

    /**
     * The field to sort by. Only one sort order may be provided. Default order for 'name' is
     * Ascending. Default order for other values is descending. If no value is specified name is
     * default.
     */
    public com.oracle.bmc.vulnerabilityscanning.model.HostVulnerabilitySortBy getSortBy() {
        return sortBy;
    }
    /** The client request ID for tracing. */
    private String opcRequestId;

    /** The client request ID for tracing. */
    public String getOpcRequestId() {
        return opcRequestId;
    }

    public static class Builder
            implements com.oracle.bmc.requests.BmcRequest.Builder<
                    ListHostVulnerabilitiesRequest, java.lang.Void> {
        private com.oracle.bmc.http.client.RequestInterceptor invocationCallback = null;
        private com.oracle.bmc.retrier.RetryConfiguration retryConfiguration = null;

        /** The ID of the compartment in which to list resources. */
        private String compartmentId = null;

        /**
         * The ID of the compartment in which to list resources.
         *
         * @param compartmentId the value to set
         * @return this builder instance
         */
        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        /** The maximum number of items to return. */
        private Integer limit = null;

        /**
         * The maximum number of items to return.
         *
         * @param limit the value to set
         * @return this builder instance
         */
        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * The page token representing the page at which to start retrieving results. This is
         * usually retrieved from a previous list call.
         */
        private String page = null;

        /**
         * The page token representing the page at which to start retrieving results. This is
         * usually retrieved from a previous list call.
         *
         * @param page the value to set
         * @return this builder instance
         */
        public Builder page(String page) {
            this.page = page;
            return this;
        }

        /**
         * A filter to return only resources that have a severity that matches the given severity
         */
        private com.oracle.bmc.vulnerabilityscanning.model.ScanResultProblemSeverity severity =
                null;

        /**
         * A filter to return only resources that have a severity that matches the given severity
         *
         * @param severity the value to set
         * @return this builder instance
         */
        public Builder severity(
                com.oracle.bmc.vulnerabilityscanning.model.ScanResultProblemSeverity severity) {
            this.severity = severity;
            return this;
        }

        /** A filter to return only resources that match the entire name given. */
        private String name = null;

        /**
         * A filter to return only resources that match the entire name given.
         *
         * @param name the value to set
         * @return this builder instance
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        /** Parameter to filter by CVE reference number for vulnerabilities */
        private String cveReference = null;

        /**
         * Parameter to filter by CVE reference number for vulnerabilities
         *
         * @param cveReference the value to set
         * @return this builder instance
         */
        public Builder cveReference(String cveReference) {
            this.cveReference = cveReference;
            return this;
        }

        /**
         * The field to filter vulnerabilities based on its type. Only one value can be provided.
         */
        private com.oracle.bmc.vulnerabilityscanning.model.VulnerabilityType vulnerabilityType =
                null;

        /**
         * The field to filter vulnerabilities based on its type. Only one value can be provided.
         *
         * @param vulnerabilityType the value to set
         * @return this builder instance
         */
        public Builder vulnerabilityType(
                com.oracle.bmc.vulnerabilityscanning.model.VulnerabilityType vulnerabilityType) {
            this.vulnerabilityType = vulnerabilityType;
            return this;
        }

        /** The sort order to use, either 'ASC' or 'DESC'. */
        private com.oracle.bmc.vulnerabilityscanning.model.SortOrder sortOrder = null;

        /**
         * The sort order to use, either 'ASC' or 'DESC'.
         *
         * @param sortOrder the value to set
         * @return this builder instance
         */
        public Builder sortOrder(com.oracle.bmc.vulnerabilityscanning.model.SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        /**
         * The field to sort by. Only one sort order may be provided. Default order for 'name' is
         * Ascending. Default order for other values is descending. If no value is specified name is
         * default.
         */
        private com.oracle.bmc.vulnerabilityscanning.model.HostVulnerabilitySortBy sortBy = null;

        /**
         * The field to sort by. Only one sort order may be provided. Default order for 'name' is
         * Ascending. Default order for other values is descending. If no value is specified name is
         * default.
         *
         * @param sortBy the value to set
         * @return this builder instance
         */
        public Builder sortBy(
                com.oracle.bmc.vulnerabilityscanning.model.HostVulnerabilitySortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        /** The client request ID for tracing. */
        private String opcRequestId = null;

        /**
         * The client request ID for tracing.
         *
         * @param opcRequestId the value to set
         * @return this builder instance
         */
        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        /**
         * Set the invocation callback for the request to be built.
         *
         * @param invocationCallback the invocation callback to be set for the request
         * @return this builder instance
         */
        public Builder invocationCallback(
                com.oracle.bmc.http.client.RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        /**
         * Set the retry configuration for the request to be built.
         *
         * @param retryConfiguration the retry configuration to be used for the request
         * @return this builder instance
         */
        public Builder retryConfiguration(
                com.oracle.bmc.retrier.RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        /**
         * Copy method to populate the builder with values from the given instance.
         *
         * @return this builder instance
         */
        public Builder copy(ListHostVulnerabilitiesRequest o) {
            compartmentId(o.getCompartmentId());
            limit(o.getLimit());
            page(o.getPage());
            severity(o.getSeverity());
            name(o.getName());
            cveReference(o.getCveReference());
            vulnerabilityType(o.getVulnerabilityType());
            sortOrder(o.getSortOrder());
            sortBy(o.getSortBy());
            opcRequestId(o.getOpcRequestId());
            invocationCallback(o.getInvocationCallback());
            retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        /**
         * Build the instance of ListHostVulnerabilitiesRequest as configured by this builder
         *
         * <p>Note that this method takes calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#buildWithoutInvocationCallback} does not.
         *
         * <p>This is the preferred method to build an instance.
         *
         * @return instance of ListHostVulnerabilitiesRequest
         */
        public ListHostVulnerabilitiesRequest build() {
            ListHostVulnerabilitiesRequest request = buildWithoutInvocationCallback();
            request.setInvocationCallback(invocationCallback);
            request.setRetryConfiguration(retryConfiguration);
            return request;
        }

        /**
         * Build the instance of ListHostVulnerabilitiesRequest as configured by this builder
         *
         * <p>Note that this method does not take calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#build} does
         *
         * @return instance of ListHostVulnerabilitiesRequest
         */
        public ListHostVulnerabilitiesRequest buildWithoutInvocationCallback() {
            ListHostVulnerabilitiesRequest request = new ListHostVulnerabilitiesRequest();
            request.compartmentId = compartmentId;
            request.limit = limit;
            request.page = page;
            request.severity = severity;
            request.name = name;
            request.cveReference = cveReference;
            request.vulnerabilityType = vulnerabilityType;
            request.sortOrder = sortOrder;
            request.sortBy = sortBy;
            request.opcRequestId = opcRequestId;
            return request;
            // new ListHostVulnerabilitiesRequest(compartmentId, limit, page, severity, name,
            // cveReference, vulnerabilityType, sortOrder, sortBy, opcRequestId);
        }
    }

    /**
     * Return an instance of {@link Builder} that allows you to modify request properties.
     *
     * @return instance of {@link Builder} that allows you to modify request properties.
     */
    public Builder toBuilder() {
        return new Builder()
                .compartmentId(compartmentId)
                .limit(limit)
                .page(page)
                .severity(severity)
                .name(name)
                .cveReference(cveReference)
                .vulnerabilityType(vulnerabilityType)
                .sortOrder(sortOrder)
                .sortBy(sortBy)
                .opcRequestId(opcRequestId);
    }

    /**
     * Return a new builder for this request object.
     *
     * @return builder for the request object
     */
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",severity=").append(String.valueOf(this.severity));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",cveReference=").append(String.valueOf(this.cveReference));
        sb.append(",vulnerabilityType=").append(String.valueOf(this.vulnerabilityType));
        sb.append(",sortOrder=").append(String.valueOf(this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf(this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListHostVulnerabilitiesRequest)) {
            return false;
        }

        ListHostVulnerabilitiesRequest other = (ListHostVulnerabilitiesRequest) o;
        return super.equals(o)
                && java.util.Objects.equals(this.compartmentId, other.compartmentId)
                && java.util.Objects.equals(this.limit, other.limit)
                && java.util.Objects.equals(this.page, other.page)
                && java.util.Objects.equals(this.severity, other.severity)
                && java.util.Objects.equals(this.name, other.name)
                && java.util.Objects.equals(this.cveReference, other.cveReference)
                && java.util.Objects.equals(this.vulnerabilityType, other.vulnerabilityType)
                && java.util.Objects.equals(this.sortOrder, other.sortOrder)
                && java.util.Objects.equals(this.sortBy, other.sortBy)
                && java.util.Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result =
                (result * PRIME)
                        + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = (result * PRIME) + (this.limit == null ? 43 : this.limit.hashCode());
        result = (result * PRIME) + (this.page == null ? 43 : this.page.hashCode());
        result = (result * PRIME) + (this.severity == null ? 43 : this.severity.hashCode());
        result = (result * PRIME) + (this.name == null ? 43 : this.name.hashCode());
        result = (result * PRIME) + (this.cveReference == null ? 43 : this.cveReference.hashCode());
        result =
                (result * PRIME)
                        + (this.vulnerabilityType == null ? 43 : this.vulnerabilityType.hashCode());
        result = (result * PRIME) + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = (result * PRIME) + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = (result * PRIME) + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }
}
