/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.waas;

import com.oracle.bmc.waas.requests.*;
import com.oracle.bmc.waas.responses.*;

/** OCI Web Application Acceleration and Security Services */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20181116")
public interface WaasAsync extends AutoCloseable {

    /** Rebuilds the client from scratch. Useful to refresh certificates. */
    void refreshClient();

    /**
     * Sets the endpoint to call (ex, https://www.example.com).
     *
     * @param endpoint The endpoint of the serice.
     */
    void setEndpoint(String endpoint);

    /** Gets the set endpoint for REST call (ex, https://www.example.com) */
    String getEndpoint();

    /**
     * Sets the region to call (ex, Region.US_PHOENIX_1).
     *
     * <p>Note, this will call {@link #setEndpoint(String) setEndpoint} after resolving the
     * endpoint. If the service is not available in this region, however, an
     * IllegalArgumentException will be raised.
     *
     * @param region The region of the service.
     */
    void setRegion(com.oracle.bmc.Region region);

    /**
     * Sets the region to call (ex, 'us-phoenix-1').
     *
     * <p>Note, this will first try to map the region ID to a known Region and call {@link
     * #setRegion(Region) setRegion}.
     *
     * <p>If no known Region could be determined, it will create an endpoint based on the default
     * endpoint format ({@link com.oracle.bmc.Region#formatDefaultRegionEndpoint(Service, String)}
     * and then call {@link #setEndpoint(String) setEndpoint}.
     *
     * @param regionId The public region ID.
     */
    void setRegion(String regionId);

    /**
     * Determines whether realm specific endpoint should be used or not. Set
     * realmSpecificEndpointTemplateEnabled to "true" if the user wants to enable use of realm
     * specific endpoint template, otherwise set it to "false"
     *
     * @param realmSpecificEndpointTemplateEnabled flag to enable the use of realm specific endpoint
     *     template
     */
    void useRealmSpecificEndpointTemplate(boolean realmSpecificEndpointTemplateEnabled);

    /**
     * Accepts a list of recommended Web Application Firewall protection rules. Web Application
     * Firewall protection rule recommendations are sets of rules generated by observed traffic
     * patterns through the Web Application Firewall and are meant to optimize the Web Application
     * Firewall's security profile. Only the rules specified in the request body will be updated;
     * all other rules will remain unchanged.
     *
     * <p>Use the `GET /waasPolicies/{waasPolicyId}/wafConfig/recommendations` method to view a list
     * of recommended Web Application Firewall protection rules. For more information, see [WAF
     * Protection Rules](https://docs.oracle.com/iaas/Content/WAF/Tasks/wafprotectionrules.htm).
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<AcceptRecommendationsResponse> acceptRecommendations(
            AcceptRecommendationsRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            AcceptRecommendationsRequest, AcceptRecommendationsResponse>
                    handler);

    /**
     * Cancels a specified work request.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<CancelWorkRequestResponse> cancelWorkRequest(
            CancelWorkRequestRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            CancelWorkRequestRequest, CancelWorkRequestResponse>
                    handler);

    /**
     * Moves address list into a different compartment. When provided, If-Match is checked against
     * ETag values of the address list. For information about moving resources between compartments,
     * see [Moving Resources to a Different
     * Compartment](https://docs.oracle.com/iaas/Content/Identity/Tasks/managingcompartments.htm#moveRes).
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ChangeAddressListCompartmentResponse> changeAddressListCompartment(
            ChangeAddressListCompartmentRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ChangeAddressListCompartmentRequest,
                            ChangeAddressListCompartmentResponse>
                    handler);

    /**
     * Moves certificate into a different compartment. When provided, If-Match is checked against
     * ETag values of the certificate. For information about moving resources between compartments,
     * see [Moving Resources to a Different
     * Compartment](https://docs.oracle.com/iaas/Content/Identity/Tasks/managingcompartments.htm#moveRes).
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ChangeCertificateCompartmentResponse> changeCertificateCompartment(
            ChangeCertificateCompartmentRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ChangeCertificateCompartmentRequest,
                            ChangeCertificateCompartmentResponse>
                    handler);

    /**
     * Moves a custom protection rule into a different compartment within the same tenancy. When
     * provided, If-Match is checked against ETag values of the custom protection rule. For
     * information about moving resources between compartments, see [Moving Resources to a Different
     * Compartment](https://docs.oracle.com/iaas/Content/Identity/Tasks/managingcompartments.htm#moveRes).
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ChangeCustomProtectionRuleCompartmentResponse>
            changeCustomProtectionRuleCompartment(
                    ChangeCustomProtectionRuleCompartmentRequest request,
                    com.oracle.bmc.responses.AsyncHandler<
                                    ChangeCustomProtectionRuleCompartmentRequest,
                                    ChangeCustomProtectionRuleCompartmentResponse>
                            handler);

    /**
     * Moves WAAS policy into a different compartment. When provided, If-Match is checked against
     * ETag values of the WAAS policy. For information about moving resources between compartments,
     * see [Moving Resources to a Different
     * Compartment](https://docs.oracle.com/iaas/Content/Identity/Tasks/managingcompartments.htm#moveRes).
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ChangeWaasPolicyCompartmentResponse> changeWaasPolicyCompartment(
            ChangeWaasPolicyCompartmentRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ChangeWaasPolicyCompartmentRequest, ChangeWaasPolicyCompartmentResponse>
                    handler);

    /**
     * Creates an address list in a set compartment and allows it to be used in a WAAS policy and
     * referenced by access rules. Addresses can be IP addresses and CIDR notations.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<CreateAddressListResponse> createAddressList(
            CreateAddressListRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            CreateAddressListRequest, CreateAddressListResponse>
                    handler);

    /**
     * Allows an SSL certificate to be added to a WAAS policy. The Web Application Firewall
     * terminates SSL connections to inspect requests in runtime, and then re-encrypts requests
     * before sending them to the origin for fulfillment.
     *
     * <p>For more information, see [WAF
     * Settings](https://docs.oracle.com/iaas/Content/WAF/Tasks/wafsettings.htm).
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<CreateCertificateResponse> createCertificate(
            CreateCertificateRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            CreateCertificateRequest, CreateCertificateResponse>
                    handler);

    /**
     * Creates a new custom protection rule in the specified compartment.
     *
     * <p>Custom protection rules allow you to create rules in addition to the rulesets provided by
     * the Web Application Firewall service, including rules from
     * [ModSecurity](https://modsecurity.org/). The syntax for custom rules is based on the
     * ModSecurity syntax. For more information about custom protection rules, see [Custom
     * Protection Rules](https://docs.oracle.com/iaas/Content/WAF/Tasks/customprotectionrules.htm).
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<CreateCustomProtectionRuleResponse> createCustomProtectionRule(
            CreateCustomProtectionRuleRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            CreateCustomProtectionRuleRequest, CreateCustomProtectionRuleResponse>
                    handler);

    /**
     * Creates a new Web Application Acceleration and Security (WAAS) policy in the specified
     * compartment. A WAAS policy must be established before creating Web Application Firewall (WAF)
     * rules. To use WAF rules, your web application's origin servers must defined in the
     * `WaasPolicy` schema.
     *
     * <p>A domain name must be specified when creating a WAAS policy. The domain name should be
     * different from the origins specified in your `WaasPolicy`. Once domain name is entered and
     * stored, it is unchangeable.
     *
     * <p>Use the record data returned in the `cname` field of the `WaasPolicy` object to create a
     * CNAME record in your DNS configuration that will direct your domain's traffic through the
     * WAF.
     *
     * <p>For the purposes of access control, you must provide the OCID of the compartment where you
     * want the service to reside. For information about access control and compartments, see
     * [Overview of the IAM
     * Service](https://docs.oracle.com/iaas/Content/Identity/Concepts/overview.htm).
     *
     * <p>You must specify a display name and domain for the WAAS policy. The display name does not
     * have to be unique and can be changed. The domain name should be different from every origin
     * specified in `WaasPolicy`.
     *
     * <p>All Oracle Cloud Infrastructure resources, including WAAS policies, receive a unique,
     * Oracle-assigned ID called an Oracle Cloud Identifier (OCID). When a resource is created, you
     * can find its OCID in the response. You can also retrieve a resource's OCID by using a list
     * API operation for that resource type, or by viewing the resource in the Console. Fore more
     * information, see [Resource
     * Identifiers](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
     *
     * <p>*Note:** After sending the POST request, the new object's state will temporarily be
     * `CREATING`. Ensure that the resource's state has changed to `ACTIVE` before use.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<CreateWaasPolicyResponse> createWaasPolicy(
            CreateWaasPolicyRequest request,
            com.oracle.bmc.responses.AsyncHandler<CreateWaasPolicyRequest, CreateWaasPolicyResponse>
                    handler);

    /**
     * Deletes the address list from the compartment if it is not used.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<DeleteAddressListResponse> deleteAddressList(
            DeleteAddressListRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            DeleteAddressListRequest, DeleteAddressListResponse>
                    handler);

    /**
     * Deletes an SSL certificate from the WAAS service.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<DeleteCertificateResponse> deleteCertificate(
            DeleteCertificateRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            DeleteCertificateRequest, DeleteCertificateResponse>
                    handler);

    /**
     * Deletes a Custom Protection rule.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<DeleteCustomProtectionRuleResponse> deleteCustomProtectionRule(
            DeleteCustomProtectionRuleRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            DeleteCustomProtectionRuleRequest, DeleteCustomProtectionRuleResponse>
                    handler);

    /**
     * Deletes a policy.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<DeleteWaasPolicyResponse> deleteWaasPolicy(
            DeleteWaasPolicyRequest request,
            com.oracle.bmc.responses.AsyncHandler<DeleteWaasPolicyRequest, DeleteWaasPolicyResponse>
                    handler);

    /**
     * Gets the details of an address list.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetAddressListResponse> getAddressList(
            GetAddressListRequest request,
            com.oracle.bmc.responses.AsyncHandler<GetAddressListRequest, GetAddressListResponse>
                    handler);

    /**
     * Gets the details of an SSL certificate.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetCertificateResponse> getCertificate(
            GetCertificateRequest request,
            com.oracle.bmc.responses.AsyncHandler<GetCertificateRequest, GetCertificateResponse>
                    handler);

    /**
     * Gets the details of a custom protection rule.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetCustomProtectionRuleResponse> getCustomProtectionRule(
            GetCustomProtectionRuleRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            GetCustomProtectionRuleRequest, GetCustomProtectionRuleResponse>
                    handler);

    /**
     * Gets the device fingerprint challenge settings in the Web Application Firewall configuration
     * for a WAAS policy.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetDeviceFingerprintChallengeResponse>
            getDeviceFingerprintChallenge(
                    GetDeviceFingerprintChallengeRequest request,
                    com.oracle.bmc.responses.AsyncHandler<
                                    GetDeviceFingerprintChallengeRequest,
                                    GetDeviceFingerprintChallengeResponse>
                            handler);

    /**
     * Gets the human interaction challenge settings in the Web Application Firewall configuration
     * for a WAAS policy.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetHumanInteractionChallengeResponse> getHumanInteractionChallenge(
            GetHumanInteractionChallengeRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            GetHumanInteractionChallengeRequest,
                            GetHumanInteractionChallengeResponse>
                    handler);

    /**
     * Gets the JavaScript challenge settings in the Web Application Firewall configuration for a
     * WAAS policy.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetJsChallengeResponse> getJsChallenge(
            GetJsChallengeRequest request,
            com.oracle.bmc.responses.AsyncHandler<GetJsChallengeRequest, GetJsChallengeResponse>
                    handler);

    /**
     * Gets the configuration of a WAAS policy.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetPolicyConfigResponse> getPolicyConfig(
            GetPolicyConfigRequest request,
            com.oracle.bmc.responses.AsyncHandler<GetPolicyConfigRequest, GetPolicyConfigResponse>
                    handler);

    /**
     * Gets the details of a protection rule in the Web Application Firewall configuration for a
     * WAAS policy.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetProtectionRuleResponse> getProtectionRule(
            GetProtectionRuleRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            GetProtectionRuleRequest, GetProtectionRuleResponse>
                    handler);

    /**
     * Gets the protection settings in the Web Application Firewall configuration for a WAAS policy.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetProtectionSettingsResponse> getProtectionSettings(
            GetProtectionSettingsRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            GetProtectionSettingsRequest, GetProtectionSettingsResponse>
                    handler);

    /**
     * Gets the details of a WAAS policy.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetWaasPolicyResponse> getWaasPolicy(
            GetWaasPolicyRequest request,
            com.oracle.bmc.responses.AsyncHandler<GetWaasPolicyRequest, GetWaasPolicyResponse>
                    handler);

    /**
     * Gets the address rate limiting settings of the Web Application Firewall configuration for a
     * WAAS policy.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetWafAddressRateLimitingResponse> getWafAddressRateLimiting(
            GetWafAddressRateLimitingRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            GetWafAddressRateLimitingRequest, GetWafAddressRateLimitingResponse>
                    handler);

    /**
     * Gets the Web Application Firewall configuration details for a WAAS policy.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetWafConfigResponse> getWafConfig(
            GetWafConfigRequest request,
            com.oracle.bmc.responses.AsyncHandler<GetWafConfigRequest, GetWafConfigResponse>
                    handler);

    /**
     * Gets the details of a specified work request.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetWorkRequestResponse> getWorkRequest(
            GetWorkRequestRequest request,
            com.oracle.bmc.responses.AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse>
                    handler);

    /**
     * Gets the currently configured access rules for the Web Application Firewall configuration of
     * a specified WAAS policy. The order of the access rules is important. The rules will be
     * checked in the order they are specified and the first matching rule will be used.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListAccessRulesResponse> listAccessRules(
            ListAccessRulesRequest request,
            com.oracle.bmc.responses.AsyncHandler<ListAccessRulesRequest, ListAccessRulesResponse>
                    handler);

    /**
     * Gets a list of address lists that can be used in a WAAS policy.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListAddressListsResponse> listAddressLists(
            ListAddressListsRequest request,
            com.oracle.bmc.responses.AsyncHandler<ListAddressListsRequest, ListAddressListsResponse>
                    handler);

    /**
     * Gets the currently configured caching rules for the Web Application Firewall configuration of
     * a specified WAAS policy. The rules are processed in the order they are specified in and the
     * first matching rule will be used when processing a request.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListCachingRulesResponse> listCachingRules(
            ListCachingRulesRequest request,
            com.oracle.bmc.responses.AsyncHandler<ListCachingRulesRequest, ListCachingRulesResponse>
                    handler);

    /**
     * Gets the list of currently configured CAPTCHA challenges in the Web Application Firewall
     * configuration of a WAAS policy.
     *
     * <p>The order of the CAPTCHA challenges is important. The URL for each CAPTCHA will be checked
     * in the order they are created.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListCaptchasResponse> listCaptchas(
            ListCaptchasRequest request,
            com.oracle.bmc.responses.AsyncHandler<ListCaptchasRequest, ListCaptchasResponse>
                    handler);

    /**
     * Gets a list of SSL certificates that can be used in a WAAS policy.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListCertificatesResponse> listCertificates(
            ListCertificatesRequest request,
            com.oracle.bmc.responses.AsyncHandler<ListCertificatesRequest, ListCertificatesResponse>
                    handler);

    /**
     * Gets a list of custom protection rules for the specified Web Application Firewall.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListCustomProtectionRulesResponse> listCustomProtectionRules(
            ListCustomProtectionRulesRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ListCustomProtectionRulesRequest, ListCustomProtectionRulesResponse>
                    handler);

    /**
     * Return the list of the tenant's edge node subnets. Use these CIDR blocks to restrict incoming
     * traffic to your origin. These subnets are owned by OCI and forward traffic to customer
     * origins. They are not associated with specific regions or compartments.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListEdgeSubnetsResponse> listEdgeSubnets(
            ListEdgeSubnetsRequest request,
            com.oracle.bmc.responses.AsyncHandler<ListEdgeSubnetsRequest, ListEdgeSubnetsResponse>
                    handler);

    /**
     * Gets the list of good bots defined in the Web Application Firewall configuration for a WAAS
     * policy.
     *
     * <p>The list is sorted by `key`, in ascending order.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListGoodBotsResponse> listGoodBots(
            ListGoodBotsRequest request,
            com.oracle.bmc.responses.AsyncHandler<ListGoodBotsRequest, ListGoodBotsResponse>
                    handler);

    /**
     * Gets the list of available protection rules for a WAAS policy. Use the `GetWafConfig`
     * operation to view a list of currently configured protection rules for the Web Application
     * Firewall, or use the `ListRecommendations` operation to get a list of recommended protection
     * rules for the Web Application Firewall. The list is sorted by `key`, in ascending order.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListProtectionRulesResponse> listProtectionRules(
            ListProtectionRulesRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ListProtectionRulesRequest, ListProtectionRulesResponse>
                    handler);

    /**
     * Gets the list of recommended Web Application Firewall protection rules.
     *
     * <p>Use the `POST /waasPolicies/{waasPolicyId}/actions/acceptWafConfigRecommendations` method
     * to accept recommended Web Application Firewall protection rules. For more information, see
     * [WAF Protection
     * Rules](https://docs.oracle.com/iaas/Content/WAF/Tasks/wafprotectionrules.htm). The list is
     * sorted by `key`, in ascending order.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListRecommendationsResponse> listRecommendations(
            ListRecommendationsRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ListRecommendationsRequest, ListRecommendationsResponse>
                    handler);

    /**
     * Gets the list of available web application threat intelligence feeds and the actions set for
     * each feed. The list is sorted by `key`, in ascending order.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListThreatFeedsResponse> listThreatFeeds(
            ListThreatFeedsRequest request,
            com.oracle.bmc.responses.AsyncHandler<ListThreatFeedsRequest, ListThreatFeedsResponse>
                    handler);

    /**
     * Gets a list of WAAS policies.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListWaasPoliciesResponse> listWaasPolicies(
            ListWaasPoliciesRequest request,
            com.oracle.bmc.responses.AsyncHandler<ListWaasPoliciesRequest, ListWaasPoliciesResponse>
                    handler);

    /**
     * Gets the list of currently configured custom protection rules for a WAAS policy.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListWaasPolicyCustomProtectionRulesResponse>
            listWaasPolicyCustomProtectionRules(
                    ListWaasPolicyCustomProtectionRulesRequest request,
                    com.oracle.bmc.responses.AsyncHandler<
                                    ListWaasPolicyCustomProtectionRulesRequest,
                                    ListWaasPolicyCustomProtectionRulesResponse>
                            handler);

    /**
     * Gets the number of blocked requests by a Web Application Firewall feature in five minute
     * blocks, sorted by `timeObserved` in ascending order (starting from oldest data).
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListWafBlockedRequestsResponse> listWafBlockedRequests(
            ListWafBlockedRequestsRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ListWafBlockedRequestsRequest, ListWafBlockedRequestsResponse>
                    handler);

    /**
     * Gets structured Web Application Firewall event logs for a WAAS policy. Sorted by the
     * `timeObserved` in ascending order (starting from the oldest recorded event).
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListWafLogsResponse> listWafLogs(
            ListWafLogsRequest request,
            com.oracle.bmc.responses.AsyncHandler<ListWafLogsRequest, ListWafLogsResponse> handler);

    /**
     * Gets the number of requests managed by a Web Application Firewall over a specified period of
     * time, including blocked requests. Sorted by `timeObserved` in ascending order (starting from
     * oldest requests).
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListWafRequestsResponse> listWafRequests(
            ListWafRequestsRequest request,
            com.oracle.bmc.responses.AsyncHandler<ListWafRequestsRequest, ListWafRequestsResponse>
                    handler);

    /**
     * Gets the Web Application Firewall traffic data for a WAAS policy. Sorted by `timeObserved` in
     * ascending order (starting from oldest data).
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListWafTrafficResponse> listWafTraffic(
            ListWafTrafficRequest request,
            com.oracle.bmc.responses.AsyncHandler<ListWafTrafficRequest, ListWafTrafficResponse>
                    handler);

    /**
     * Gets the list of whitelists defined in the Web Application Firewall configuration for a WAAS
     * policy.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListWhitelistsResponse> listWhitelists(
            ListWhitelistsRequest request,
            com.oracle.bmc.responses.AsyncHandler<ListWhitelistsRequest, ListWhitelistsResponse>
                    handler);

    /**
     * Gets a list of subnets (CIDR notation) from which the WAAS EDGE may make requests. The
     * subnets are owned by OCI and forward traffic to your origins. Allow traffic from these
     * subnets to your origins. They are not associated with specific regions or compartments.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListWorkRequestsResponse> listWorkRequests(
            ListWorkRequestsRequest request,
            com.oracle.bmc.responses.AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse>
                    handler);

    /**
     * Performs a purge of the cache for each specified resource. If no resources are passed, the
     * cache for the entire Web Application Firewall will be purged. For more information, see
     * [Caching Rules](https://docs.oracle.com/iaas/Content/WAF/Tasks/cachingrules.htm#purge).
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<PurgeCacheResponse> purgeCache(
            PurgeCacheRequest request,
            com.oracle.bmc.responses.AsyncHandler<PurgeCacheRequest, PurgeCacheResponse> handler);

    /**
     * Updates the list of access rules in the Web Application Firewall configuration for a
     * specified WAAS policy. Access rules allow explicit actions to be defined and executed for
     * requests that meet various conditions. A rule action can be set to allow, detect, or block
     * requests. The detect setting allows the request to pass through the Web Application Firewall
     * and is tagged with a `DETECT` flag in the Web Application Firewall's log.
     *
     * <p>This operation can create, delete, update, and/or reorder access rules depending on the
     * structure of the request body.
     *
     * <p>Access rules can be updated by changing the properties of the access rule object with the
     * rule's key specified in the key field. Access rules can be reordered by changing the order of
     * the access rules in the list when updating.
     *
     * <p>Access rules can be created by adding a new access rule object to the list without a `key`
     * property specified. A `key` will be generated for the new access rule upon update.
     *
     * <p>Any existing access rules that are not specified with a `key` in the list of access rules
     * will be deleted upon update.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateAccessRulesResponse> updateAccessRules(
            UpdateAccessRulesRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            UpdateAccessRulesRequest, UpdateAccessRulesResponse>
                    handler);

    /**
     * Updates the details of an address list. Only the fields specified in the request body will be
     * updated; all other properties will remain unchanged.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateAddressListResponse> updateAddressList(
            UpdateAddressListRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            UpdateAddressListRequest, UpdateAddressListResponse>
                    handler);

    /**
     * Updates the configuration for each specified caching rule.
     *
     * <p>Caching rules WAF policies allow you to selectively cache content on Oracle Cloud
     * Infrastructure's edge servers, such as webpages or certain file types. For more information
     * about caching rules, see [Caching
     * Rules](https://docs.oracle.com/iaas/Content/WAF/Tasks/cachingrules.htm).
     *
     * <p>This operation can create, delete, update, and/or reorder caching rules depending on the
     * structure of the request body. Caching rules can be updated by changing the properties of the
     * caching rule object with the rule's key specified in the key field. Any existing caching
     * rules that are not specified with a key in the list of access rules will be deleted upon
     * update.
     *
     * <p>The order the caching rules are specified in is important. The rules are processed in the
     * order they are specified and the first matching rule will be used when processing a request.
     * Use `ListCachingRules` to view a list of all available caching rules in a compartment.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateCachingRulesResponse> updateCachingRules(
            UpdateCachingRulesRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            UpdateCachingRulesRequest, UpdateCachingRulesResponse>
                    handler);

    /**
     * Updates the list of CAPTCHA challenges in the Web Application Firewall configuration for a
     * WAAS policy. This operation can create, update, or delete CAPTCHAs depending on the structure
     * of the request body. CAPTCHA challenges can be updated by changing the properties of the
     * CAPTCHA object with the rule's key specified in the key field. CAPTCHA challenges can be
     * reordered by changing the order of the CAPTCHA challenges in the list when updating.
     *
     * <p>CAPTCHA challenges can be created by adding a new access rule object to the list without a
     * `key` property specified. A `key` will be generated for the new CAPTCHA challenges upon
     * update.
     *
     * <p>Any existing CAPTCHA challenges that are not specified with a `key` in the list of CAPTCHA
     * challenges will be deleted upon update.
     *
     * <p>Query parameters are allowed in CAPTCHA URL.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateCaptchasResponse> updateCaptchas(
            UpdateCaptchasRequest request,
            com.oracle.bmc.responses.AsyncHandler<UpdateCaptchasRequest, UpdateCaptchasResponse>
                    handler);

    /**
     * It is not possible to update a certificate, only create and delete. Therefore, this operation
     * can only update the display name, freeform tags, and defined tags of a certificate.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateCertificateResponse> updateCertificate(
            UpdateCertificateRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            UpdateCertificateRequest, UpdateCertificateResponse>
                    handler);

    /**
     * Updates the configuration of a custom protection rule. Only the fields specified in the
     * request body will be updated; all other properties will remain unchanged.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateCustomProtectionRuleResponse> updateCustomProtectionRule(
            UpdateCustomProtectionRuleRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            UpdateCustomProtectionRuleRequest, UpdateCustomProtectionRuleResponse>
                    handler);

    /**
     * Updates the Device Fingerprint Challenge (DFC) settings in the Web Application Firewall
     * configuration for a policy. The DFC generates a hashed signature of both virtual and real
     * browsers based on 50+ attributes. These proprietary signatures are then leveraged for
     * real-time correlation to identify and block malicious bots.
     *
     * <p>The signature is based on a library of attributes detected via JavaScript listeners; the
     * attributes include OS, screen resolution, fonts, UserAgent, IP address, etc. We are
     * constantly making improvements and considering new libraries to include in our DFC build. We
     * can also exclude attributes from the signature as needed.
     *
     * <p>DFC collects attributes to generate a hashed signature about a client - if a fingerprint
     * is not possible, then it will result in a block or alert action. Actions can be enforced
     * across multiple devices if they share they have the same fingerprint.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateDeviceFingerprintChallengeResponse>
            updateDeviceFingerprintChallenge(
                    UpdateDeviceFingerprintChallengeRequest request,
                    com.oracle.bmc.responses.AsyncHandler<
                                    UpdateDeviceFingerprintChallengeRequest,
                                    UpdateDeviceFingerprintChallengeResponse>
                            handler);

    /**
     * Updates the list of good bots in the Web Application Firewall configuration for a policy.
     * Only the fields specified in the request body will be updated, all other configuration
     * properties will remain unchanged.
     *
     * <p>Good bots allows you to manage access for bots from known providers, such as Google or
     * Baidu. For more information about good bots, see [Bot
     * Management](https://docs.oracle.com/iaas/Content/WAF/Tasks/botmanagement.htm).
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateGoodBotsResponse> updateGoodBots(
            UpdateGoodBotsRequest request,
            com.oracle.bmc.responses.AsyncHandler<UpdateGoodBotsRequest, UpdateGoodBotsResponse>
                    handler);

    /**
     * Updates the Human Interaction Challenge (HIC) settings in the Web Application Firewall
     * configuration for a WAAS policy. HIC is a countermeasure that allows the proxy to check the
     * user's browser for various behaviors that distinguish a human presence from a bot.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateHumanInteractionChallengeResponse>
            updateHumanInteractionChallenge(
                    UpdateHumanInteractionChallengeRequest request,
                    com.oracle.bmc.responses.AsyncHandler<
                                    UpdateHumanInteractionChallengeRequest,
                                    UpdateHumanInteractionChallengeResponse>
                            handler);

    /**
     * Updates the JavaScript challenge settings in the Web Application Firewall configuration for a
     * WAAS policy. JavaScript Challenge validates that the client can accept JavaScript with a
     * binary decision. For more information, see [Bot
     * Management](https://docs.oracle.com/iaas/Content/WAF/Tasks/botmanagement.htm).
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateJsChallengeResponse> updateJsChallenge(
            UpdateJsChallengeRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            UpdateJsChallengeRequest, UpdateJsChallengeResponse>
                    handler);

    /**
     * Updates the configuration for a WAAS policy. Only the fields specified in the request body
     * will be updated; all other properties will remain unchanged.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdatePolicyConfigResponse> updatePolicyConfig(
            UpdatePolicyConfigRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            UpdatePolicyConfigRequest, UpdatePolicyConfigResponse>
                    handler);

    /**
     * Updates the action for each specified protection rule. Requests can either be allowed,
     * blocked, or trigger an alert if they meet the parameters of an applied rule. For more
     * information on protection rules, see [WAF Protection
     * Rules](https://docs.oracle.com/iaas/Content/WAF/Tasks/wafprotectionrules.htm). This operation
     * can update or disable protection rules depending on the structure of the request body.
     * Protection rules can be updated by changing the properties of the protection rule object with
     * the rule's key specified in the key field.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateProtectionRulesResponse> updateProtectionRules(
            UpdateProtectionRulesRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            UpdateProtectionRulesRequest, UpdateProtectionRulesResponse>
                    handler);

    /**
     * Updates the protection settings in the Web Application Firewall configuration for a WAAS
     * policy. Protection settings allow you define what action is taken when a request is blocked
     * by the Web Application Firewall, such as returning a response code or block page. Only the
     * fields specified in the request body will be updated; all other fields will remain unchanged.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateProtectionSettingsResponse> updateProtectionSettings(
            UpdateProtectionSettingsRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            UpdateProtectionSettingsRequest, UpdateProtectionSettingsResponse>
                    handler);

    /**
     * Updates the action to take when a request's IP address matches an address in the specified
     * threat intelligence feed. Threat intelligence feeds are compiled lists of IP addresses with
     * malicious reputations based on internet intelligence. Only the threat feeds specified in the
     * request body will be updated; all other threat feeds will remain unchanged.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateThreatFeedsResponse> updateThreatFeeds(
            UpdateThreatFeedsRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            UpdateThreatFeedsRequest, UpdateThreatFeedsResponse>
                    handler);

    /**
     * Updates the details of a WAAS policy, including origins and tags. Only the fields specified
     * in the request body will be updated; all other properties will remain unchanged. To update
     * platform provided resources such as `GoodBots`, `ProtectionRules`, and `ThreatFeeds`, first
     * retrieve the list of available resources with the related list operation such as
     * `GetThreatFeeds` or `GetProtectionRules`. The returned list will contain objects with `key`
     * properties that can be used to update the resource during the `UpdateWaasPolicy` request.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateWaasPolicyResponse> updateWaasPolicy(
            UpdateWaasPolicyRequest request,
            com.oracle.bmc.responses.AsyncHandler<UpdateWaasPolicyRequest, UpdateWaasPolicyResponse>
                    handler);

    /**
     * Updates the action for each specified custom protection rule. Only the `DETECT` and `BLOCK`
     * actions can be set. Disabled rules should not be included in the list. For more information
     * on protection rules, see [WAF Protection
     * Rules](https://docs.oracle.com/iaas/Content/WAF/Tasks/wafprotectionrules.htm).
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateWaasPolicyCustomProtectionRulesResponse>
            updateWaasPolicyCustomProtectionRules(
                    UpdateWaasPolicyCustomProtectionRulesRequest request,
                    com.oracle.bmc.responses.AsyncHandler<
                                    UpdateWaasPolicyCustomProtectionRulesRequest,
                                    UpdateWaasPolicyCustomProtectionRulesResponse>
                            handler);

    /**
     * Updates the address rate limiting settings in the Web Application Firewall configuration for
     * a policy. Rate limiting allows you to configure a threshold for the number of requests from a
     * unique IP address for the given period. You can also define the response code for the
     * requests from the same address that exceed the threshold.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateWafAddressRateLimitingResponse> updateWafAddressRateLimiting(
            UpdateWafAddressRateLimitingRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            UpdateWafAddressRateLimitingRequest,
                            UpdateWafAddressRateLimitingResponse>
                    handler);

    /**
     * Updates the Web Application Firewall configuration for a specified WAAS policy.
     *
     * <p>To update platform provided resources such as `GoodBots`, `ProtectionRules`, and
     * `ThreatFeeds`, first retrieve the list of available resources with the related list
     * operation, such as `GetThreatFeeds` or `GetProtectionRules`.
     *
     * <p>The returned list will contain objects with `key` properties that can be used to update
     * the resource during the `UpdateWafConfig` request.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateWafConfigResponse> updateWafConfig(
            UpdateWafConfigRequest request,
            com.oracle.bmc.responses.AsyncHandler<UpdateWafConfigRequest, UpdateWafConfigResponse>
                    handler);

    /**
     * Updates the list of IP addresses that bypass the Web Application Firewall for a WAAS policy.
     * Supports single IP addresses, subnet masks (CIDR notation) and Address Lists.
     *
     * <p>This operation can create, delete, update, and/or reorder whitelists depending on the
     * structure of the request body.
     *
     * <p>Whitelists can be updated by changing the properties of the whitelist object with the
     * rule's key specified in the `key` field. Whitelists can be reordered by changing the order of
     * the whitelists in the list of objects when updating.
     *
     * <p>Whitelists can be created by adding a new whitelist object to the list without a `key`
     * property specified. A `key` will be generated for the new whitelist upon update.
     *
     * <p>Whitelists can be deleted by removing the existing whitelist object from the list. Any
     * existing whitelists that are not specified with a `key` in the list of access rules will be
     * deleted upon update.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateWhitelistsResponse> updateWhitelists(
            UpdateWhitelistsRequest request,
            com.oracle.bmc.responses.AsyncHandler<UpdateWhitelistsRequest, UpdateWhitelistsResponse>
                    handler);
}
