/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.code.CodeInfoDecoderCounters;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.CodeInfoTableCounters;
import com.oracle.svm.core.code.ImageCodeInfo;
import com.oracle.svm.core.code.RuntimeCodeInfo;
import com.oracle.svm.core.util.CounterFeature;
import java.util.Arrays;
import java.util.List;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticFeature
class CodeInfoFeature
implements Feature {
    CodeInfoFeature() {
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(CounterFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(CodeInfoTableCounters.class, (Object)new CodeInfoTableCounters());
        ImageSingletons.add(CodeInfoDecoderCounters.class, (Object)new CodeInfoDecoderCounters());
        ImageSingletons.add(CodeInfoEncoder.Counters.class, (Object)new CodeInfoEncoder.Counters());
        ImageSingletons.add(ImageCodeInfo.class, (Object)new ImageCodeInfo());
        ImageSingletons.add(RuntimeCodeInfo.class, (Object)new RuntimeCodeInfo());
    }

    public void afterCompilation(Feature.AfterCompilationAccess config) {
        ImageCodeInfo imageInfo = CodeInfoTable.getImageCodeCache();
        config.registerAsImmutable((Object)imageInfo);
        config.registerAsImmutable((Object)imageInfo.codeInfoIndex);
        config.registerAsImmutable((Object)imageInfo.codeInfoEncodings);
        config.registerAsImmutable((Object)imageInfo.referenceMapEncoding);
        config.registerAsImmutable((Object)imageInfo.frameInfoEncodings);
        config.registerAsImmutable((Object)imageInfo.frameInfoObjectConstants);
        config.registerAsImmutable((Object)imageInfo.frameInfoSourceClassNames);
        config.registerAsImmutable((Object)imageInfo.frameInfoSourceMethodNames);
        config.registerAsImmutable((Object)imageInfo.frameInfoSourceFileNames);
        config.registerAsImmutable((Object)imageInfo.frameInfoNames);
    }
}

