/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.code.InstalledCodeObserver;
import com.oracle.svm.core.heap.PinnedAllocator;
import com.oracle.svm.core.meta.SharedMethod;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;

public final class InstalledCodeObserverSupport {
    private final List<InstalledCodeObserver.Factory> observerFactories = new ArrayList<InstalledCodeObserver.Factory>();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public InstalledCodeObserverSupport() {
    }

    public void addObserverFactory(InstalledCodeObserver.Factory observerFactory) {
        this.observerFactories.add(observerFactory);
    }

    public InstalledCodeObserver[] createObservers(DebugContext debug, SharedMethod method, CompilationResult compilation, Pointer code) {
        InstalledCodeObserver[] observers = new InstalledCodeObserver[this.observerFactories.size()];
        int index = 0;
        for (InstalledCodeObserver.Factory factory : this.observerFactories) {
            observers[index++] = factory.create(debug, method, compilation, code);
        }
        return observers;
    }

    public static InstalledCodeObserver.InstalledCodeObserverHandle[] installObservers(InstalledCodeObserver[] observers, PinnedAllocator metaInfoAllocator) {
        InstalledCodeObserver.InstalledCodeObserverHandle[] observerHandles = new InstalledCodeObserver.InstalledCodeObserverHandle[observers.length];
        int index = 0;
        for (InstalledCodeObserver observer : observers) {
            observerHandles[index++] = observer.install(metaInfoAllocator);
        }
        return observerHandles;
    }

    public static void activateObservers(InstalledCodeObserver.InstalledCodeObserverHandle[] observerHandles) {
        for (InstalledCodeObserver.InstalledCodeObserverHandle handle : observerHandles) {
            if (handle == null) continue;
            handle.activate();
        }
    }

    public static void removeObservers(InstalledCodeObserver.InstalledCodeObserverHandle[] observerHandles) {
        for (InstalledCodeObserver.InstalledCodeObserverHandle handle : observerHandles) {
            if (handle == null) continue;
            handle.release();
        }
    }
}

