/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.deopt;

import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMOperationControl;
import java.util.HashSet;
import java.util.Set;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

public class DeoptTester {
    private static final Set<Long> handledPCs = new HashSet<Long>();
    private static int inDeoptTest;
    private static final StackFrameVisitor collectPcVisitor;

    @NeverInline(value="deoptTest must have a separate stack frame")
    @SubstrateForeignCallTarget
    public static void deoptTest() {
        if (inDeoptTest > 0) {
            return;
        }
        ++inDeoptTest;
        try {
            if (Heap.getHeap().isAllocationDisallowed()) {
                return;
            }
            if (VMOperationControl.TestingBackdoor.isLocked()) {
                return;
            }
            if (VMOperation.isInProgress()) {
                return;
            }
            Pointer startSp = KnownIntrinsics.readCallerStackPointer();
            CodePointer startIp = KnownIntrinsics.readReturnAddress();
            int numHandledPCs = handledPCs.size();
            JavaStackWalker.walkCurrentThread(startSp, startIp, collectPcVisitor);
            if (handledPCs.size() > numHandledPCs) {
                Deoptimizer.deoptimizeAll();
            }
        }
        finally {
            --inDeoptTest;
        }
    }

    public static void disableDeoptTesting() {
        ++inDeoptTest;
    }

    public static void enableDeoptTesting() {
        --inDeoptTest;
    }

    static {
        collectPcVisitor = new StackFrameVisitor(){

            @Override
            @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, overridesCallers=true, reason="Only deals with IPs, not Objects.")
            public boolean visitFrame(Pointer sp, CodePointer ip, DeoptimizedFrame deoptimizedFrame) {
                handledPCs.add(ip.rawValue());
                return true;
            }
        };
    }
}

