/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.CollectionPolicy;
import com.oracle.svm.core.genscavenge.DiscoverableReferenceProcessing;
import com.oracle.svm.core.genscavenge.GarbageCollectorManagementFactory;
import com.oracle.svm.core.genscavenge.GreyToBlackObjRefVisitor;
import com.oracle.svm.core.genscavenge.GreyToBlackObjectVisitor;
import com.oracle.svm.core.genscavenge.HeapChunkProvider;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapOptions;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.Latch;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.OldGeneration;
import com.oracle.svm.core.genscavenge.PinnedObjectImpl;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import com.oracle.svm.core.heap.AllocationFreeList;
import com.oracle.svm.core.heap.CollectionWatcher;
import com.oracle.svm.core.heap.DiscoverableReference;
import com.oracle.svm.core.heap.FramePointerMapWalker;
import com.oracle.svm.core.heap.GC;
import com.oracle.svm.core.heap.NativeImageInfo;
import com.oracle.svm.core.heap.NoAllocationVerifier;
import com.oracle.svm.core.heap.ObjectReferenceWalker;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.jdk.SunMiscSupport;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.ThreadStackPrinter;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.TimeUtils;
import com.oracle.svm.core.util.VMError;
import java.lang.management.GarbageCollectorMXBean;
import java.util.List;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class GCImpl
implements GC {
    private static final int DECIMALS_IN_TIME_PRINTING = 7;
    private final GreyToBlackObjRefVisitor greyToBlackObjRefVisitor;
    private final FramePointerMapWalker frameWalker;
    private final GreyToBlackObjectVisitor greyToBlackObjectVisitor;
    private final CollectionPolicy alwaysCompletelyInstance;
    private final Accounting accounting;
    private final CollectionVMOperation collectVMOperation;
    private final OutOfMemoryError oldGenerationSizeExceeded;
    private final UnpinnedObjectReferenceWalkerException unpinnedObjectReferenceWalkerException;
    private final AllocationFreeList<ObjectReferenceWalker> objectReferenceWalkerList;
    private final AllocationFreeList<CollectionWatcher> collectionWatcherList;
    private final NoAllocationVerifier noAllocationVerifier;
    private final GarbageCollectorManagementFactory gcManagementFactory;
    private CollectionPolicy policy;
    private boolean completeCollection = false;
    private UnsignedWord sizeBefore;
    final Latch collectionInProgress;
    private UnsignedWord collectionEpoch;
    private DiscoverableReference discoveredReferenceList = null;
    private final Timer blackenBootImageRootsTimer;
    private final Timer blackenDirtyCardRootsTimer;
    private final Timer blackenStackRootsTimer;
    private final Timer cheneyScanFromRootsTimer;
    private final Timer cheneyScanFromDirtyRootsTimer;
    private final Timer collectionTimer;
    private final Timer discoverableReferenceTimer;
    private final Timer promotePinnedObjectsTimer;
    private final Timer rootScanTimer;
    private final Timer scanGreyObjectsTimer;
    private final Timer releaseSpacesTimer;
    private final Timer verifyAfterTimer;
    private final Timer verifyBeforeTimer;
    private final Timer walkRegisteredMemoryTimer;
    private final Timer watchersBeforeTimer;
    private final Timer watchersAfterTimer;
    private final Timer mutatorTimer;
    private final RememberedSetConstructor rememberedSetConstructor = new RememberedSetConstructor();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected GCImpl(Feature.FeatureAccess access) {
        this.accounting = Accounting.factory();
        this.collectVMOperation = new CollectionVMOperation();
        this.collectionEpoch = (UnsignedWord)WordFactory.zero();
        this.objectReferenceWalkerList = AllocationFreeList.factory();
        this.collectionWatcherList = AllocationFreeList.factory();
        this.noAllocationVerifier = NoAllocationVerifier.factory("GCImpl.GCImpl()", false);
        this.sizeBefore = (UnsignedWord)WordFactory.zero();
        this.policy = CollectionPolicy.getInitialPolicy(access);
        this.greyToBlackObjRefVisitor = GreyToBlackObjRefVisitor.factory();
        this.frameWalker = FramePointerMapWalker.factory(this.greyToBlackObjRefVisitor);
        this.greyToBlackObjectVisitor = GreyToBlackObjectVisitor.factory(this.greyToBlackObjRefVisitor);
        this.alwaysCompletelyInstance = new CollectionPolicy.OnlyCompletely();
        this.collectionInProgress = Latch.factory("Collection in progress");
        this.oldGenerationSizeExceeded = new OutOfMemoryError("Garbage-collected heap size exceeded.");
        this.unpinnedObjectReferenceWalkerException = new UnpinnedObjectReferenceWalkerException();
        this.gcManagementFactory = new GarbageCollectorManagementFactory();
        this.blackenBootImageRootsTimer = new Timer("blackenBootImageRoots");
        this.blackenDirtyCardRootsTimer = new Timer("blackenDirtyCardRoots");
        this.blackenStackRootsTimer = new Timer("blackenStackRoots");
        this.cheneyScanFromRootsTimer = new Timer("cheneyScanFromRoots");
        this.cheneyScanFromDirtyRootsTimer = new Timer("cheneyScanFromDirtyRoots");
        this.collectionTimer = new Timer("collection");
        this.discoverableReferenceTimer = new Timer("discoverableReferences");
        this.releaseSpacesTimer = new Timer("releaseSpaces");
        this.promotePinnedObjectsTimer = new Timer("promotePinnedObjects");
        this.rootScanTimer = new Timer("rootScan");
        this.scanGreyObjectsTimer = new Timer("scanGreyObject");
        this.verifyAfterTimer = new Timer("verifyAfter");
        this.verifyBeforeTimer = new Timer("verifyBefore");
        this.watchersBeforeTimer = new Timer("watchersBefore");
        this.watchersAfterTimer = new Timer("watchersAfter");
        this.mutatorTimer = new Timer("Mutator");
        this.walkRegisteredMemoryTimer = new Timer("walkRegisteredMemory");
        RuntimeSupport.getRuntimeSupport().addShutdownHook(this::printGCSummary);
    }

    @Override
    public void collect(String cause) {
        UnsignedWord requestingEpoch = this.possibleCollectionPrologue();
        this.collectWithoutAllocating(cause);
        this.possibleCollectionEpilogue(requestingEpoch);
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of garbage collection.")
    void collectWithoutAllocating(String cause) {
        this.collectVMOperation.enqueue(cause, this.getCollectionEpoch());
        OutOfMemoryError result = this.collectVMOperation.getResult();
        if (result != null) {
            throw result;
        }
    }

    private OutOfMemoryError collectOperation(String cause, UnsignedWord requestingEpoch) {
        Log trace = Log.noopLog().string("[GCImpl.collectOperation:").newline().string("  epoch: ").unsigned((WordBase)this.getCollectionEpoch()).string("  cause: ").string(cause).string("  requestingEpoch: ").unsigned((WordBase)requestingEpoch).newline();
        VMOperation.guaranteeInProgress("Collection should be a VMOperation.");
        if (this.getCollectionEpoch().aboveThan(requestingEpoch)) {
            trace.string("  epoch has moved on]").newline();
            return null;
        }
        this.mutatorTimer.close();
        this.startCollectionOrExit();
        this.resetTimers();
        this.incrementCollectionEpoch();
        ThreadLocalAllocation.disableThreadLocalAllocation();
        this.printGCBefore(cause);
        this.scrubLists();
        this.visitWatchersBefore();
        try {
            this.collectImpl(cause);
        }
        catch (Throwable t) {
            throw VMError.shouldNotReachHere(t);
        }
        OutOfMemoryError result = this.checkIfOutOfMemory();
        this.visitWatchersAfter();
        HeapPolicy.bytesAllocatedSinceLastCollection.set(WordFactory.zero());
        this.printGCAfter(cause);
        this.finishCollection();
        this.mutatorTimer.open();
        trace.string("]").newline();
        return result;
    }

    private void collectImpl(String cause) {
        Log trace = Log.noopLog().string("[GCImpl.collectImpl:").newline().string("  epoch: ").unsigned((WordBase)this.getCollectionEpoch()).string("  cause: ").string(cause).newline();
        VMOperation.guaranteeInProgress("Collection should be a VMOperation.");
        HeapImpl heap = HeapImpl.getHeapImpl();
        GCImpl.precondition();
        trace.string("  Begin collection: ");
        try (NoAllocationVerifier nav = this.noAllocationVerifier.open();){
            trace.string("  Verify before: ");
            try (Timer vbt = this.verifyBeforeTimer.open();){
                HeapImpl.getHeapImpl().verifyBeforeGC(cause, this.getCollectionEpoch());
            }
            CommittedMemoryProvider.get().beforeGarbageCollection();
            this.getAccounting().beforeCollection();
            var7_11 = null;
            try (Timer ct = this.collectionTimer.open();){
                if (this.getPolicy().collectIncrementally()) {
                    this.scavenge(true);
                }
                this.completeCollection = this.getPolicy().collectCompletely();
                if (this.completeCollection) {
                    this.scavenge(false);
                }
            }
            catch (Throwable throwable) {
                var7_11 = throwable;
                throw throwable;
            }
            CommittedMemoryProvider.get().afterGarbageCollection(this.completeCollection);
        }
        this.getAccounting().afterCollection(this.completeCollection, this.collectionTimer);
        trace.string("  Verify after: ");
        var5_5 = null;
        try (Timer vat = this.verifyAfterTimer.open();){
            heap.verifyAfterGC(cause, this.getCollectionEpoch());
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        this.postcondition();
        DiscoverableReferenceProcessing.Scatterer.distributeReferences();
        trace.string("]").newline();
    }

    private void printGCBefore(String cause) {
        Log verboseGCLog = Log.log();
        HeapImpl heap = HeapImpl.getHeapImpl();
        UnsignedWord unsignedWord = this.sizeBefore = SubstrateOptions.PrintGC.getValue() != false || HeapOptions.PrintHeapShape.getValue() != false ? heap.getUsedChunkBytes() : (UnsignedWord)WordFactory.zero();
        if (SubstrateOptions.VerboseGC.getValue().booleanValue() && this.getCollectionEpoch().equal(1)) {
            verboseGCLog.string("[Heap policy parameters: ").newline();
            verboseGCLog.string("  YoungGenerationSize: ").unsigned((WordBase)HeapPolicy.getMaximumYoungGenerationSize()).newline();
            verboseGCLog.string("      MaximumHeapSize: ").unsigned((WordBase)HeapPolicy.getMaximumHeapSize()).newline();
            verboseGCLog.string("      MinimumHeapSize: ").unsigned((WordBase)HeapPolicy.getMinimumHeapSize()).newline();
            verboseGCLog.string("     AlignedChunkSize: ").unsigned((WordBase)HeapPolicy.getAlignedHeapChunkSize()).newline();
            verboseGCLog.string("  LargeArrayThreshold: ").unsigned((WordBase)HeapPolicy.getLargeArrayThreshold()).string("]").newline();
            if (HeapOptions.PrintHeapShape.getValue().booleanValue()) {
                HeapImpl.getHeapImpl().bootImageHeapBoundariesToLog(verboseGCLog).newline();
            }
        }
        if (SubstrateOptions.VerboseGC.getValue().booleanValue()) {
            verboseGCLog.string("[");
            verboseGCLog.string("[");
            long startTime = System.nanoTime();
            if (SubstrateOptions.PrintGCTimeStamps.getValue().booleanValue()) {
                verboseGCLog.unsigned(TimeUtils.roundNanosToMillis(Timer.getTimeSinceFirstAllocation(startTime))).string(" msec: ");
            } else {
                verboseGCLog.unsigned(startTime);
            }
            verboseGCLog.string(" GC:").string(" before").string("  epoch: ").unsigned((WordBase)this.getCollectionEpoch()).string("  cause: ").string(cause);
            if (HeapOptions.PrintHeapShape.getValue().booleanValue()) {
                heap.report(verboseGCLog);
            }
            verboseGCLog.string("]").newline();
        }
    }

    private void printGCAfter(String cause) {
        Log verboseGCLog = Log.log();
        HeapImpl heap = HeapImpl.getHeapImpl();
        if (SubstrateOptions.PrintGC.getValue().booleanValue() || SubstrateOptions.VerboseGC.getValue().booleanValue()) {
            if (SubstrateOptions.PrintGC.getValue().booleanValue()) {
                Log printGCLog = Log.log();
                UnsignedWord sizeAfter = heap.getUsedChunkBytes();
                printGCLog.string("[");
                if (SubstrateOptions.PrintGCTimeStamps.getValue().booleanValue()) {
                    long finishNanos = this.collectionTimer.getFinish();
                    printGCLog.unsigned(TimeUtils.roundNanosToMillis(Timer.getTimeSinceFirstAllocation(finishNanos))).string(" msec: ");
                }
                printGCLog.string(this.completeCollection ? "Full GC" : "Incremental GC");
                printGCLog.string(" (").string(cause).string(") ");
                printGCLog.unsigned((WordBase)this.sizeBefore.unsignedDivide(1024));
                printGCLog.string("K->");
                printGCLog.unsigned((WordBase)sizeAfter.unsignedDivide(1024)).string("K, ");
                printGCLog.rational(this.collectionTimer.getCollectedNanos(), 1000000000L, 7L).string(" secs");
                printGCLog.string("]").newline();
            }
            if (SubstrateOptions.VerboseGC.getValue().booleanValue()) {
                verboseGCLog.string(" [");
                long finishNanos = this.collectionTimer.getFinish();
                if (SubstrateOptions.PrintGCTimeStamps.getValue().booleanValue()) {
                    verboseGCLog.unsigned(TimeUtils.roundNanosToMillis(Timer.getTimeSinceFirstAllocation(finishNanos))).string(" msec: ");
                } else {
                    verboseGCLog.unsigned(finishNanos);
                }
                verboseGCLog.string(" GC:").string(" after ").string("  epoch: ").unsigned((WordBase)this.getCollectionEpoch()).string("  cause: ").string(cause);
                verboseGCLog.string("  policy: ");
                this.getPolicy().nameToLog(verboseGCLog);
                verboseGCLog.string("  type: ").string(this.completeCollection ? "complete" : "incremental");
                if (HeapOptions.PrintHeapShape.getValue().booleanValue()) {
                    heap.report(verboseGCLog);
                }
                if (!HeapOptions.PrintGCTimes.getValue().booleanValue()) {
                    verboseGCLog.newline();
                    verboseGCLog.string("  collection time: ").unsigned(this.collectionTimer.getCollectedNanos()).string(" nanoSeconds");
                } else {
                    this.logGCTimers(verboseGCLog);
                }
                verboseGCLog.string("]");
                verboseGCLog.string("]").newline();
            }
        }
    }

    private static void precondition() {
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        assert (oldGen.getToSpace().isEmpty()) : "oldGen.getToSpace() should be empty before a collection.";
        assert (oldGen.getPinnedToSpace().isEmpty()) : "oldGen.getPinnedToSpace() should be empty before a collection.";
    }

    private void postcondition() {
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        OldGeneration oldGen = heap.getOldGeneration();
        this.verbosePostCondition();
        assert (youngGen.getSpace().isEmpty()) : "youngGen.getSpace() should be empty after a collection.";
        assert (oldGen.getToSpace().isEmpty()) : "oldGen.getToSpace() should be empty after a collection.";
        assert (oldGen.getPinnedToSpace().isEmpty()) : "oldGen.getPinnedToSpace() should be empty after a collection.";
    }

    private void verbosePostCondition() {
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        OldGeneration oldGen = heap.getOldGeneration();
        boolean forceForTesting = false;
        if (GCImpl.runtimeAssertions()) {
            Log witness = Log.log();
            if (!youngGen.getSpace().isEmpty()) {
                witness.string("[GCImpl.postcondition: youngGen space should be empty after a collection.").newline();
                witness.string("  These should all be 0:").newline();
                witness.string("    youngGen space first AlignedChunk:   ").hex((WordBase)youngGen.getSpace().getFirstAlignedHeapChunk()).newline();
                witness.string("    youngGen space last  AlignedChunk:   ").hex((WordBase)youngGen.getSpace().getLastAlignedHeapChunk()).newline();
                witness.string("    youngGen space first UnalignedChunk: ").hex((WordBase)youngGen.getSpace().getFirstUnalignedHeapChunk()).newline();
                witness.string("    youngGen space last  UnalignedChunk: ").hex((WordBase)youngGen.getSpace().getLastUnalignedHeapChunk()).newline();
                youngGen.getSpace().report(witness, true).newline();
                witness.string("  verifying the heap:");
                heap.verifyAfterGC("because youngGen space is not empty", this.getCollectionEpoch());
                witness.string("]").newline();
            }
            if (!oldGen.getToSpace().isEmpty()) {
                witness.string("[GCImpl.postcondition: oldGen toSpace should be empty after a collection.").newline();
                witness.string("  These should all be 0:").newline();
                witness.string("    oldGen toSpace first AlignedChunk:   ").hex((WordBase)oldGen.getToSpace().getFirstAlignedHeapChunk()).newline();
                witness.string("    oldGen toSpace last  AlignedChunk:   ").hex((WordBase)oldGen.getToSpace().getLastAlignedHeapChunk()).newline();
                witness.string("    oldGen.toSpace first UnalignedChunk: ").hex((WordBase)oldGen.getToSpace().getFirstUnalignedHeapChunk()).newline();
                witness.string("    oldGen.toSpace last  UnalignedChunk: ").hex((WordBase)oldGen.getToSpace().getLastUnalignedHeapChunk()).newline();
                oldGen.getToSpace().report(witness, true).newline();
                oldGen.getFromSpace().report(witness, true).newline();
                witness.string("  verifying the heap:");
                heap.verifyAfterGC("because oldGen toSpace is not empty", this.getCollectionEpoch());
                witness.string("]").newline();
            }
            if (!oldGen.getPinnedToSpace().isEmpty()) {
                witness.string("[GCImpl.postcondition: oldGen pinnedToSpace should be empty after a collection.").newline();
                witness.string("  These should all be 0:").newline();
                witness.string("    oldGen pinnedToSpace first AlignedChunk:   ").hex((WordBase)oldGen.getPinnedToSpace().getFirstAlignedHeapChunk()).newline();
                witness.string("    oldGen pinnedToSpace last  AlignedChunk:   ").hex((WordBase)oldGen.getPinnedToSpace().getLastAlignedHeapChunk()).newline();
                witness.string("    oldGen pinnedToSpace first UnalignedChunk: ").hex((WordBase)oldGen.getPinnedToSpace().getFirstUnalignedHeapChunk()).newline();
                witness.string("    oldGen pinnedToSpace last  UnalignedChunk: ").hex((WordBase)oldGen.getPinnedToSpace().getLastUnalignedHeapChunk()).newline();
                oldGen.getPinnedToSpace().report(witness, true).newline();
                oldGen.getPinnedFromSpace().report(witness, true).newline();
                witness.string("  verifying the heap:");
                heap.verifyAfterGC("because oldGen pinnedToSpace is not empty", this.getCollectionEpoch());
                witness.string("]").newline();
            }
        }
    }

    private OutOfMemoryError checkIfOutOfMemory() {
        UnsignedWord inUse;
        OutOfMemoryError result = null;
        UnsignedWord allowed = HeapPolicy.getMaximumHeapSize();
        if (allowed.belowThan(inUse = this.getAccounting().getOldGenerationAfterChunkBytes())) {
            result = this.oldGenerationSizeExceeded;
        }
        return result;
    }

    @Fold
    static boolean runtimeAssertions() {
        return SubstrateOptions.RuntimeAssertions.getValue() != false && SubstrateOptions.getRuntimeAssertionsFilter().test(GCImpl.class.getName());
    }

    @Override
    public void collectCompletely(String cause) {
        CollectionPolicy oldPolicy = this.getPolicy();
        try {
            this.setPolicy(this.alwaysCompletelyInstance);
            this.collect(cause);
        }
        finally {
            this.setPolicy(oldPolicy);
        }
    }

    private void scavenge(boolean fromDirtyRoots) {
        Log trace = Log.noopLog().string("[GCImpl.scavenge:").string("  fromDirtyRoots: ").bool(fromDirtyRoots).newline();
        DiscoverableReferenceProcessing.clearDiscoveredReferences();
        try (Timer rst = this.rootScanTimer.open();){
            trace.string("  Cheney scan: ");
            if (fromDirtyRoots) {
                this.cheneyScanFromDirtyRoots();
            } else {
                this.cheneyScanFromRoots();
            }
        }
        trace.string("  Discovered references: ");
        var4_4 = null;
        try (Timer drt = this.discoverableReferenceTimer.open();){
            DiscoverableReferenceProcessing.processDiscoveredReferences();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        trace.string("  Release spaces: ");
        rst = this.releaseSpacesTimer.open();
        var4_4 = null;
        try {
            this.releaseSpaces();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (rst != null) {
                if (var4_4 != null) {
                    try {
                        rst.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    rst.close();
                }
            }
        }
        trace.string("  Swap spaces: ");
        GCImpl.swapSpaces();
        trace.string("]").newline();
    }

    private void cheneyScanFromRoots() {
        Log trace = Log.noopLog().string("[GCImpl.cheneyScanFromRoots:").newline();
        try (Timer csfrt = this.cheneyScanFromRootsTimer.open();){
            boolean objectVisitorPrologue = this.greyToBlackObjectVisitor.prologue();
            assert (objectVisitorPrologue) : "greyToBlackObjectVisitor prologue fails";
            boolean objRefVisitorPrologue = this.greyToBlackObjRefVisitor.prologue();
            assert (objRefVisitorPrologue) : "greyToBlackObjRefVisitor prologue fails";
            GCImpl.prepareForPromotion();
            this.promoteAllPinnedObjects();
            this.blackenStackRoots();
            this.walkRegisteredObjectReferences();
            this.blackenBootImageRoots();
            this.scanGreyObjects();
            boolean objRefVisitorEpilogue = this.greyToBlackObjRefVisitor.epilogue();
            assert (objRefVisitorEpilogue) : "greyToBlackObjRefVisitor epilogue fails";
            boolean objectVisitorEpilogue = this.greyToBlackObjectVisitor.epilogue();
            assert (objectVisitorEpilogue) : "greyToBlackObjectVisitor epilogue fails";
        }
        trace.string("]").newline();
    }

    private void cheneyScanFromDirtyRoots() {
        Log trace = Log.noopLog().string("[GCImpl.cheneyScanFromDirtyRoots:").newline();
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        try (Timer csfdrt = this.cheneyScanFromDirtyRootsTimer.open();){
            oldGen.emptyFromSpaceIntoToSpace();
            boolean objectVisitorPrologue = this.greyToBlackObjectVisitor.prologue();
            assert (objectVisitorPrologue) : "greyToBlackObjectVisitor prologue fails";
            boolean objRefVisitorPrologue = this.greyToBlackObjRefVisitor.prologue();
            assert (objRefVisitorPrologue) : "greyToBlackObjRefVisitor prologue fails";
            GCImpl.prepareForPromotion();
            this.promoteAllPinnedObjects();
            this.blackenDirtyCardRoots();
            this.blackenStackRoots();
            this.walkRegisteredObjectReferences();
            this.blackenBootImageRoots();
            this.scanGreyObjects();
            boolean objRefVisitorEpilogue = this.greyToBlackObjRefVisitor.epilogue();
            assert (objRefVisitorEpilogue) : "greyToBlackObjRefVisitor epilogue fails";
            boolean objectVisitorEpilogue = this.greyToBlackObjectVisitor.epilogue();
            assert (objectVisitorEpilogue) : "greyToBlackObjectVisitor epilogue fails";
        }
        trace.string("]").newline();
    }

    private void promoteAllPinnedObjects() {
        Log trace = Log.noopLog().string("[GCImpl.promoteAllPinnedObjects:").newline();
        try (Timer ppot = this.promotePinnedObjectsTimer.open();){
            GCImpl.promoteIndividualPinnedObjects();
            GCImpl.promotePinnedAllocatorObjects(this.completeCollection);
        }
        trace.string("]").newline();
    }

    private static void promoteIndividualPinnedObjects() {
        PinnedObjectImpl oldList;
        Log trace = Log.noopLog().string("[GCImpl.promoteIndividualPinnedObjects:").newline();
        PinnedObjectImpl rest = oldList = PinnedObjectImpl.claimPinnedObjectList();
        while (rest != null) {
            PinnedObjectImpl first = rest;
            PinnedObjectImpl next = first.getNext();
            if (first.isOpen()) {
                GCImpl.promotePinnedObject(first);
                PinnedObjectImpl.pushPinnedObject(first);
            }
            rest = next;
        }
        trace.string("]").newline();
    }

    private static void promotePinnedAllocatorObjects(boolean completeCollection) {
        Log trace = Log.noopLog().string("[GCImpl.promotePinnedAllocatorObjects:").newline();
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGeneration = heap.getOldGeneration();
        oldGeneration.promotePinnedAllocatorChunks(completeCollection);
        trace.string("]").newline();
    }

    private void blackenStackRoots() {
        Log trace = Log.noopLog().string("[GCImpl.blackenStackRoots:").newline();
        try (Timer bsr = this.blackenStackRootsTimer.open();){
            Pointer sp = KnownIntrinsics.readCallerStackPointer();
            trace.string("[blackenStackRoots:").string("  sp: ").hex((WordBase)sp);
            CodePointer ip = KnownIntrinsics.readReturnAddress();
            trace.string("  ip: ").hex((WordBase)ip).newline();
            JavaStackWalker.walkCurrentThread(sp, ip, this.frameWalker);
            if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
                IsolateThread vmThread = VMThreads.firstThread();
                while (VMThreads.isNonNullThread(vmThread)) {
                    if (vmThread != CurrentIsolate.getCurrentThread()) {
                        JavaStackWalker.walkThread(vmThread, this.frameWalker);
                        trace.newline();
                    }
                    vmThread = VMThreads.nextThread(vmThread);
                }
            }
            trace.string("]").newline();
        }
        trace.string("]").newline();
    }

    private void walkRegisteredObjectReferences() {
        Log trace = Log.noopLog().string("[walkRegisteredObjectReferences").string(":").newline();
        try (Timer wrm = this.walkRegisteredMemoryTimer.open();){
            Object element = this.objectReferenceWalkerList.getFirstObject();
            while (element != null) {
                if (!HeapImpl.getHeapImpl().isPinned(element)) {
                    throw this.unpinnedObjectReferenceWalkerException;
                }
                element = ((AllocationFreeList.Element)element).getNextObject();
            }
            for (ObjectReferenceWalker walker = this.objectReferenceWalkerList.getFirst(); walker != null; walker = (ObjectReferenceWalker)walker.getNextElement()) {
                trace.string("[").string(walker.getWalkerName()).string(":");
                trace.newline();
                walker.walk(this.greyToBlackObjRefVisitor);
                trace.string("]").newline();
            }
        }
        trace.string("]").newline();
    }

    private void blackenBootImageRoots() {
        Log trace = Log.noopLog().string("[blackenBootImageRoots:").newline();
        try (Timer bbirt = this.blackenBootImageRootsTimer.open();
             GreyToBlackObjRefVisitor.Counters gtborv = this.greyToBlackObjRefVisitor.openCounters();){
            Word cur = Word.objectToUntrackedPointer((Object)NativeImageInfo.firstWritableReferenceObject);
            Word last = Word.objectToUntrackedPointer((Object)NativeImageInfo.lastWritableReferenceObject);
            while (cur.belowOrEqual((UnsignedWord)last)) {
                Object obj = cur.toObject();
                if (obj != null) {
                    this.greyToBlackObjectVisitor.visitObjectInline(obj);
                }
                cur = LayoutEncoding.getObjectEnd(obj);
            }
        }
        trace.string("]").newline();
    }

    private void blackenDirtyCardRoots() {
        Log trace = Log.noopLog().string("[GCImpl.blackenDirtyCardRoots:").newline();
        try (Timer bdcrt = this.blackenDirtyCardRootsTimer.open();){
            HeapImpl heap = HeapImpl.getHeapImpl();
            OldGeneration oldGen = heap.getOldGeneration();
            oldGen.walkDirtyObjects(this.greyToBlackObjectVisitor, true);
        }
        trace.string("]").newline();
    }

    private static void prepareForPromotion() {
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        oldGen.prepareForPromotion();
    }

    private void scanGreyObjects() {
        Log trace = Log.noopLog().string("[GCImpl.scanGreyObjects").newline();
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        try (Timer sgot = this.scanGreyObjectsTimer.open();){
            oldGen.scanGreyObjects();
        }
        trace.string("]").newline();
    }

    private static void promotePinnedObject(PinnedObjectImpl pinned) {
        Log trace = Log.noopLog().string("[GCImpl.promotePinnedObject").string("  pinned: ").object(pinned);
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        Space toSpace = oldGen.getToSpace();
        Object referent = pinned.getObject();
        if (referent != null && ObjectHeaderImpl.getObjectHeaderImpl().isHeapAllocated(referent)) {
            trace.string("  referent: ").object(referent);
            toSpace.promoteObjectChunk(referent);
        }
        trace.string("]").newline();
    }

    private static void swapSpaces() {
        Log trace = Log.noopLog().string("[GCImpl.swapSpaces:");
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        oldGen.swapSpaces();
        trace.string("]").newline();
    }

    private void releaseSpaces() {
        Log trace = Log.noopLog().string("[GCImpl.releaseSpaces:");
        HeapImpl heap = HeapImpl.getHeapImpl();
        heap.getYoungGeneration().releaseSpaces();
        if (this.completeCollection) {
            heap.getOldGeneration().releaseSpaces();
        }
        trace.string("]").newline();
    }

    private void startCollectionOrExit() {
        CollectionInProgressError.exitIf(this.collectionInProgress.getState());
        this.collectionInProgress.open();
    }

    private void finishCollection() {
        this.collectionInProgress.close();
    }

    UnsignedWord possibleCollectionPrologue() {
        return this.getCollectionEpoch();
    }

    void possibleCollectionEpilogue(UnsignedWord requestingEpoch) {
        if (requestingEpoch.belowThan(this.getCollectionEpoch())) {
            SunMiscSupport.drainCleanerQueue();
            this.visitWatchersReport();
        }
    }

    UnsignedWord getCollectionEpoch() {
        return this.collectionEpoch;
    }

    private void incrementCollectionEpoch() {
        this.collectionEpoch = this.collectionEpoch.add(1);
    }

    @Override
    public void registerObjectReferenceWalker(ObjectReferenceWalker walker) throws AllocationFreeList.PreviouslyRegisteredElementException, UnpinnedObjectReferenceWalkerException {
        if (walker.getHasBeenOnList()) {
            throw new AllocationFreeList.PreviouslyRegisteredElementException("Attempting to reuse a previously-registered ObjectReferenceWalker.");
        }
        this.objectReferenceWalkerList.prepend(walker);
    }

    @Override
    public void unregisterObjectReferenceWalker(ObjectReferenceWalker walker) {
        walker.removeElement();
    }

    @Override
    public void registerCollectionWatcher(CollectionWatcher watcher) throws AllocationFreeList.PreviouslyRegisteredElementException {
        if (watcher.getHasBeenOnList()) {
            throw new AllocationFreeList.PreviouslyRegisteredElementException("Attempting to reuse a previously-registered CollectionWatcher.");
        }
        this.collectionWatcherList.prepend(watcher);
    }

    @Override
    public void unregisterCollectionWatcher(CollectionWatcher watcher) {
        watcher.removeElement();
    }

    private void visitWatchersBefore() {
        Log trace = Log.noopLog().string("[GCImpl.visitWatchersBefore:").newline();
        trace.string("  Watchers before: ");
        try (Timer wbt = this.watchersBeforeTimer.open();){
            for (CollectionWatcher watcher = this.collectionWatcherList.getFirst(); watcher != null; watcher = (CollectionWatcher)watcher.getNextElement()) {
                try {
                    watcher.beforeCollection();
                    continue;
                }
                catch (Throwable t) {
                    trace.string("[GCImpl.visitWatchersBefore: Caught: ").string(t.getClass().getName()).string("]").newline();
                }
            }
        }
        trace.string("]").newline();
    }

    private void visitWatchersAfter() {
        Log trace = Log.noopLog().string("[GCImpl.visitWatchersAfter:").newline();
        trace.string("  Watchers after: ");
        try (Timer wat = this.watchersAfterTimer.open();){
            for (CollectionWatcher watcher = this.collectionWatcherList.getFirst(); watcher != null; watcher = (CollectionWatcher)watcher.getNextElement()) {
                try {
                    watcher.afterCollection();
                    continue;
                }
                catch (Throwable t) {
                    trace.string("[GCImpl.visitWatchersAfter: Caught: ").string(t.getClass().getName()).string("]").newline();
                }
            }
        }
        trace.string("]").newline();
    }

    private void visitWatchersReport() {
        Log trace = Log.noopLog().string("[GCImpl.visitWatchersReport:").newline();
        VMOperation.enqueueBlockingNoSafepoint("GCImpl.visitWatchersReport", () -> {
            for (CollectionWatcher watcher = this.collectionWatcherList.getFirst(); watcher != null; watcher = (CollectionWatcher)watcher.getNextElement()) {
                try {
                    watcher.report();
                    continue;
                }
                catch (Throwable t) {
                    trace.string("[GCImpl.visitWatchersReport: Caught: ").string(t.getClass().getName()).string("]").newline();
                }
            }
        });
        trace.string("]").newline();
    }

    private void scrubLists() {
        this.collectionWatcherList.scrub();
        this.objectReferenceWalkerList.scrub();
    }

    protected Accounting getAccounting() {
        return this.accounting;
    }

    private CollectionPolicy getPolicy() {
        return this.policy;
    }

    private void setPolicy(CollectionPolicy newPolicy) {
        this.policy = newPolicy;
    }

    DiscoverableReference getDiscoveredReferenceList() {
        return this.discoveredReferenceList;
    }

    void setDiscoveredReferenceList(DiscoverableReference newList) {
        this.discoveredReferenceList = newList;
    }

    GreyToBlackObjectVisitor getGreyToBlackObjectVisitor() {
        return this.greyToBlackObjectVisitor;
    }

    private void resetTimers() {
        Log trace = Log.noopLog();
        trace.string("[GCImpl.resetTimers:");
        this.watchersBeforeTimer.reset();
        this.verifyBeforeTimer.reset();
        this.collectionTimer.reset();
        this.rootScanTimer.reset();
        this.cheneyScanFromRootsTimer.reset();
        this.cheneyScanFromDirtyRootsTimer.reset();
        this.promotePinnedObjectsTimer.reset();
        this.blackenStackRootsTimer.reset();
        this.walkRegisteredMemoryTimer.reset();
        this.blackenBootImageRootsTimer.reset();
        this.blackenDirtyCardRootsTimer.reset();
        this.scanGreyObjectsTimer.reset();
        this.discoverableReferenceTimer.reset();
        this.releaseSpacesTimer.reset();
        this.verifyAfterTimer.reset();
        this.watchersAfterTimer.reset();
        trace.string("]").newline();
    }

    private void logGCTimers(Log log) {
        if (log.isEnabled()) {
            log.newline();
            log.string("  [GC nanoseconds:");
            GCImpl.logOneTimer(log, "    ", this.watchersBeforeTimer);
            GCImpl.logOneTimer(log, "    ", this.verifyBeforeTimer);
            GCImpl.logOneTimer(log, "    ", this.collectionTimer);
            GCImpl.logOneTimer(log, "      ", this.rootScanTimer);
            GCImpl.logOneTimer(log, "        ", this.cheneyScanFromRootsTimer);
            GCImpl.logOneTimer(log, "        ", this.cheneyScanFromDirtyRootsTimer);
            GCImpl.logOneTimer(log, "          ", this.promotePinnedObjectsTimer);
            GCImpl.logOneTimer(log, "          ", this.blackenStackRootsTimer);
            GCImpl.logOneTimer(log, "          ", this.walkRegisteredMemoryTimer);
            GCImpl.logOneTimer(log, "          ", this.blackenBootImageRootsTimer);
            GCImpl.logOneTimer(log, "          ", this.blackenDirtyCardRootsTimer);
            GCImpl.logOneTimer(log, "          ", this.scanGreyObjectsTimer);
            GCImpl.logOneTimer(log, "      ", this.discoverableReferenceTimer);
            GCImpl.logOneTimer(log, "      ", this.releaseSpacesTimer);
            GCImpl.logOneTimer(log, "    ", this.verifyAfterTimer);
            GCImpl.logOneTimer(log, "    ", this.watchersAfterTimer);
            GCImpl.logGCLoad(log, "    ", "GCLoad", this.collectionTimer, this.mutatorTimer);
            log.string("]");
        }
    }

    private static void logOneTimer(Log log, String prefix, Timer timer) {
        if (timer.getCollectedNanos() > 0L) {
            log.newline().string(prefix).string(timer.getName()).string(": ").signed(timer.getCollectedNanos());
        }
    }

    private static void logGCLoad(Log log, String prefix, String label, Timer cTimer, Timer mTimer) {
        long collectionNanos = cTimer.getLastIntervalNanos();
        long mutatorNanos = mTimer.getLastIntervalNanos();
        long intervalNanos = mutatorNanos + collectionNanos;
        long intervalGCPercent = (100L * collectionNanos + intervalNanos / 2L) / intervalNanos;
        log.newline().string(prefix).string(label).string(": ").signed(intervalGCPercent).string("%");
    }

    RememberedSetConstructor getRememberedSetConstructor() {
        return this.rememberedSetConstructor;
    }

    private void printGCSummary() {
        if (!SubstrateOptions.PrintGCSummary.getValue().booleanValue()) {
            return;
        }
        Log log = Log.log();
        String prefix = "PrintGCSummary: ";
        log.string("PrintGCSummary: ").string("YoungGenerationSize: ").unsigned((WordBase)HeapPolicy.getMaximumYoungGenerationSize()).newline();
        log.string("PrintGCSummary: ").string("MinimumHeapSize: ").unsigned((WordBase)HeapPolicy.getMinimumHeapSize()).newline();
        log.string("PrintGCSummary: ").string("MaximumHeapSize: ").unsigned((WordBase)HeapPolicy.getMaximumHeapSize()).newline();
        log.string("PrintGCSummary: ").string("AlignedChunkSize: ").unsigned((WordBase)HeapPolicy.getAlignedHeapChunkSize()).newline();
        VMOperation.enqueueBlockingSafepoint("PrintGCSummaryShutdownHook", ThreadLocalAllocation::disableThreadLocalAllocation);
        HeapImpl heap = HeapImpl.getHeapImpl();
        Space youngSpace = heap.getYoungGeneration().getSpace();
        UnsignedWord youngChunkBytes = youngSpace.getChunkBytes();
        UnsignedWord youngObjectBytes = youngSpace.getObjectBytes();
        Space pinnedSpace = heap.getOldGeneration().getPinnedFromSpace();
        UnsignedWord pinnedChunkBytes = pinnedSpace.getChunkBytes().subtract(this.accounting.getPinnedChunkBytesAfter());
        UnsignedWord pinnedObjectBytes = pinnedSpace.getObjectBytes().subtract(this.accounting.getPinnedObjectBytesAfter());
        UnsignedWord allocatedNormalChunkBytes = this.accounting.getNormalChunkBytes().add(youngChunkBytes);
        UnsignedWord allocatedNormalObjectBytes = this.accounting.getNormalObjectBytes().add(youngObjectBytes);
        UnsignedWord allocatedPinnedChunkBytes = this.accounting.getPinnedChunkBytes().add(pinnedChunkBytes);
        UnsignedWord allocatedPinnedObjectBytes = this.accounting.getPinnedObjectBytes().add(pinnedObjectBytes);
        UnsignedWord allocatedTotalChunkBytes = allocatedNormalChunkBytes.add(allocatedPinnedChunkBytes);
        UnsignedWord allocatedTotalObjectBytes = allocatedNormalObjectBytes.add(allocatedPinnedObjectBytes);
        log.string("PrintGCSummary: ").string("CollectedTotalChunkBytes: ").signed((WordBase)this.accounting.getCollectedTotalChunkBytes()).newline();
        log.string("PrintGCSummary: ").string("CollectedTotalObjectBytes: ").signed((WordBase)this.accounting.getCollectedTotalObjectBytes()).newline();
        log.string("PrintGCSummary: ").string("AllocatedNormalChunkBytes: ").signed((WordBase)allocatedNormalChunkBytes).newline();
        log.string("PrintGCSummary: ").string("AllocatedNormalObjectBytes: ").signed((WordBase)allocatedNormalObjectBytes).newline();
        log.string("PrintGCSummary: ").string("AllocatedPinnedChunkBytes: ").signed((WordBase)allocatedPinnedChunkBytes).newline();
        log.string("PrintGCSummary: ").string("AllocatedPinnedObjectBytes: ").signed((WordBase)allocatedPinnedObjectBytes).newline();
        log.string("PrintGCSummary: ").string("AllocatedTotalChunkBytes: ").signed((WordBase)allocatedTotalChunkBytes).newline();
        log.string("PrintGCSummary: ").string("AllocatedTotalObjectBytes: ").signed((WordBase)allocatedTotalObjectBytes).newline();
        long incrementalNanos = this.accounting.getIncrementalCollectionTotalNanos();
        log.string("PrintGCSummary: ").string("IncrementalGCCount: ").signed(this.accounting.getIncrementalCollectionCount()).newline();
        log.string("PrintGCSummary: ").string("IncrementalGCNanos: ").signed(incrementalNanos).newline();
        long completeNanos = this.accounting.getCompleteCollectionTotalNanos();
        log.string("PrintGCSummary: ").string("CompleteGCCount: ").signed(this.accounting.getCompleteCollectionCount()).newline();
        log.string("PrintGCSummary: ").string("CompleteGCNanos: ").signed(completeNanos).newline();
        long gcNanos = incrementalNanos + completeNanos;
        long mutatorNanos = this.mutatorTimer.getCollectedNanos();
        long totalNanos = gcNanos + mutatorNanos;
        long roundedGCLoad = 0L < totalNanos ? TimeUtils.roundedDivide(100L * gcNanos, totalNanos) : 0L;
        log.string("PrintGCSummary: ").string("GCNanos: ").signed(gcNanos).newline();
        log.string("PrintGCSummary: ").string("TotalNanos: ").signed(totalNanos).newline();
        log.string("PrintGCSummary: ").string("GCLoadPercent: ").signed(roundedGCLoad).newline();
    }

    @Override
    public List<GarbageCollectorMXBean> getGarbageCollectorMXBeanList() {
        return this.gcManagementFactory.getGCBeanList();
    }

    public static class UnpinnedObjectReferenceWalkerException
    extends RuntimeException {
        private static final long serialVersionUID = -7558859901392977054L;

        UnpinnedObjectReferenceWalkerException() {
            super("ObjectReferenceWalker should be pinned.");
        }
    }

    public static final class CollectionVMOperation
    extends VMOperation {
        private String cause = "TooSoonToTell";
        private UnsignedWord requestingEpoch = (UnsignedWord)WordFactory.zero();
        private OutOfMemoryError result = null;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        CollectionVMOperation() {
            super("GarbageCollection", VMOperation.CallerEffect.BLOCKS_CALLER, VMOperation.SystemEffect.CAUSES_SAFEPOINT);
        }

        void enqueue(String causeArg, UnsignedWord requestingEpochArg) {
            this.cause = causeArg;
            this.requestingEpoch = requestingEpochArg;
            this.result = null;
            this.enqueue();
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while collecting")
        public void operate() {
            this.result = HeapImpl.getHeapImpl().getGCImpl().collectOperation(this.cause, this.requestingEpoch);
        }

        OutOfMemoryError getResult() {
            return this.result;
        }
    }

    static final class CollectionInProgressError
    extends Error {
        private static final CollectionInProgressError SINGLETON = new CollectionInProgressError();
        private static final long serialVersionUID = -4473303241014559591L;

        static void exitIf(boolean state) {
            if (state) {
                Log failure = Log.log();
                failure.string("[CollectionInProgressError:");
                failure.newline();
                ThreadStackPrinter.printBacktrace();
                failure.string("]").newline();
                throw SINGLETON;
            }
        }

        private CollectionInProgressError() {
        }
    }

    protected static class RememberedSetConstructor
    implements ObjectVisitor {
        AlignedHeapChunk.AlignedHeader chunk;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        RememberedSetConstructor() {
        }

        public void initialize(AlignedHeapChunk.AlignedHeader aChunk) {
            this.chunk = aChunk;
        }

        @Override
        public boolean visitObject(Object o) {
            return this.visitObjectInline(o);
        }

        @Override
        @AlwaysInline(value="GC performance")
        public boolean visitObjectInline(Object o) {
            AlignedHeapChunk.setUpRememberedSetForObjectOfAlignedHeapChunk(this.chunk, o);
            return true;
        }

        public void reset() {
            this.chunk = (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
        }
    }

    public static class Timer
    implements AutoCloseable {
        final String name;
        long openNanos;
        long closeNanos;
        long collectedNanos;

        public Timer open() {
            this.openNanos = System.nanoTime();
            this.closeNanos = 0L;
            return this;
        }

        @Override
        public void close() {
            if (this.openNanos == 0L) {
                this.openNanos = HeapChunkProvider.getFirstAllocationTime();
            }
            this.closeNanos = System.nanoTime();
            this.collectedNanos += this.closeNanos - this.openNanos;
        }

        public void reset() {
            this.openNanos = 0L;
            this.closeNanos = 0L;
            this.collectedNanos = 0L;
        }

        public String getName() {
            return this.name;
        }

        public long getStart() {
            return this.openNanos;
        }

        public long getFinish() {
            assert (this.closeNanos > 0L) : "Should have closed timer";
            return this.closeNanos;
        }

        long getCollectedNanos() {
            return this.collectedNanos;
        }

        long getLastIntervalNanos() {
            assert (this.openNanos > 0L) : "Should have opened timer";
            assert (this.closeNanos > 0L) : "Should have closed timer";
            return this.closeNanos - this.openNanos;
        }

        static long getTimeSinceFirstAllocation(long nanos) {
            return nanos - HeapChunkProvider.getFirstAllocationTime();
        }

        public Timer(String name) {
            this.name = name;
        }
    }

    public static class Accounting {
        private long incrementalCollectionCount = 0L;
        private long incrementalCollectionTotalNanos = 0L;
        private long completeCollectionCount = 0L;
        private long completeCollectionTotalNanos = 0L;
        private UnsignedWord collectedTotalChunkBytes;
        private UnsignedWord pinnedChunkBytes = (UnsignedWord)WordFactory.zero();
        private UnsignedWord normalChunkBytes = (UnsignedWord)WordFactory.zero();
        private UnsignedWord promotedTotalChunkBytes = (UnsignedWord)WordFactory.zero();
        private UnsignedWord copiedTotalChunkBytes;
        private UnsignedWord youngChunkBytesBefore;
        private UnsignedWord oldChunkBytesBefore;
        private UnsignedWord oldChunkBytesAfter;
        private UnsignedWord pinnedChunkBytesBefore;
        private UnsignedWord pinnedChunkBytesAfter;
        private int history = 0;
        private UnsignedWord[] promotedUnpinnedChunkBytes;
        private UnsignedWord[] promotedPinnedChunkBytes;
        private UnsignedWord[] copiedUnpinnedChunkBytes;
        private UnsignedWord[] copiedPinnedChunkBytes;
        private UnsignedWord collectedTotalObjectBytes;
        private UnsignedWord youngObjectBytesBefore;
        private UnsignedWord oldObjectBytesBefore;
        private UnsignedWord oldObjectBytesAfter;
        private UnsignedWord pinnedObjectBytesBefore;
        private UnsignedWord pinnedObjectBytesAfter;
        private UnsignedWord pinnedObjectBytes;
        private UnsignedWord normalObjectBytes;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        Accounting() {
            this.collectedTotalChunkBytes = (UnsignedWord)WordFactory.zero();
            this.copiedTotalChunkBytes = (UnsignedWord)WordFactory.zero();
            this.youngChunkBytesBefore = (UnsignedWord)WordFactory.zero();
            this.oldChunkBytesBefore = (UnsignedWord)WordFactory.zero();
            this.oldChunkBytesAfter = (UnsignedWord)WordFactory.zero();
            this.pinnedChunkBytesBefore = (UnsignedWord)WordFactory.zero();
            this.pinnedChunkBytesAfter = (UnsignedWord)WordFactory.zero();
            this.promotedUnpinnedChunkBytes = this.historyFactory((UnsignedWord)WordFactory.zero());
            this.promotedPinnedChunkBytes = this.historyFactory((UnsignedWord)WordFactory.zero());
            this.copiedUnpinnedChunkBytes = this.historyFactory((UnsignedWord)WordFactory.zero());
            this.copiedPinnedChunkBytes = this.historyFactory((UnsignedWord)WordFactory.zero());
            this.collectedTotalObjectBytes = (UnsignedWord)WordFactory.zero();
            this.youngObjectBytesBefore = (UnsignedWord)WordFactory.zero();
            this.oldObjectBytesBefore = (UnsignedWord)WordFactory.zero();
            this.oldObjectBytesAfter = (UnsignedWord)WordFactory.zero();
            this.pinnedObjectBytesBefore = (UnsignedWord)WordFactory.zero();
            this.pinnedObjectBytesAfter = (UnsignedWord)WordFactory.zero();
            this.pinnedObjectBytes = (UnsignedWord)WordFactory.zero();
            this.normalObjectBytes = (UnsignedWord)WordFactory.zero();
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public static Accounting factory() {
            return new Accounting();
        }

        long getIncrementalCollectionCount() {
            return this.incrementalCollectionCount;
        }

        long getIncrementalCollectionTotalNanos() {
            return this.incrementalCollectionTotalNanos;
        }

        UnsignedWord getPinnedChunkBytes() {
            return this.pinnedChunkBytes;
        }

        UnsignedWord getNormalChunkBytes() {
            return this.normalChunkBytes;
        }

        UnsignedWord getPromotedTotalChunkBytes() {
            return this.promotedTotalChunkBytes;
        }

        long getCompleteCollectionCount() {
            return this.completeCollectionCount;
        }

        long getCompleteCollectionTotalNanos() {
            return this.completeCollectionTotalNanos;
        }

        UnsignedWord getCopiedTotalChunkBytes() {
            return this.copiedTotalChunkBytes;
        }

        UnsignedWord getCollectedTotalChunkBytes() {
            return this.collectedTotalChunkBytes;
        }

        UnsignedWord getCollectedTotalObjectBytes() {
            return this.collectedTotalObjectBytes;
        }

        UnsignedWord getPinnedObjectBytes() {
            return this.pinnedObjectBytes;
        }

        UnsignedWord getNormalObjectBytes() {
            return this.normalObjectBytes;
        }

        UnsignedWord getPinnedChunkBytesAfter() {
            return this.pinnedChunkBytesAfter;
        }

        UnsignedWord getPinnedObjectBytesAfter() {
            return this.pinnedObjectBytesAfter;
        }

        UnsignedWord getOldGenerationAfterChunkBytes() {
            return this.oldChunkBytesAfter.add(this.pinnedChunkBytesAfter);
        }

        UnsignedWord averagePromotedUnpinnedChunkBytes() {
            return this.averageOfHistory(this.promotedUnpinnedChunkBytes);
        }

        UnsignedWord averagePromotedPinnedChunkBytes() {
            return this.averageOfHistory(this.promotedPinnedChunkBytes);
        }

        void incrementHistory() {
            ++this.history;
        }

        int historyAsIndex() {
            return this.historyAsIndex(0);
        }

        int historyAsIndex(int offset) {
            return (this.history + offset) % Options.GCHistory.getValue();
        }

        UnsignedWord[] historyFactory(UnsignedWord initial) {
            assert (initial.equal((UnsignedWord)WordFactory.zero())) : "Can not initialize history to any value except WordFactory.zero().";
            UnsignedWord[] result = new UnsignedWord[Options.GCHistory.getValue().intValue()];
            return result;
        }

        UnsignedWord getHistoryOf(UnsignedWord[] array) {
            return this.getHistoryOf(array, 0);
        }

        UnsignedWord getHistoryOf(UnsignedWord[] array, int offset) {
            return array[this.historyAsIndex(offset)];
        }

        void setHistoryOf(UnsignedWord[] array, UnsignedWord value) {
            this.setHistoryOf(array, 0, value);
        }

        void setHistoryOf(UnsignedWord[] array, int offset, UnsignedWord value) {
            array[this.historyAsIndex((int)offset)] = value;
        }

        UnsignedWord averageOfHistory(UnsignedWord[] array) {
            int count = 0;
            UnsignedWord sum = (UnsignedWord)WordFactory.zero();
            UnsignedWord result = (UnsignedWord)WordFactory.zero();
            for (int offset = 0; offset < array.length; ++offset) {
                UnsignedWord element = this.getHistoryOf(array, offset);
                if (!element.aboveThan((UnsignedWord)WordFactory.zero())) continue;
                sum = sum.add(element);
                ++count;
            }
            if (count > 0) {
                result = sum.unsignedDivide(count);
            }
            return result;
        }

        void beforeCollection() {
            Log trace = Log.noopLog().string("[GCImpl.Accounting.beforeCollection:").newline();
            this.incrementHistory();
            HeapImpl heap = HeapImpl.getHeapImpl();
            Space youngSpace = heap.getYoungGeneration().getSpace();
            this.youngChunkBytesBefore = youngSpace.getChunkBytes();
            Space oldSpace = heap.getOldGeneration().getFromSpace();
            this.oldChunkBytesBefore = oldSpace.getChunkBytes();
            Space pinnedSpace = heap.getOldGeneration().getPinnedFromSpace();
            this.normalChunkBytes = this.normalChunkBytes.add(this.youngChunkBytesBefore);
            this.pinnedChunkBytesBefore = this.pinnedChunkBytesAfter;
            UnsignedWord allocatedPinnedChunkBytes = pinnedSpace.getChunkBytes().subtract(this.pinnedChunkBytesBefore);
            this.setHistoryOf(this.promotedPinnedChunkBytes, allocatedPinnedChunkBytes);
            this.pinnedChunkBytes = this.pinnedChunkBytes.add(allocatedPinnedChunkBytes);
            if (SubstrateOptions.PrintGCSummary.getValue().booleanValue()) {
                this.youngObjectBytesBefore = youngSpace.getObjectBytes();
                this.oldObjectBytesBefore = oldSpace.getObjectBytes();
                this.pinnedObjectBytesBefore = this.pinnedObjectBytesAfter;
                UnsignedWord allocatedPinnedObjectBytes = pinnedSpace.getObjectBytes().subtract(this.pinnedObjectBytesBefore);
                this.pinnedObjectBytes = this.pinnedObjectBytes.add(allocatedPinnedObjectBytes);
                this.normalObjectBytes = this.normalObjectBytes.add(this.youngObjectBytesBefore);
            }
            trace.string("  youngChunkBytesBefore: ").unsigned((WordBase)this.youngChunkBytesBefore).string("  oldChunkBytesBefore: ").unsigned((WordBase)this.oldChunkBytesBefore).string("  pinnedChunkBytesBefore: ").unsigned((WordBase)this.pinnedChunkBytesBefore);
            trace.string("]").newline();
        }

        void afterCollection(boolean completeCollection, Timer collectionTimer) {
            if (completeCollection) {
                this.afterCompleteCollection(collectionTimer);
            } else {
                this.afterIncrementalCollection(collectionTimer);
            }
        }

        private void afterIncrementalCollection(Timer collectionTimer) {
            Log trace = Log.noopLog().string("[GCImpl.Accounting.afterIncrementalCollection:");
            ++this.incrementalCollectionCount;
            this.afterCollectionCommon();
            this.setHistoryOf(this.promotedUnpinnedChunkBytes, this.oldChunkBytesAfter.subtract(this.oldChunkBytesBefore));
            this.promotedTotalChunkBytes = this.promotedTotalChunkBytes.add(this.getHistoryOf(this.promotedUnpinnedChunkBytes)).add(this.getHistoryOf(this.promotedPinnedChunkBytes));
            this.incrementalCollectionTotalNanos += collectionTimer.getCollectedNanos();
            trace.string("  incrementalCollectionCount: ").signed(this.incrementalCollectionCount).string("  oldChunkBytesAfter: ").unsigned((WordBase)this.oldChunkBytesAfter).string("  oldChunkBytesBefore: ").unsigned((WordBase)this.oldChunkBytesBefore).string("  promotedUnpinnedChunkBytes: ").unsigned((WordBase)this.getHistoryOf(this.promotedUnpinnedChunkBytes)).string("  promotedPinnedChunkBytes: ").unsigned((WordBase)this.getHistoryOf(this.promotedPinnedChunkBytes));
            trace.string("]").newline();
        }

        private void afterCompleteCollection(Timer collectionTimer) {
            Log trace = Log.noopLog().string("[GCImpl.Accounting.afterCompleteCollection:");
            ++this.completeCollectionCount;
            this.afterCollectionCommon();
            this.setHistoryOf(this.copiedUnpinnedChunkBytes, this.oldChunkBytesAfter);
            this.setHistoryOf(this.copiedPinnedChunkBytes, this.pinnedChunkBytesAfter);
            this.copiedTotalChunkBytes = this.copiedTotalChunkBytes.add(this.oldChunkBytesAfter).add(this.pinnedChunkBytesAfter);
            this.completeCollectionTotalNanos += collectionTimer.getCollectedNanos();
            trace.string("  completeCollectionCount: ").signed(this.completeCollectionCount).string("  oldChunkBytesAfter: ").unsigned((WordBase)this.oldChunkBytesAfter).string("  pinnedChunkBytesAfter: ").unsigned((WordBase)this.pinnedChunkBytesAfter);
            trace.string("]").newline();
        }

        void afterCollectionCommon() {
            HeapImpl heap = HeapImpl.getHeapImpl();
            Space oldSpace = heap.getOldGeneration().getFromSpace();
            this.oldChunkBytesAfter = oldSpace.getChunkBytes();
            Space pinnedSpace = heap.getOldGeneration().getPinnedFromSpace();
            this.pinnedChunkBytesAfter = pinnedSpace.getChunkBytes();
            UnsignedWord beforeChunkBytes = this.youngChunkBytesBefore.add(this.oldChunkBytesBefore).add(this.pinnedChunkBytesBefore);
            UnsignedWord afterChunkBytes = this.oldChunkBytesAfter.add(this.pinnedChunkBytesAfter);
            UnsignedWord collectedChunkBytes = beforeChunkBytes.subtract(afterChunkBytes);
            this.collectedTotalChunkBytes = this.collectedTotalChunkBytes.add(collectedChunkBytes);
            if (SubstrateOptions.PrintGCSummary.getValue().booleanValue()) {
                this.pinnedObjectBytesAfter = pinnedSpace.getObjectBytes();
                this.oldObjectBytesAfter = oldSpace.getObjectBytes();
                UnsignedWord beforeObjectBytes = this.youngObjectBytesBefore.add(this.oldObjectBytesBefore).add(this.pinnedObjectBytesBefore);
                UnsignedWord afterObjectBytes = this.oldObjectBytesAfter.add(this.pinnedObjectBytesAfter);
                UnsignedWord collectedObjectBytes = beforeObjectBytes.subtract(afterObjectBytes);
                this.collectedTotalObjectBytes = this.collectedTotalObjectBytes.add(collectedObjectBytes);
            }
        }
    }

    static final class Options {
        @Option(help={"How much history to maintain about garbage collections."})
        public static final HostedOptionKey<Integer> GCHistory = new HostedOptionKey<Integer>(1);

        Options() {
        }
    }
}

