/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.heap.NativeImageInfo;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.InteriorObjRefWalker;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import java.util.ArrayList;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class PathExhibitor {
    protected final ArrayList<PathElement> path = new ArrayList();
    protected static final FrameSlotVisitor frameSlotVisitor = new FrameSlotVisitor();
    protected static final FrameVisitor stackFrameVisitor = new FrameVisitor();
    protected static final BootImageHeapObjRefVisitor bootImageHeapObjRefVisitor = new BootImageHeapObjRefVisitor();
    protected static final HeapObjRefVisitor heapObjRefVisitor = new HeapObjRefVisitor();
    protected static final HeapObjectVisitor heapObjectVisitor = new HeapObjectVisitor();

    public static PathExhibitor factory() {
        return new PathExhibitor();
    }

    public boolean findPathToRoot(Object leaf) {
        block3: {
            PathElement currentElement = LeafElement.factory(leaf);
            Object currentObject = leaf;
            do {
                this.path.add(currentElement);
                currentElement = this.findPathToObject(currentObject);
                if (currentElement == null) break block3;
                currentObject = KnownIntrinsics.convertUnknownValue(currentElement.getObject(), Object.class);
                if (currentObject == null) {
                    this.path.add(currentElement);
                } else {
                    if (!(currentObject instanceof PathElement)) continue;
                    InterferenceElement interference = InterferenceElement.factory();
                    this.path.add(interference);
                }
                break block3;
            } while (!this.checkForCycles(currentObject));
            CyclicElement cyclic = CyclicElement.factory(currentObject);
            this.path.add(cyclic);
        }
        return true;
    }

    public void toLog(Log log) {
        for (PathElement element : this.path) {
            log.newline();
            element.toLog(log);
        }
    }

    protected PathElement findPathToObject(Object obj) {
        PathElement result = null;
        if (obj == null) {
            return result;
        }
        result = this.findPathInHeap(obj);
        if (result != null) {
            return result;
        }
        result = this.findPathInBootImageHeap(obj);
        if (result != null) {
            return result;
        }
        result = this.findPathInStack(obj);
        if (result != null) {
            return result;
        }
        return null;
    }

    protected StackElement findPathInStack(Object obj) {
        stackFrameVisitor.initialize(obj);
        Pointer sp = KnownIntrinsics.readCallerStackPointer();
        CodePointer ip = KnownIntrinsics.readReturnAddress();
        JavaStackWalker.walkCurrentThread(sp, ip, stackFrameVisitor);
        StackElement result = frameSlotVisitor.getElement();
        return result;
    }

    protected PathElement findPathInBootImageHeap(Object targetObject) {
        PathElement result = null;
        if (result == null) {
            result = this.findPathInBootImageHeap(targetObject, NativeImageInfo.firstReadOnlyPrimitiveObject, NativeImageInfo.lastReadOnlyPrimitiveObject);
        }
        if (result == null) {
            result = this.findPathInBootImageHeap(targetObject, NativeImageInfo.firstReadOnlyReferenceObject, NativeImageInfo.lastReadOnlyReferenceObject);
        }
        if (result == null) {
            result = this.findPathInBootImageHeap(targetObject, NativeImageInfo.firstWritablePrimitiveObject, NativeImageInfo.lastWritablePrimitiveObject);
        }
        if (result == null) {
            result = this.findPathInBootImageHeap(targetObject, NativeImageInfo.firstWritableReferenceObject, NativeImageInfo.lastWritableReferenceObject);
        }
        return result;
    }

    protected PathElement findPathInBootImageHeap(Object targetObject, Object firstObject, Object lastObject) {
        if (firstObject == null || lastObject == null) {
            return null;
        }
        Word targetPointer = Word.objectToUntrackedPointer((Object)targetObject);
        Word firstPointer = Word.objectToUntrackedPointer((Object)firstObject);
        Word lastPointer = Word.objectToUntrackedPointer((Object)lastObject);
        Word current = firstPointer;
        while (current.belowOrEqual((UnsignedWord)lastPointer)) {
            Object bihObject = current.toObject();
            if (!PathExhibitor.checkForInterference(bihObject)) {
                bootImageHeapObjRefVisitor.initialize((Pointer)current, (Pointer)targetPointer);
                if (!InteriorObjRefWalker.walkObject(bihObject, bootImageHeapObjRefVisitor)) break;
            }
            current = LayoutEncoding.getObjectEnd(bihObject);
        }
        return bootImageHeapObjRefVisitor.getElement();
    }

    protected HeapElement findPathInHeap(Object obj) {
        heapObjectVisitor.initialize(obj);
        HeapImpl heap = HeapImpl.getHeapImpl();
        heap.walkObjects(heapObjectVisitor);
        HeapElement result = heapObjRefVisitor.getElement();
        return result;
    }

    protected boolean checkForCycles(Object currentObject) {
        boolean result = false;
        for (PathElement seen : this.path) {
            Object seenObject = seen.getObject();
            if (currentObject != seenObject) continue;
            result = true;
            break;
        }
        return result;
    }

    protected static boolean checkForInterference(Object currentObject) {
        boolean result = false;
        if (currentObject instanceof PathElement) {
            result = true;
        }
        return result;
    }

    protected PathExhibitor() {
    }

    public static final class TestingBackDoor {
        private TestingBackDoor() {
        }

        public static PathElement findPathToObject(PathExhibitor exhibitor, Object obj) {
            return exhibitor.findPathToObject(obj);
        }
    }

    public static class InterferenceElement
    extends PathElement {
        public static InterferenceElement factory() {
            return new InterferenceElement();
        }

        @Override
        public Object getObject() {
            return null;
        }

        @Override
        public Log toLog(Log log) {
            log.string("[interference");
            log.string("]");
            return log;
        }

        protected InterferenceElement() {
        }
    }

    public static class CyclicElement
    extends PathElement {
        protected final Object previous;

        public static CyclicElement factory(Object previous) {
            return new CyclicElement(previous);
        }

        @Override
        public Object getObject() {
            return null;
        }

        @Override
        public Log toLog(Log log) {
            log.string("[cyclic:");
            log.string("  previous: ").object(this.previous);
            log.string("]");
            return log;
        }

        protected CyclicElement(Object previous) {
            this.previous = previous;
        }
    }

    public static class BootImageHeapElement
    extends PathElement {
        protected final Object base;
        protected final UnsignedWord offset;
        protected final Pointer field;

        public static BootImageHeapElement factory(Object base, UnsignedWord offset, Pointer field) {
            return new BootImageHeapElement(base, offset, field);
        }

        @Override
        public Object getObject() {
            return null;
        }

        @Override
        public Log toLog(Log log) {
            log.string("[native image heap:");
            log.string("  object: ").object(this.base);
            log.string("  offset: ").unsigned((WordBase)this.offset);
            log.string("  field: ").hex((WordBase)this.field);
            log.string("]");
            return log;
        }

        protected BootImageHeapElement(Object base, UnsignedWord offset, Pointer field) {
            this.base = base;
            this.offset = offset;
            this.field = field;
        }
    }

    public static class StackElement
    extends PathElement {
        protected final Pointer stackSlot;
        protected final CodePointer ip;
        protected final CodePointer deoptSourcePC;
        protected final Pointer slotValue;

        public static StackElement factory(Pointer frameSlot, CodePointer ip, DeoptimizedFrame deoptFrame) {
            return new StackElement(frameSlot, ip, deoptFrame);
        }

        @Override
        public Object getObject() {
            return null;
        }

        @Override
        public Log toLog(Log log) {
            log.string("[stack:");
            log.string("  slot: ").hex((WordBase)this.stackSlot);
            log.string("  deoptSourcePC: ").hex((WordBase)this.deoptSourcePC);
            log.string("  ip: ").hex((WordBase)this.ip);
            log.string("  value: ").hex((WordBase)this.slotValue);
            log.string("]");
            return log;
        }

        protected StackElement(Pointer stackSlot, CodePointer ip, DeoptimizedFrame deoptFrame) {
            this.stackSlot = stackSlot;
            this.deoptSourcePC = deoptFrame != null ? deoptFrame.getSourcePC() : (CodePointer)WordFactory.nullPointer();
            this.ip = ip;
            this.slotValue = (Pointer)stackSlot.readWord(0);
        }
    }

    public static class HeapElement
    extends PathElement {
        protected final Object base;
        protected final UnsignedWord offset;

        public static HeapElement factory(Object base, UnsignedWord offset) {
            return new HeapElement(base, offset);
        }

        @Override
        public Object getObject() {
            return this.base;
        }

        @Override
        public Log toLog(Log log) {
            log.string("[heap:");
            log.string("  base: ").object(this.base);
            log.string("  offset: ").unsigned((WordBase)this.offset);
            Word objPointer = Word.objectToUntrackedPointer((Object)this.base);
            Pointer fieldObjRef = objPointer.add(this.offset);
            Pointer fieldPointer = (Pointer)fieldObjRef.readWord(0);
            log.string("  field: ").hex((WordBase)fieldPointer);
            log.string("]");
            return log;
        }

        protected HeapElement(Object base, UnsignedWord offset) {
            this.base = base;
            this.offset = offset;
        }
    }

    public static class LeafElement
    extends PathElement {
        protected final Object leaf;

        public static LeafElement factory(Object leaf) {
            return new LeafElement(leaf);
        }

        @Override
        public Object getObject() {
            return this.leaf;
        }

        @Override
        public Log toLog(Log log) {
            log.string("[leaf:");
            log.string("  ").object(this.leaf);
            log.string("]");
            return log;
        }

        protected LeafElement(Object leaf) {
            this.leaf = leaf;
        }
    }

    private static class HeapObjRefVisitor
    implements ObjectReferenceVisitor {
        protected Pointer containerPointer;
        protected Pointer targetPointer;
        protected HeapElement element;

        protected HeapObjRefVisitor() {
        }

        @Override
        public boolean prologue() {
            this.containerPointer = (Pointer)WordFactory.nullPointer();
            this.targetPointer = (Pointer)WordFactory.nullPointer();
            return true;
        }

        public void initialize(Pointer container, Pointer target) {
            this.containerPointer = container;
            this.targetPointer = target;
        }

        public HeapElement getElement() {
            return this.element;
        }

        @Override
        public boolean visitObjectReference(Pointer objRef, boolean compressed) {
            if (objRef.isNull()) {
                return true;
            }
            Word referentPointer = ReferenceAccess.singleton().readObjectAsUntrackedPointer(objRef, compressed);
            if (referentPointer.equal((UnsignedWord)this.targetPointer)) {
                Pointer offset = objRef.subtract((UnsignedWord)this.containerPointer);
                Object containerObject = this.containerPointer.toObject();
                this.element = HeapElement.factory(containerObject, (UnsignedWord)offset);
                return false;
            }
            return true;
        }
    }

    private static class HeapObjectVisitor
    implements ObjectVisitor {
        protected Pointer targetPointer;

        protected HeapObjectVisitor() {
        }

        @Override
        public boolean prologue() {
            this.targetPointer = (Pointer)WordFactory.nullPointer();
            return true;
        }

        public void initialize(Object targetObject) {
            this.targetPointer = Word.objectToUntrackedPointer((Object)targetObject);
        }

        @Override
        public boolean visitObject(Object containerObject) {
            if (PathExhibitor.checkForInterference(containerObject)) {
                return true;
            }
            Word containerPointer = Word.objectToUntrackedPointer((Object)containerObject);
            heapObjRefVisitor.initialize((Pointer)containerPointer, this.targetPointer);
            return InteriorObjRefWalker.walkObject(containerObject, heapObjRefVisitor);
        }
    }

    private static class BootImageHeapObjRefVisitor
    implements ObjectReferenceVisitor {
        protected Pointer targetPointer;
        protected Pointer containerPointer;
        protected BootImageHeapElement element;

        protected BootImageHeapObjRefVisitor() {
        }

        @Override
        public boolean prologue() {
            this.targetPointer = (Pointer)WordFactory.nullPointer();
            this.element = null;
            return true;
        }

        public void initialize(Pointer container, Pointer target) {
            this.containerPointer = container;
            this.targetPointer = target;
        }

        @Override
        public boolean visitObjectReference(Pointer objRef, boolean compressed) {
            if (objRef.isNull()) {
                return true;
            }
            Word referentPointer = ReferenceAccess.singleton().readObjectAsUntrackedPointer(objRef, compressed);
            if (referentPointer.equal((UnsignedWord)this.targetPointer)) {
                Object containerObject = this.containerPointer.toObject();
                Pointer offset = objRef.subtract((UnsignedWord)this.containerPointer);
                this.element = BootImageHeapElement.factory(containerObject, (UnsignedWord)offset, (Pointer)referentPointer);
                return false;
            }
            return true;
        }

        public BootImageHeapElement getElement() {
            return this.element;
        }
    }

    private static class FrameSlotVisitor
    implements ObjectReferenceVisitor {
        protected StackElement element;
        protected CodePointer ip;
        protected DeoptimizedFrame deoptFrame;
        protected Pointer targetPointer;

        protected FrameSlotVisitor() {
        }

        public void initialize(CodePointer ipArg, DeoptimizedFrame deoptFrameArg, Pointer targetArg) {
            Log trace = Log.noopLog();
            trace.string("[PathExhibitor.FrameSlotVisitor.initialize:").newline();
            this.element = null;
            this.ip = ipArg;
            this.deoptFrame = deoptFrameArg;
            this.targetPointer = targetArg;
            trace.string("  element: ").object(this.element);
            trace.string("  ip: ").hex((WordBase)this.ip);
            trace.string("  deoptFrame: ").object(this.deoptFrame);
            trace.string("  targetPointer: ").hex((WordBase)this.targetPointer);
            trace.string("]").newline();
        }

        @Override
        public boolean visitObjectReference(Pointer stackSlot, boolean compressed) {
            boolean result;
            Log trace = Log.noopLog();
            trace.string("[PathExhibitor.FrameSlotVisitor.visitObjectReference:").newline();
            trace.string("  stackSlot: ").hex((WordBase)stackSlot);
            if (stackSlot.isNull()) {
                result = true;
            } else {
                Word referentPointer = ReferenceAccess.singleton().readObjectAsUntrackedPointer(stackSlot, compressed);
                trace.string("  referentPointer: ").hex((WordBase)referentPointer);
                if (referentPointer.equal((UnsignedWord)this.targetPointer)) {
                    this.element = StackElement.factory(stackSlot, this.ip, this.deoptFrame);
                    result = false;
                } else {
                    result = true;
                }
            }
            trace.string("  returns: ").bool(result);
            trace.string("]").newline();
            return result;
        }

        public StackElement getElement() {
            Log trace = Log.noopLog();
            trace.string("[PathExhibitor.FrameSlotVisitor.getElement:").newline();
            trace.string("  returns element: ").object(this.element);
            trace.string("]").newline();
            return this.element;
        }
    }

    public static class FrameVisitor
    implements StackFrameVisitor {
        protected Pointer targetPointer;

        protected FrameVisitor() {
        }

        public void initialize(Object targetObject) {
            Log trace = Log.noopLog();
            trace.string("[PathExhibitor.FrameVisitor.initialize:").newline();
            trace.string("  targetObject: ").object(targetObject);
            this.targetPointer = Word.objectToUntrackedPointer((Object)targetObject);
            trace.string("]").newline();
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while verifying the heap.")
        public boolean visitFrame(Pointer sp, CodePointer ip, DeoptimizedFrame deoptimizedFrame) {
            Log trace = Log.noopLog();
            trace.string("[PathExhibitor.FrameVisitor.visitFrame:").newline();
            trace.string("  sp: ").hex((WordBase)sp);
            trace.string("  ip: ").hex((WordBase)ip);
            trace.string("  deoptFrame: ").object(deoptimizedFrame);
            trace.newline();
            frameSlotVisitor.initialize(ip, deoptimizedFrame, this.targetPointer);
            boolean result = CodeInfoTable.visitObjectReferences(sp, ip, deoptimizedFrame, frameSlotVisitor);
            trace.string("  returns: ").bool(result);
            trace.string("]").newline();
            return result;
        }

        @Override
        public boolean epilogue() {
            this.targetPointer = (Pointer)WordFactory.nullPointer();
            return true;
        }
    }

    public static abstract class PathElement {
        public abstract Log toLog(Log var1);

        public abstract Object getObject();
    }
}

