/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.code.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64BlockEndOp;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="FAR_RETURN")
public final class AMD64FarReturnOp
extends AMD64BlockEndOp {
    public static final LIRInstructionClass<AMD64FarReturnOp> TYPE = LIRInstructionClass.create(AMD64FarReturnOp.class);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    AllocatableValue result;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue sp;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue ip;

    public AMD64FarReturnOp(AllocatableValue result, AllocatableValue sp, AllocatableValue ip) {
        super(TYPE);
        this.result = result;
        this.sp = sp;
        this.ip = ip;
    }

    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        masm.movq(AMD64.rsp, ValueUtil.asRegister((Value)this.sp));
        masm.jmp(ValueUtil.asRegister((Value)this.ip));
    }
}

