/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public abstract class ObjectHeader {
    protected static final UnsignedWord BITS_MASK = WordFactory.unsigned((int)7);
    public static final UnsignedWord BITS_CLEAR = BITS_MASK.not();

    public static UnsignedWord readHeaderFromPointer(Pointer objectPointer) {
        if (ObjectHeader.getReferenceSize() == 4) {
            return WordFactory.unsigned((int)objectPointer.readInt(ObjectHeader.getHubOffset()));
        }
        return (UnsignedWord)objectPointer.readWord(ObjectHeader.getHubOffset());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void initializeHeaderOfNewObject(Pointer objectPointer, WordBase header) {
        if (ObjectHeader.getReferenceSize() == 4) {
            objectPointer.writeInt(ObjectHeader.getHubOffset(), (int)header.rawValue(), LocationIdentity.INIT_LOCATION);
        } else {
            objectPointer.writeWord(ObjectHeader.getHubOffset(), header, LocationIdentity.INIT_LOCATION);
        }
    }

    public static UnsignedWord readHeaderFromObject(Object o) {
        if (ObjectHeader.getReferenceSize() == 4) {
            return WordFactory.unsigned((int)ObjectAccess.readInt((Object)o, (int)ObjectHeader.getHubOffset()));
        }
        return (UnsignedWord)ObjectAccess.readWord((Object)o, (int)ObjectHeader.getHubOffset());
    }

    public static void writeHeaderToObject(Object o, WordBase header) {
        if (ObjectHeader.getReferenceSize() == 4) {
            ObjectAccess.writeInt((Object)o, (int)ObjectHeader.getHubOffset(), (int)((int)header.rawValue()));
        } else {
            ObjectAccess.writeWord((Object)o, (int)ObjectHeader.getHubOffset(), (WordBase)header);
        }
    }

    public static DynamicHub readDynamicHubFromObject(Object o) {
        return KnownIntrinsics.readHub(o);
    }

    public static DynamicHub dynamicHubFromObjectHeader(UnsignedWord header) {
        Object objectValue;
        UnsignedWord pointerBits = ObjectHeader.clearBits(header);
        if (ReferenceAccess.singleton().haveCompressedReferences()) {
            UnsignedWord compressedBits = pointerBits.unsignedShiftRight(ReferenceAccess.singleton().getCompressEncoding().getShift());
            objectValue = ReferenceAccess.singleton().uncompressReference(compressedBits);
        } else {
            objectValue = ((Pointer)pointerBits).toObject();
        }
        return KnownIntrinsics.unsafeCast(objectValue, DynamicHub.class);
    }

    public static UnsignedWord clearBits(UnsignedWord header) {
        return header.and(BITS_CLEAR);
    }

    public abstract boolean isForwardedHeader(UnsignedWord var1);

    public abstract Pointer getForwardingPointer(Pointer var1);

    public abstract Object getForwardedObject(Pointer var1);

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public abstract long setBootImageOnLong(long var1);

    protected abstract void setUnaligned(Object var1);

    protected abstract boolean isHeapAllocated(Object var1);

    public abstract boolean isNonHeapAllocatedHeader(UnsignedWord var1);

    protected abstract boolean isNonHeapAllocated(Object var1);

    public abstract boolean isAlignedObject(Object var1);

    public abstract boolean isUnalignedObject(Object var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static int getReferenceSize() {
        return ConfigurationValues.getObjectLayout().getReferenceSize();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static int getHubOffset() {
        return ConfigurationValues.getObjectLayout().getHubOffset();
    }

    public String toStringFromObject(Object o) {
        UnsignedWord header = ObjectHeader.readHeaderFromObject(o);
        return this.toStringFromHeader(header);
    }

    public abstract String toStringFromHeader(UnsignedWord var1);

    protected ObjectHeader() {
    }
}

