/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import java.util.SplittableRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.graalvm.compiler.serviceprovider.GraalServices;

@TargetClass(value=SplittableRandom.class)
final class Target_java_util_SplittableRandom {
    @Alias
    @TargetElement(name="GOLDEN_GAMMA")
    private static long GOLDENGAMMA;
    @Alias
    private long seed;
    @Alias
    private long gamma;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private static volatile AtomicLong defaultGen;

    @Substitute
    protected Target_java_util_SplittableRandom() {
        if (defaultGen == null) {
            defaultGen = GraalServices.Java8OrEarlier ? new AtomicLong(Target_java_util_SplittableRandom.initialSeed()) : new AtomicLong(Target_java_util_SplittableRandom.mix64(System.currentTimeMillis()) ^ Target_java_util_SplittableRandom.mix64(System.nanoTime()));
        }
        long s = defaultGen.getAndAdd(2L * GOLDENGAMMA);
        this.seed = Target_java_util_SplittableRandom.mix64(s);
        this.gamma = Target_java_util_SplittableRandom.mixGamma(s + GOLDENGAMMA);
    }

    @Alias
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static native long initialSeed();

    @Alias
    private static native long mix64(long var0);

    @Alias
    private static native long mixGamma(long var0);
}

