/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.locks;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class VMMutex
implements AutoCloseable {
    protected boolean locked;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public VMMutex() {
    }

    public VMMutex lock() {
        throw VMError.shouldNotReachHere("Lock cannot be used during native image generation");
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    public VMMutex lockNoTransition() {
        throw VMError.shouldNotReachHere("Lock cannot be used during native image generation");
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    public void unlock() {
        throw VMError.shouldNotReachHere("Lock cannot be used during native image generation");
    }

    public void unlockWithoutChecks() {
        throw VMError.shouldNotReachHere("Lock cannot be used during native image generation");
    }

    @Override
    public final void close() {
        this.unlock();
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    public final void assertIsLocked(String message) {
        assert (this.locked) : message;
    }

    public final void assertIsNotLocked(String message) {
        assert (!this.locked) : message;
    }

    public final void warnIfNotLocked(String message) {
        if (!this.locked) {
            Log.log().string("[VMMutex.warnIfNotlocked: ").string(message).string("]").newline();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    public final void guaranteeIsLocked(String message) {
        VMError.guarantee(this.locked, message);
    }

    public static class TestingBackdoor {
        public static boolean isLocked(VMMutex mutex) {
            return mutex.locked;
        }
    }
}

