/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import java.util.Arrays;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class XOptions {
    private final XFlag xmn = new XFlag("-X", "mn", "The maximum size of the young generation, in bytes.");
    private final XFlag xmx = new XFlag("-X", "mx", "The maximum size of the heap, in bytes.");
    private final XFlag xms = new XFlag("-X", "ms", "The minimum size of the heap, in bytes.");
    private final XFlag xss = new XFlag("-X", "ss", "The size of each thread stack, in bytes.");
    private final XFlag[] xFlagArray = new XFlag[]{this.xmn, this.xms, this.xmx, this.xss};

    public static XOptions singleton() {
        return (XOptions)ImageSingletons.lookup(XOptions.class);
    }

    public static XFlag getXmn() {
        return XOptions.singleton().xmn;
    }

    public static XFlag getXms() {
        return XOptions.singleton().xms;
    }

    public static XFlag getXmx() {
        return XOptions.singleton().xmx;
    }

    public static XFlag getXss() {
        return XOptions.singleton().xss;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    XOptions() {
    }

    public XFlag[] getXFlags() {
        return this.xFlagArray;
    }

    public String[] parse(String[] args) {
        int newIdx = 0;
        for (int oldIdx = 0; oldIdx < args.length; ++oldIdx) {
            String arg = args[oldIdx];
            boolean parsed = false;
            for (XFlag xFlag : this.xFlagArray) {
                try {
                    parsed |= this.parseWithNameAndPrefix(xFlag, arg);
                }
                catch (NumberFormatException nfe) {
                    Log.logStream().println("error: Wrong value for option '" + arg + "' is not a valid number.");
                    System.exit(1);
                }
            }
            if (parsed) continue;
            assert (newIdx <= oldIdx);
            args[newIdx] = arg;
            ++newIdx;
        }
        return newIdx == args.length ? args : Arrays.copyOf(args, newIdx);
    }

    private boolean parseWithNameAndPrefix(XFlag xFlag, String arg) throws NumberFormatException {
        if (arg.startsWith(xFlag.getPrefixAndName())) {
            String valueString = arg.substring(xFlag.getPrefixAndName().length());
            this.parseFromValueString(xFlag, valueString);
            return true;
        }
        return false;
    }

    public void parseFromValueString(XFlag xFlag, String value) throws NumberFormatException {
        long valueLong = SubstrateOptionsParser.parseLong(value);
        xFlag.setValue(valueLong);
    }

    public static class XFlag {
        private final String prefix;
        private final String name;
        private final String description;
        private long value;
        private long epoch;
        private final String prefixAndName;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        XFlag(String prefix, String name, String description) {
            this.prefix = prefix;
            this.name = name;
            this.prefixAndName = prefix.concat(name);
            this.description = description;
            this.value = 0L;
            this.epoch = 0L;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getName() {
            return this.name;
        }

        public String getPrefixAndName() {
            return this.prefixAndName;
        }

        public String getDescription() {
            return this.description;
        }

        public long getValue() {
            return this.value;
        }

        public long getEpoch() {
            return this.epoch;
        }

        void setValue(long valueArg) {
            this.value = valueArg;
            ++this.epoch;
        }
    }
}

