/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.os.IsDefined;
import com.oracle.svm.core.posix.JavaNetNetUtil;
import com.oracle.svm.core.posix.Target_java_net_InetAddress;
import com.oracle.svm.core.posix.Util_java_net_Inet4Address;
import com.oracle.svm.core.posix.Util_java_net_Inet6Address;
import com.oracle.svm.core.posix.Util_java_net_Inet6AddressImpl;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.Netdb;
import com.oracle.svm.core.posix.headers.NetinetIn;
import com.oracle.svm.core.posix.headers.Socket;
import com.oracle.svm.core.posix.headers.Unistd;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

@TargetClass(className="java.net.Inet6AddressImpl")
@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
final class Target_java_net_Inet6AddressImpl {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    InetAddress anyLocalAddress;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    InetAddress loopbackAddress;

    Target_java_net_Inet6AddressImpl() {
    }

    @Substitute
    public String getHostByAddr(byte[] addrArray) throws UnknownHostException {
        Socket.sockaddr sa;
        String ret = null;
        CCharPointer host = (CCharPointer)StackValue.get((int)(Netdb.NI_MAXHOST() + 1));
        int error = 0;
        int len = 0;
        CCharPointer caddr = (CCharPointer)StackValue.get((int)16);
        NetinetIn.sockaddr_in him4 = (NetinetIn.sockaddr_in)StackValue.get(NetinetIn.sockaddr_in.class);
        NetinetIn.sockaddr_in6 him6 = (NetinetIn.sockaddr_in6)StackValue.get(NetinetIn.sockaddr_in6.class);
        if (addrArray.length == 4) {
            int addr = 0;
            addr |= addrArray[0] << 24 & 0xFF000000;
            addr |= addrArray[1] << 16 & 0xFF0000;
            addr |= addrArray[2] << 8 & 0xFF00;
            LibC.memset(him4, WordFactory.signed((int)0), SizeOf.unsigned(NetinetIn.sockaddr_in.class));
            him4.sin_addr().set_s_addr(NetinetIn.htonl(addr |= addrArray[3] << 0 & 0xFF));
            him4.set_sin_family(Socket.AF_INET());
            sa = (Socket.sockaddr)((Object)him4);
            len = SizeOf.get(NetinetIn.sockaddr_in.class);
        } else {
            try (PinnedObject pinnedAddrArray = PinnedObject.create((Object)addrArray);){
                CCharPointer addrArray0 = (CCharPointer)pinnedAddrArray.addressOfArrayElement(0);
                LibC.memcpy(caddr, (PointerBase)addrArray0, WordFactory.unsigned((int)16));
            }
            LibC.memset(him6, WordFactory.signed((int)0), SizeOf.unsigned(NetinetIn.sockaddr_in6.class));
            LibC.memcpy(him6.sin6_addr(), (PointerBase)caddr, SizeOf.unsigned(NetinetIn.in6_addr.class));
            him6.set_sin6_family(Socket.AF_INET6());
            sa = (Socket.sockaddr)((Object)him6);
            len = SizeOf.get(NetinetIn.sockaddr_in6.class);
        }
        error = Netdb.getnameinfo(sa, len, host, Netdb.NI_MAXHOST(), (CCharPointer)WordFactory.nullPointer(), 0, Netdb.NI_NAMEREQD());
        if (error == 0) {
            ret = CTypeConversion.toJavaString((CCharPointer)host);
        }
        if (ret == null) {
            throw new UnknownHostException();
        }
        return ret;
    }

    @Substitute
    public String getLocalHostName() throws UnknownHostException {
        CCharPointer hostname = (CCharPointer)StackValue.get((int)(Netdb.NI_MAXHOST() + 1), CCharPointer.class);
        hostname.write(0, (byte)0);
        if (Unistd.gethostname(hostname, WordFactory.unsigned((int)(Netdb.NI_MAXHOST() + 1))) != 0) {
            try (CTypeConversion.CCharPointerHolder pin = CTypeConversion.toCString((CharSequence)"localhost");){
                LibC.strcpy(hostname, pin.get());
            }
        } else {
            hostname.write(Netdb.NI_MAXHOST(), (byte)0);
            if (IsDefined.__linux__() || IsDefined._ALLBSD_SOURCE()) {
                // empty if block
            }
        }
        return CTypeConversion.toJavaString((CCharPointer)hostname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Substitute
    public InetAddress[] lookupAllHostAddr(String host) throws UnknownHostException, SocketException, InterruptedException {
        InetAddress[] ret = null;
        int retLen = 0;
        int error = 0;
        Netdb.addrinfo hints = (Netdb.addrinfo)StackValue.get(Netdb.addrinfo.class);
        Netdb.addrinfo res = (Netdb.addrinfo)WordFactory.nullPointer();
        Netdb.addrinfoPointer resPtr = (Netdb.addrinfoPointer)StackValue.get(Netdb.addrinfoPointer.class);
        Netdb.addrinfo resNew = (Netdb.addrinfo)WordFactory.nullPointer();
        if (host == null) {
            throw new NullPointerException("host is null");
        }
        try (CTypeConversion.CCharPointerHolder hostPin = CTypeConversion.toCString((CharSequence)host);){
            CCharPointer hostname = hostPin.get();
            if (IsDefined.MACOSX() && (ret = Util_java_net_Inet6AddressImpl.lookupIfLocalhost(hostname, true)) != null) {
                InetAddress[] inetAddressArray = ret;
                return inetAddressArray;
            }
            LibC.memset(hints, WordFactory.signed((int)0), SizeOf.unsigned(Netdb.addrinfo.class));
            hints.set_ai_flags(Netdb.AI_CANONNAME());
            hints.set_ai_family(Socket.AF_UNSPEC());
            try {
                error = Netdb.getaddrinfo(hostname, (CCharPointer)WordFactory.nullPointer(), hints, resPtr);
                if (error != 0) {
                    throw new UnknownHostException(host);
                }
                res = resPtr.read();
                int i = 0;
                int inetCount = 0;
                int inet6Count = 0;
                int inetIndex = 0;
                int inet6Index = 0;
                int originalIndex = 0;
                Netdb.addrinfo last = (Netdb.addrinfo)WordFactory.nullPointer();
                Netdb.addrinfo iterator = res;
                while (true) {
                    Netdb.addrinfo itr;
                    boolean skip;
                    if (iterator.isNonNull()) {
                        skip = false;
                        itr = resNew;
                    } else {
                        retLen = i;
                        iterator = resNew;
                        ret = new InetAddress[retLen];
                        if (GraalServices.Java8OrEarlier) {
                            if (Target_java_net_InetAddress.preferIPv6AddressJDK8OrEarlier) {
                                inetIndex = inet6Count;
                                inet6Index = 0;
                                break;
                            }
                            inetIndex = 0;
                            inet6Index = inetCount;
                            break;
                        }
                        if (Target_java_net_InetAddress.preferIPv6AddressJDK9OrLater == Target_java_net_InetAddress.PREFER_IPV6_VALUE) {
                            inetIndex = inet6Count;
                            inet6Index = 0;
                            break;
                        }
                        if (Target_java_net_InetAddress.preferIPv6AddressJDK9OrLater == Target_java_net_InetAddress.PREFER_IPV4_VALUE) {
                            inetIndex = 0;
                            inet6Index = inetCount;
                            break;
                        }
                        if (Target_java_net_InetAddress.preferIPv6AddressJDK9OrLater != Target_java_net_InetAddress.PREFER_SYSTEM_VALUE) break;
                        inetIndex = 0;
                        inet6Index = 0;
                        originalIndex = 0;
                        break;
                    }
                    while (itr.isNonNull()) {
                        int t;
                        Object addr2;
                        Object addr1;
                        block60: {
                            block59: {
                                block57: {
                                    block58: {
                                        if (iterator.ai_family() != itr.ai_family() || iterator.ai_addrlen() != itr.ai_addrlen()) break block57;
                                        if (itr.ai_family() != Socket.AF_INET()) break block58;
                                        addr1 = (NetinetIn.sockaddr_in)((Object)iterator.ai_addr());
                                        addr2 = (NetinetIn.sockaddr_in)((Object)itr.ai_addr());
                                        if (addr1.sin_addr().s_addr() == addr2.sin_addr().s_addr()) {
                                            skip = true;
                                            break;
                                        }
                                        break block59;
                                    }
                                    addr1 = (NetinetIn.sockaddr_in6)((Object)iterator.ai_addr());
                                    addr2 = (NetinetIn.sockaddr_in6)((Object)itr.ai_addr());
                                    break block60;
                                }
                                if (iterator.ai_family() != Socket.AF_INET() && iterator.ai_family() != Socket.AF_INET6()) {
                                    skip = true;
                                    break;
                                }
                            }
                            itr = itr.ai_next();
                            continue;
                        }
                        for (t = 0; t < 16 && addr1.sin6_addr().s6_addr().read(t) == addr2.sin6_addr().s6_addr().read(t); ++t) {
                        }
                        if (t < 16) {
                            itr = itr.ai_next();
                            continue;
                        }
                        skip = true;
                        break;
                    }
                    if (!skip) {
                        Netdb.addrinfo next = (Netdb.addrinfo)LibC.malloc(SizeOf.unsigned(Netdb.addrinfo.class));
                        if (next.isNull()) {
                            throw new OutOfMemoryError("malloc failed");
                        }
                        LibC.memcpy(next, iterator, SizeOf.unsigned(Netdb.addrinfo.class));
                        next.set_ai_next((Netdb.addrinfo)WordFactory.nullPointer());
                        if (resNew.isNull()) {
                            resNew = next;
                        } else {
                            last.set_ai_next(next);
                        }
                        last = next;
                        ++i;
                        if (iterator.ai_family() == Socket.AF_INET()) {
                            ++inetCount;
                        } else if (iterator.ai_family() == Socket.AF_INET6()) {
                            ++inet6Count;
                        }
                    }
                    iterator = iterator.ai_next();
                }
                while (iterator.isNonNull()) {
                    if (iterator.ai_family() == Socket.AF_INET()) {
                        Inet4Address iaObj = Util_java_net_Inet4Address.new_Inet4Address();
                        JavaNetNetUtil.setInetAddress_addr(iaObj, NetinetIn.ntohl(((NetinetIn.sockaddr_in)((Object)iterator.ai_addr())).sin_addr().s_addr()));
                        JavaNetNetUtil.setInetAddress_hostName(iaObj, host);
                        ret[inetIndex | originalIndex] = iaObj;
                        ++inetIndex;
                    } else if (iterator.ai_family() == Socket.AF_INET6()) {
                        int scope = 0;
                        Inet6Address iaObj = Util_java_net_Inet6Address.new_Inet6Address();
                        if (iaObj == null) {
                            InetAddress[] inetAddressArray = ret = null;
                            return inetAddressArray;
                        }
                        int ret1 = JavaNetNetUtil.setInet6Address_ipaddress(iaObj, ((NetinetIn.sockaddr_in6)((Object)iterator.ai_addr())).sin6_addr().s6_addr());
                        if (!CTypeConversion.toBoolean((int)ret1)) {
                            InetAddress[] inetAddressArray = ret = null;
                            return inetAddressArray;
                        }
                        scope = ((NetinetIn.sockaddr_in6)((Object)iterator.ai_addr())).sin6_scope_id();
                        if (scope != 0) {
                            JavaNetNetUtil.setInet6Address_scopeid(iaObj, scope);
                        }
                        JavaNetNetUtil.setInetAddress_hostName(iaObj, host);
                        ret[inet6Index | originalIndex] = iaObj;
                        ++inet6Index;
                    }
                    if (!GraalServices.Java8OrEarlier && Target_java_net_InetAddress.preferIPv6AddressJDK9OrLater == Target_java_net_InetAddress.PREFER_SYSTEM_VALUE) {
                        ++originalIndex;
                        inetIndex = 0;
                        inet6Index = 0;
                    }
                    iterator = iterator.ai_next();
                }
                return ret;
            }
            finally {
                Netdb.addrinfo iterator = resNew;
                while (iterator.isNonNull()) {
                    Netdb.addrinfo tmp = iterator;
                    iterator = iterator.ai_next();
                    LibC.free(tmp);
                }
                Netdb.freeaddrinfo(res);
            }
        }
    }
}

