/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.RuntimeFeature;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.posix.PosixExecutableName;
import java.util.Arrays;
import java.util.List;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.ProcessProperties;

@Platforms(value={Platform.DARWIN.class})
public class DarwinExecutableName
extends PosixExecutableName {
    @Override
    public Object apply(Object[] args) {
        return ProcessProperties.getExecutableName();
    }

    @AutomaticFeature
    public static class ExposeExecutableNameFeature
    implements Feature {
        public List<Class<? extends Feature>> getRequiredFeatures() {
            return Arrays.asList(RuntimeFeature.class);
        }

        public void afterRegistration(Feature.AfterRegistrationAccess access) {
            RuntimeSupport rs = RuntimeSupport.getRuntimeSupport();
            rs.addCommandPlugin(new DarwinExecutableName());
        }
    }
}

