/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.headers;

import com.oracle.svm.core.posix.headers.PosixDirectives;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.struct.AllowNarrowingCast;
import org.graalvm.nativeimage.c.struct.AllowWideningCast;
import org.graalvm.nativeimage.c.struct.CField;
import org.graalvm.nativeimage.c.struct.CFieldAddress;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

@CContext(value=PosixDirectives.class)
public class Time {
    @CConstant
    public static native int CLOCKS_PER_SEC();

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int gettimeofday(timeval var0, timezone var1);

    @CFunction
    public static native int settimeofday(timeval var0, timezone var1);

    @CFunction
    public static native int adjtime(timeval var0, timeval var1);

    @CConstant
    public static native int ITIMER_REAL();

    @CConstant
    public static native int ITIMER_VIRTUAL();

    @CConstant
    public static native int ITIMER_PROF();

    @CFunction
    public static native int getitimer(int var0, itimerval var1);

    @CFunction
    public static native int setitimer(int var0, itimerval var1, itimerval var2);

    @CFunction
    public static native int utimes(CCharPointer var0, timeval var1);

    @CFunction
    public static native int lutimes(CCharPointer var0, timeval var1);

    @CFunction
    public static native int futimes(int var0, timeval var1);

    @CFunction
    public static native int futimesat(int var0, CCharPointer var1, timeval var2);

    @CFunction
    public static native long clock();

    @CFunction
    public static native long time(PointerBase var0);

    @CFunction
    public static native double difftime(long var0, long var2);

    @CFunction
    public static native long mktime(tm var0);

    @CFunction
    public static native UnsignedWord strftime(CCharPointer var0, UnsignedWord var1, CCharPointer var2, tm var3);

    @CFunction
    public static native CCharPointer strptime(CCharPointer var0, CCharPointer var1, tm var2);

    @CFunction
    public static native tm gmtime(PointerBase var0);

    @CFunction
    public static native tm localtime(PointerBase var0);

    @CFunction
    public static native tm gmtime_r(PointerBase var0, tm var1);

    @CFunction
    public static native tm localtime_r(PointerBase var0, tm var1);

    @CFunction
    public static native CCharPointer asctime(tm var0);

    @CFunction
    public static native CCharPointer ctime(PointerBase var0);

    @CFunction
    public static native CCharPointer asctime_r(tm var0, CCharPointer var1);

    @CFunction
    public static native CCharPointer ctime_r(PointerBase var0, CCharPointer var1);

    @CFunction
    public static native int stime(PointerBase var0);

    @CFunction
    public static native int nanosleep(timespec var0, timespec var1);

    @CStruct(addStructKeyword=true)
    public static interface tm
    extends PointerBase {
        @CField
        public int tm_sec();

        @CField
        public int tm_min();

        @CField
        public int tm_hour();

        @CField
        public int tm_mday();

        @CField
        public int tm_mon();

        @CField
        public int tm_year();

        @CField
        public int tm_wday();

        @CField
        public int tm_yday();

        @CField
        public int tm_isdst();

        @CField
        public long tm_gmtoff();

        @CField
        public CCharPointer tm_zone();
    }

    @CStruct(addStructKeyword=true)
    public static interface timespec
    extends PointerBase {
        @CField
        public long tv_sec();

        @CField
        public void set_tv_sec(long var1);

        @CField
        public long tv_nsec();

        @CField
        public void set_tv_nsec(long var1);
    }

    @CStruct(addStructKeyword=true)
    public static interface itimerval
    extends PointerBase {
        @CFieldAddress
        public timeval it_interval();

        @CFieldAddress
        public timeval it_value();
    }

    public static interface timezone
    extends PointerBase {
    }

    @CStruct(addStructKeyword=true)
    public static interface timeval
    extends PointerBase {
        @CField
        public long tv_sec();

        @CField
        public void set_tv_sec(long var1);

        @CField
        @AllowWideningCast
        public long tv_usec();

        @CField
        @AllowNarrowingCast
        public void set_tv_usec(long var1);

        public timeval addressOf(int var1);
    }
}

