/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.pthread;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.posix.headers.linux.LinuxTime;
import com.oracle.svm.core.util.TimeUtils;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.word.WordFactory;

public class PthreadConditionUtils {
    @Uninterruptible(reason="Called from uninterruptible code.")
    public static int initCondition(Pthread.pthread_cond_t cond) {
        Pthread.pthread_condattr_t attr = (Pthread.pthread_condattr_t)StackValue.get(Pthread.pthread_condattr_t.class);
        int status = Pthread.pthread_condattr_init(attr);
        if (status != 0) {
            return status;
        }
        if (Platform.includedIn(Platform.LINUX.class) && (status = Pthread.pthread_condattr_setclock(attr, LinuxTime.CLOCK_MONOTONIC())) != 0) {
            return status;
        }
        return Pthread.pthread_cond_init(cond, attr);
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    private static void getAbsoluteTimeNanos(Time.timespec result) {
        if (Platform.includedIn(Platform.LINUX.class)) {
            LinuxTime.clock_gettime(LinuxTime.CLOCK_MONOTONIC(), result);
        } else {
            Time.timeval tv = (Time.timeval)StackValue.get(Time.timeval.class);
            Time.gettimeofday(tv, (Time.timezone)WordFactory.nullPointer());
            result.set_tv_sec(tv.tv_sec());
            result.set_tv_nsec(TimeUtils.microsToNanos(tv.tv_usec()));
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    public static void delayNanosToDeadlineTimespec(long delayNanos, Time.timespec result) {
        Time.timespec currentTimespec = (Time.timespec)StackValue.get(Time.timespec.class);
        PthreadConditionUtils.getAbsoluteTimeNanos(currentTimespec);
        assert (delayNanos >= 0L);
        long sec = TimeUtils.addOrMaxValue(currentTimespec.tv_sec(), TimeUtils.divideNanosToSeconds(delayNanos));
        long nsec = currentTimespec.tv_nsec() + TimeUtils.remainderNanosToSeconds(delayNanos);
        if (nsec > 1000000000L) {
            sec = TimeUtils.addOrMaxValue(sec, 1L);
            nsec -= 1000000000L;
        }
        assert (nsec < 1000000000L);
        result.set_tv_sec(sec);
        result.set_tv_nsec(nsec);
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    public static long deadlineTimespecToDelayNanos(Time.timespec deadlineTimespec) {
        Time.timespec currentTimespec = (Time.timespec)StackValue.get(Time.timespec.class);
        PthreadConditionUtils.getAbsoluteTimeNanos(currentTimespec);
        return TimeUtils.addOrMaxValue(deadlineTimespec.tv_nsec() - currentTimespec.tv_nsec(), TimeUtils.secondsToNanos(deadlineTimespec.tv_sec() - currentTimespec.tv_sec()));
    }
}

