/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.pthread;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.posix.pthread.PthreadConditionUtils;
import com.oracle.svm.core.posix.pthread.PthreadVMLockSupport;
import com.oracle.svm.core.posix.pthread.PthreadVMMutex;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.word.UnsignedWord;

final class PthreadVMCondition
extends VMCondition {
    protected UnsignedWord structOffset;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected PthreadVMCondition(PthreadVMMutex mutex) {
        super(mutex);
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    protected Pthread.pthread_cond_t getStructPointer() {
        return (Pthread.pthread_cond_t)Word.objectToUntrackedPointer((Object)((PthreadVMLockSupport)ImageSingletons.lookup(PthreadVMLockSupport.class)).pthreadStructs).add(this.structOffset);
    }

    @Override
    public void block() {
        PthreadVMLockSupport.checkResult(Pthread.pthread_cond_wait(this.getStructPointer(), ((PthreadVMMutex)this.getMutex()).getStructPointer()), "pthread_cond_wait");
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.")
    public void blockNoTransition() {
        PthreadVMLockSupport.checkResult(Pthread.pthread_cond_wait_no_transition(this.getStructPointer(), ((PthreadVMMutex)this.getMutex()).getStructPointer()), "pthread_cond_wait");
    }

    @Override
    public long block(long waitNanos) {
        Time.timespec deadlineTimespec = (Time.timespec)StackValue.get(Time.timespec.class);
        PthreadConditionUtils.delayNanosToDeadlineTimespec(waitNanos, deadlineTimespec);
        int timedwaitResult = Pthread.pthread_cond_timedwait(this.getStructPointer(), ((PthreadVMMutex)this.getMutex()).getStructPointer(), deadlineTimespec);
        if (timedwaitResult == Errno.ETIMEDOUT()) {
            return 0L;
        }
        PthreadVMLockSupport.checkResult(timedwaitResult, "pthread_cond_timedwait");
        return PthreadConditionUtils.deadlineTimespecToDelayNanos(deadlineTimespec);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.")
    public long blockNoTransition(long waitNanos) {
        Time.timespec deadlineTimespec = (Time.timespec)StackValue.get(Time.timespec.class);
        PthreadConditionUtils.delayNanosToDeadlineTimespec(waitNanos, deadlineTimespec);
        int timedwaitResult = Pthread.pthread_cond_timedwait_no_transition(this.getStructPointer(), ((PthreadVMMutex)this.getMutex()).getStructPointer(), deadlineTimespec);
        if (timedwaitResult == Errno.ETIMEDOUT()) {
            return 0L;
        }
        PthreadVMLockSupport.checkResult(timedwaitResult, "pthread_cond_timedwait");
        return PthreadConditionUtils.deadlineTimespecToDelayNanos(deadlineTimespec);
    }

    @Override
    public void signal() {
        PthreadVMLockSupport.checkResult(Pthread.pthread_cond_signal(this.getStructPointer()), "pthread_cond_signal");
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.")
    public void broadcast() {
        PthreadVMLockSupport.checkResult(Pthread.pthread_cond_broadcast(this.getStructPointer()), "pthread_cond_broadcast");
    }
}

