/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.properties;

import java.util.Arrays;

public final class RuntimePropertyParser {
    private static final String PROPERTY_PREFIX = "-D";

    public static String[] parse(String[] args) {
        int newIdx = 0;
        for (int oldIdx = 0; oldIdx < args.length; ++oldIdx) {
            String arg = args[oldIdx];
            if (arg.startsWith(PROPERTY_PREFIX) && RuntimePropertyParser.parseProperty(arg.substring(PROPERTY_PREFIX.length()))) continue;
            assert (newIdx <= oldIdx);
            args[newIdx] = arg;
            ++newIdx;
        }
        if (newIdx == args.length) {
            return args;
        }
        return Arrays.copyOf(args, newIdx);
    }

    private static boolean parseProperty(String property) {
        int splitIndex = property.indexOf(61);
        if (splitIndex == -1) {
            return false;
        }
        String key = property.substring(0, splitIndex);
        String value = property.substring(splitIndex + 1);
        System.setProperty(key, value);
        return true;
    }
}

