/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.threadlocal;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.threadlocal.FastThreadLocal;
import com.oracle.svm.core.threadlocal.FastThreadLocalBytes;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.threadlocal.FastThreadLocalLong;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import com.oracle.svm.core.threadlocal.VMThreadLocalSTSupport;
import java.util.Arrays;
import java.util.Collection;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class VMThreadLocalInfos {
    private VMThreadLocalInfo[] infos;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean setInfos(Collection<VMThreadLocalInfo> infos) {
        VMThreadLocalInfos singleton = (VMThreadLocalInfos)ImageSingletons.lookup(VMThreadLocalInfos.class);
        Object[] array = infos.toArray(new VMThreadLocalInfo[infos.size()]);
        if (!Arrays.equals(singleton.infos, array)) {
            singleton.infos = array;
            return true;
        }
        return false;
    }

    public static void dumpToLog(Log log, IsolateThread thread) {
        for (VMThreadLocalInfo info : ((VMThreadLocalInfos)ImageSingletons.lookup(VMThreadLocalInfos.class)).infos) {
            log.signed(info.offset).string(" (").signed(info.sizeInBytes).string(" bytes): ").string(info.name).string(" = ");
            if (info.threadLocalClass == FastThreadLocalInt.class) {
                int value = VMThreadLocalInfos.primitiveData(thread).readInt((WordBase)WordFactory.signed((long)info.offset));
                log.string("(int) ").signed(value).string("  ").zhex(value);
            } else if (info.threadLocalClass == FastThreadLocalLong.class) {
                long value = VMThreadLocalInfos.primitiveData(thread).readLong((WordBase)WordFactory.signed((long)info.offset));
                log.string("(long) ").signed(value).string("  ").zhex(value);
            } else if (info.threadLocalClass == FastThreadLocalWord.class) {
                WordBase value = VMThreadLocalInfos.primitiveData(thread).readWord((WordBase)WordFactory.signed((long)info.offset));
                log.string("(Word) ").signed(value).string("  ").zhex(value.rawValue());
            } else if (info.threadLocalClass == FastThreadLocalObject.class) {
                Object value = ObjectAccess.readObject((Object)VMThreadLocalInfos.objectData(thread), (WordBase)WordFactory.signed((long)info.offset));
                log.string("(Object) ");
                if (value == null) {
                    log.string("null");
                } else {
                    log.string(value.getClass().getName()).string("  ").zhex(Word.objectToUntrackedPointer((Object)value).rawValue());
                }
            } else if (info.threadLocalClass == FastThreadLocalBytes.class) {
                log.string("(bytes) ").indent(true);
                log.hexdump((PointerBase)VMThreadLocalInfos.primitiveData(thread).add((UnsignedWord)WordFactory.signed((long)info.offset)), 8, info.sizeInBytes / 8);
                log.indent(false);
            } else {
                log.string("unknown class ").string(info.threadLocalClass.getName());
            }
            log.newline();
        }
    }

    @Uninterruptible(reason="called from uninterruptible code", mayBeInlined=true)
    private static Pointer primitiveData(IsolateThread thread) {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return (Pointer)thread;
        }
        return Word.objectToUntrackedPointer((Object)((VMThreadLocalSTSupport)ImageSingletons.lookup(VMThreadLocalSTSupport.class)).primitiveThreadLocals);
    }

    @Uninterruptible(reason="called from uninterruptible code", mayBeInlined=true)
    private static Object objectData(IsolateThread thread) {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return ((Pointer)thread).toObjectNonNull();
        }
        return ((VMThreadLocalSTSupport)ImageSingletons.lookup(VMThreadLocalSTSupport.class)).objectThreadLocals;
    }

    public static long getOffset(FastThreadLocal threadLocal) {
        VMThreadLocalInfos singleton = (VMThreadLocalInfos)ImageSingletons.lookup(VMThreadLocalInfos.class);
        for (VMThreadLocalInfo info : singleton.infos) {
            if (!threadLocal.getLocationIdentity().equals(info.locationIdentity)) continue;
            return info.offset;
        }
        return -1L;
    }
}

