/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.windows.headers.FileAPI;
import java.io.FileDescriptor;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@TargetClass(value=FileDescriptor.class)
@Platforms(value={Platform.WINDOWS.class})
final class Target_java_io_FileDescriptor {
    @Alias
    private long handle;

    Target_java_io_FileDescriptor() {
    }

    @Substitute
    private static long set(int handle) {
        if (handle == 0) {
            return FileAPI.GetStdHandle(FileAPI.STD_INPUT_HANDLE());
        }
        if (handle == 1) {
            return FileAPI.GetStdHandle(FileAPI.STD_OUTPUT_HANDLE());
        }
        if (handle == 2) {
            return FileAPI.GetStdHandle(FileAPI.STD_ERROR_HANDLE());
        }
        return -1L;
    }

    @Substitute
    public static FileDescriptor standardStream(int handle) {
        FileDescriptor desc = new FileDescriptor();
        KnownIntrinsics.unsafeCast((Object)desc, Target_java_io_FileDescriptor.class).handle = Target_java_io_FileDescriptor.set(handle);
        return desc;
    }
}

