/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.ParkEvent;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.windows.headers.SynchAPI;
import com.oracle.svm.core.windows.headers.WinBase;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.WINDOWS.class})
class WindowsParkEvent
extends ParkEvent {
    private final WinBase.HANDLE eventHandle = SynchAPI.CreateEventA(WordFactory.nullPointer(), 0, 0, WordFactory.nullPointer());

    WindowsParkEvent() {
        VMError.guarantee(this.eventHandle.rawValue() != 0L, "CreateEventA failed");
    }

    @Override
    protected ParkEvent.WaitResult condWait() {
        ParkEvent.WaitResult result = ParkEvent.WaitResult.UNPARKED;
        try {
            if (this.resetEventBeforeWait) {
                this.event = false;
            }
            while (!this.event) {
                if (Thread.interrupted()) {
                    result = ParkEvent.WaitResult.INTERRUPTED;
                    SynchAPI.ResetEvent(this.eventHandle);
                    ParkEvent.WaitResult waitResult = result;
                    return waitResult;
                }
                int status = SynchAPI.WaitForSingleObject(this.eventHandle, SynchAPI.INFINITE());
                if (status == SynchAPI.WAIT_OBJECT_0()) continue;
                Log.log().newline().string("WindowsParkEvent.condWait failed, status returned:  ").hex(status);
                Log.log().newline().string("GetLastError returned:  ").hex(WinBase.GetLastError()).newline();
                result = ParkEvent.WaitResult.INTERRUPTED;
                break;
            }
            if (this.event) {
                this.event = false;
                result = ParkEvent.WaitResult.UNPARKED;
            }
        }
        finally {
            SynchAPI.ResetEvent(this.eventHandle);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ParkEvent.WaitResult condTimedWait(long delayNanos) {
        int dwMilliseconds = (int)(delayNanos / 1000000L);
        ParkEvent.WaitResult result = ParkEvent.WaitResult.UNPARKED;
        try {
            if (this.resetEventBeforeWait) {
                this.event = false;
            }
            if (!this.event) {
                if (Thread.interrupted()) {
                    result = ParkEvent.WaitResult.INTERRUPTED;
                    SynchAPI.ResetEvent(this.eventHandle);
                    ParkEvent.WaitResult waitResult = result;
                    return waitResult;
                }
                int status = SynchAPI.WaitForSingleObject(this.eventHandle, dwMilliseconds);
                if (status != SynchAPI.WAIT_OBJECT_0()) {
                    if (status == SynchAPI.WAIT_TIMEOUT()) {
                        result = ParkEvent.WaitResult.TIMED_OUT;
                    } else {
                        Log.log().newline().string("WindowsParkEvent.condTimedWait failed, status returned:  ").hex(status);
                        Log.log().newline().string("GetLastError returned:  ").hex(WinBase.GetLastError()).newline();
                        result = ParkEvent.WaitResult.INTERRUPTED;
                    }
                }
            }
            if (this.event) {
                this.event = false;
                result = ParkEvent.WaitResult.UNPARKED;
            }
        }
        finally {
            SynchAPI.ResetEvent(this.eventHandle);
        }
        return result;
    }

    @Override
    protected void unpark() {
        this.event = true;
        SynchAPI.SetEvent(this.eventHandle);
    }
}

