/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.windows.WindowsVMLockSupport;
import com.oracle.svm.core.windows.WindowsVMMutex;
import com.oracle.svm.core.windows.headers.Process;
import com.oracle.svm.core.windows.headers.SynchAPI;
import com.oracle.svm.core.windows.headers.WinBase;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;

final class WindowsVMCondition
extends VMCondition {
    protected UnsignedWord structOffset;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected WindowsVMCondition(WindowsVMMutex mutex) {
        super(mutex);
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    protected Process.PCONDITION_VARIABLE getStructPointer() {
        return (Process.PCONDITION_VARIABLE)Word.objectToUntrackedPointer((Object)((WindowsVMLockSupport)ImageSingletons.lookup(WindowsVMLockSupport.class)).syncStructs).add(this.structOffset);
    }

    @Override
    public void block() {
        WindowsVMLockSupport.checkResult(Process.SleepConditionVariableCS(this.getStructPointer(), ((WindowsVMMutex)this.getMutex()).getStructPointer(), SynchAPI.INFINITE()), "SleepConditionVariableCS");
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.")
    public void blockNoTransition() {
        WindowsVMLockSupport.checkResult(Process.SleepConditionVariableCSNoTrans(this.getStructPointer(), ((WindowsVMMutex)this.getMutex()).getStructPointer(), SynchAPI.INFINITE()), "SleepConditionVariableCS");
    }

    @Override
    public long block(long waitNanos) {
        long startTimeInNanos = System.nanoTime();
        int dwMilliseconds = (int)(waitNanos / 1000000L);
        int timedwaitResult = Process.SleepConditionVariableCS(this.getStructPointer(), ((WindowsVMMutex)this.getMutex()).getStructPointer(), dwMilliseconds);
        if (timedwaitResult != 0 && WinBase.GetLastError() == WinBase.ERROR_TIMEOUT()) {
            return 0L;
        }
        WindowsVMLockSupport.checkResult(timedwaitResult, "SleepConditionVariableCS");
        long endTimeInNanos = System.nanoTime();
        if (endTimeInNanos < startTimeInNanos) {
            return 1L;
        }
        return endTimeInNanos - startTimeInNanos;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.")
    public long blockNoTransition(long waitNanos) {
        long startTimeInNanos = System.nanoTime();
        int dwMilliseconds = (int)(waitNanos / 1000000L);
        int timedwaitResult = Process.SleepConditionVariableCSNoTrans(this.getStructPointer(), ((WindowsVMMutex)this.getMutex()).getStructPointer(), dwMilliseconds);
        if (timedwaitResult != 0 && WinBase.GetLastError() == WinBase.ERROR_TIMEOUT()) {
            return 0L;
        }
        WindowsVMLockSupport.checkResult(timedwaitResult, "SleepConditionVariableCSNoTrans");
        long endTimeInNanos = System.nanoTime();
        if (endTimeInNanos < startTimeInNanos) {
            return 1L;
        }
        return endTimeInNanos - startTimeInNanos;
    }

    @Override
    public void signal() {
        Process.WakeConditionVariable(this.getStructPointer());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.")
    public void broadcast() {
        Process.WakeAllConditionVariable(this.getStructPointer());
    }
}

