/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.ameta;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.meta.ReadableJavaField;
import com.oracle.svm.hosted.ClassInitializationFeature;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.ameta.AnalysisConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.core.common.spi.JavaConstantFieldProvider;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class AnalysisConstantFieldProvider
extends JavaConstantFieldProvider {
    private final AnalysisUniverse universe;
    private final AnalysisConstantReflectionProvider constantReflection;
    private final ClassInitializationFeature classInitializationFeature;

    public AnalysisConstantFieldProvider(AnalysisUniverse universe, MetaAccessProvider metaAccess, AnalysisConstantReflectionProvider constantReflection) {
        super(metaAccess);
        this.universe = universe;
        this.constantReflection = constantReflection;
        this.classInitializationFeature = ClassInitializationFeature.singleton();
    }

    public <T> T readConstantField(ResolvedJavaField field, ConstantFieldProvider.ConstantFieldTool<T> analysisTool) {
        AnalysisField f = (AnalysisField)field;
        if (SVMHost.isUnknownObjectField((ResolvedJavaField)f) || SVMHost.isUnknownPrimitiveField(f)) {
            return null;
        }
        if (f.wrapped instanceof ReadableJavaField) {
            JavaConstant fieldValue;
            ReadableJavaField readableField = (ReadableJavaField)f.wrapped;
            if (readableField.allowConstantFolding() && (fieldValue = readableField.readValue(this.universe.toHosted(analysisTool.getReceiver()))) != null) {
                return (T)analysisTool.foldConstant(this.constantReflection.interceptValue(f, this.universe.lookup(fieldValue)));
            }
            return null;
        }
        return (T)super.readConstantField(field, analysisTool);
    }

    protected boolean isFinalField(ResolvedJavaField field, ConstantFieldProvider.ConstantFieldTool<?> tool) {
        if (this.classInitializationFeature.shouldInitializeAtRuntime(field.getDeclaringClass())) {
            return false;
        }
        return super.isFinalField(field, tool);
    }
}

