/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.svm.core.util.VMError;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.SpeculationLog;

public abstract class CustomSubstitutionMethod
implements ResolvedJavaMethod,
GraphProvider {
    protected final ResolvedJavaMethod original;

    public CustomSubstitutionMethod(ResolvedJavaMethod original) {
        this.original = original;
    }

    public ResolvedJavaMethod getOriginal() {
        return this.original;
    }

    public String getName() {
        return this.original.getName();
    }

    public Signature getSignature() {
        return this.original.getSignature();
    }

    public byte[] getCode() {
        return null;
    }

    public int getCodeSize() {
        return 0;
    }

    public ResolvedJavaType getDeclaringClass() {
        return this.original.getDeclaringClass();
    }

    public int getMaxLocals() {
        return this.getSignature().getParameterCount(true) + 2;
    }

    public int getMaxStackSize() {
        return 2;
    }

    public int getModifiers() {
        return this.original.getModifiers();
    }

    public boolean isSynthetic() {
        return this.original.isSynthetic();
    }

    public boolean isVarArgs() {
        return this.original.isVarArgs();
    }

    public boolean isBridge() {
        return this.original.isBridge();
    }

    public boolean isDefault() {
        return this.original.isDefault();
    }

    public boolean isClassInitializer() {
        return this.original.isClassInitializer();
    }

    public boolean isConstructor() {
        return this.original.isConstructor();
    }

    public boolean canBeStaticallyBound() {
        return this.original.canBeStaticallyBound();
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return new ExceptionHandler[0];
    }

    public StackTraceElement asStackTraceElement(int bci) {
        return this.original.asStackTraceElement(0);
    }

    public ProfilingInfo getProfilingInfo(boolean includeNormal, boolean includeOSR) {
        throw VMError.shouldNotReachHere();
    }

    public void reprofile() {
    }

    public ConstantPool getConstantPool() {
        return this.original.getConstantPool();
    }

    public Annotation[] getAnnotations() {
        return this.original.getAnnotations();
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.original.getDeclaredAnnotations();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.original.getAnnotation(annotationClass);
    }

    public Annotation[][] getParameterAnnotations() {
        return this.original.getParameterAnnotations();
    }

    public Type[] getGenericParameterTypes() {
        return this.original.getGenericParameterTypes();
    }

    public boolean canBeInlined() {
        return this.original.canBeInlined();
    }

    public boolean hasNeverInlineDirective() {
        return this.original.hasNeverInlineDirective();
    }

    public boolean shouldBeInlined() {
        return this.original.shouldBeInlined();
    }

    public LineNumberTable getLineNumberTable() {
        return null;
    }

    public LocalVariableTable getLocalVariableTable() {
        return null;
    }

    public Constant getEncoding() {
        throw VMError.shouldNotReachHere();
    }

    public boolean isInVirtualMethodTable(ResolvedJavaType resolved) {
        throw VMError.shouldNotReachHere();
    }

    public SpeculationLog getSpeculationLog() {
        throw VMError.shouldNotReachHere();
    }
}

