/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.codegen;

import com.oracle.svm.core.c.NativeImageHeaderPreamble;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.c.codegen.CSourceCodeWriter;
import com.oracle.svm.hosted.c.info.ConstantInfo;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.EnumConstantInfo;
import com.oracle.svm.hosted.c.info.InfoTreeVisitor;
import com.oracle.svm.hosted.c.info.NativeCodeInfo;
import com.oracle.svm.hosted.c.info.PointerToInfo;
import com.oracle.svm.hosted.c.info.RawStructureInfo;
import com.oracle.svm.hosted.c.info.SizableInfo;
import com.oracle.svm.hosted.c.info.StructBitfieldInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.c.info.StructInfo;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graalvm.nativeimage.Platform;

public class QueryCodeWriter
extends InfoTreeVisitor {
    private static final String FORMATOR_SIGNED_LONG = "%ld";
    private static final String FORMATOR_UNSIGNED_LONG = "%lu";
    private static final String FORMATOR_LONG_HEX = "%lX";
    private static final String FORMATOR_FLOAT = "%.15e";
    private static final String FORMATOR_STRING = "$%s$";
    private final CSourceCodeWriter writer;
    private final List<Object> elementForLineNumber;
    private int tempVarCounter;

    public QueryCodeWriter(Path tempDirectory) {
        this.writer = new CSourceCodeWriter(tempDirectory);
        this.elementForLineNumber = new ArrayList<Object>();
    }

    public Path write(NativeCodeInfo nativeCodeInfo) {
        nativeCodeInfo.accept(this);
        String srcFileExtension = Platform.includedIn(Platform.WINDOWS.class) ? ".cpp" : ".c";
        String sourceFileName = nativeCodeInfo.getName().replaceAll("\\W", "_").concat(srcFileExtension);
        return this.writer.writeFile(sourceFileName);
    }

    public Object getElementForLineNumber(int lineNumber) {
        int index = lineNumber - 1;
        if (index >= 0 && index < this.elementForLineNumber.size()) {
            return this.elementForLineNumber.get(index);
        }
        return null;
    }

    public String getLine(int lineNumber) {
        return this.writer.getLine(lineNumber);
    }

    @Override
    protected void visitNativeCodeInfo(NativeCodeInfo nativeCodeInfo) {
        NativeImageHeaderPreamble.read(this.getClass().getClassLoader(), "graal_isolate.preamble").forEach(this.writer::appendln);
        for (String preDefine : nativeCodeInfo.getDirectives().getMacroDefinitions()) {
            this.writer.appendMacroDefinition(preDefine);
        }
        if (!nativeCodeInfo.isBuiltin()) {
            this.writer.includeFiles(nativeCodeInfo.getDirectives().getHeaderFiles());
        }
        this.writer.includeFiles(Arrays.asList("<stdio.h>", "<stddef.h>", "<memory.h>"));
        QueryCodeWriter.writeCStandardHeaders(this.writer);
        this.writer.appendln();
        this.writer.appendln("#ifndef _WIN64");
        this.writer.appendln("#define ISUNSIGNED(a) ((a) >= 0L && (typeof(a)) ~(a) >= 0L)");
        this.writer.appendln("#else");
        this.writer.appendln("#define ISUNSIGNED(a) ((a) >= 0L && (decltype(a)) ~(a) >= 0L)");
        this.writer.appendln("#endif");
        this.writer.appendln("#define IS_CONST_UNSIGNED(a) (a>=0 ? 1 : 0)");
        this.writer.appendln();
        this.writer.appendln("int main(void) {");
        this.writer.indent();
        this.processChildren(nativeCodeInfo);
        this.writer.indents().appendln("return 0;");
        this.writer.outdent();
        this.writer.appendln("}");
    }

    public static void writeCStandardHeaders(CSourceCodeWriter writer) {
        if (NativeImageOptions.getCStandard().compatibleWith(NativeImageOptions.CStandards.C99)) {
            writer.includeFiles(Collections.singletonList("<stdbool.h>"));
        }
        if (NativeImageOptions.getCStandard().compatibleWith(NativeImageOptions.CStandards.C11)) {
            writer.includeFiles(Collections.singletonList("<stdint.h>"));
        }
    }

    @Override
    protected void visitConstantInfo(ConstantInfo constantInfo) {
        switch (constantInfo.getKind()) {
            case INTEGER: {
                this.printUnsignedLong(constantInfo.getSizeInfo(), QueryCodeWriter.sizeOf(constantInfo));
                this.printIsUnsigned(constantInfo.getSignednessInfo(), QueryCodeWriter.isConstUnsigned(constantInfo.getName()));
                this.printLongHex(constantInfo.getValueInfo(), constantInfo.getName());
                break;
            }
            case POINTER: {
                this.printUnsignedLong(constantInfo.getSizeInfo(), QueryCodeWriter.sizeOf(constantInfo));
                this.printLongHex(constantInfo.getValueInfo(), constantInfo.getName());
                break;
            }
            case FLOAT: {
                this.printUnsignedLong(constantInfo.getSizeInfo(), QueryCodeWriter.sizeOf(constantInfo));
                this.printFloat(constantInfo.getValueInfo(), constantInfo.getName());
                break;
            }
            case BYTEARRAY: 
            case STRING: {
                this.printString(constantInfo.getValueInfo(), constantInfo.getName());
                break;
            }
            default: {
                throw VMError.shouldNotReachHere();
            }
        }
    }

    @Override
    protected void visitStructInfo(StructInfo structInfo) {
        if (!structInfo.isIncomplete()) {
            this.printUnsignedLong(structInfo.getSizeInfo(), QueryCodeWriter.sizeOf(structInfo));
        }
        this.processChildren(structInfo);
    }

    @Override
    protected void visitRawStructureInfo(RawStructureInfo info) {
    }

    @Override
    protected void visitStructFieldInfo(StructFieldInfo fieldInfo) {
        this.printUnsignedLong(fieldInfo.getSizeInfo(), QueryCodeWriter.sizeOfField(fieldInfo));
        this.printUnsignedLong(fieldInfo.getOffsetInfo(), QueryCodeWriter.offsetOfField(fieldInfo));
        if (fieldInfo.getKind() == SizableInfo.ElementKind.INTEGER) {
            String tempVar = this.getUniqueTempVarName(fieldInfo.getParent());
            this.registerElementForCurrentLine(fieldInfo.getParent().getAnnotatedElement());
            this.writer.indents().appendln("{");
            this.writer.indent();
            this.writer.indents().appendln(fieldInfo.getParent().getName() + " " + tempVar + ";");
            this.printIsUnsigned(fieldInfo.getSignednessInfo(), QueryCodeWriter.isUnsigned(tempVar + "." + fieldInfo.getName()));
            this.writer.outdent();
            this.writer.indents().appendln("}");
        }
    }

    @Override
    protected void visitStructBitfieldInfo(StructBitfieldInfo bitfieldInfo) {
        String structName = bitfieldInfo.getParent().getName();
        String bitfieldName = bitfieldInfo.getName();
        this.writer.indents().appendln("{");
        this.writer.indent();
        this.writer.indents().appendln("struct _w {");
        this.registerElementForCurrentLine(bitfieldInfo.getParent().getAnnotatedElement());
        this.writer.indents().appendln("  " + structName + " s;");
        this.writer.indents().appendln("  long long int pad;");
        this.writer.indents().appendln("} w;");
        this.writer.indents().appendln("int is_unsigned;");
        this.writer.indents().appendln("char *p;");
        this.writer.indents().appendln("unsigned int byte_offset;");
        this.writer.indents().appendln("int start_bit, end_bit;");
        this.writer.indents().appendln("unsigned long long int v;");
        this.writer.indents().appendln("memset(&w, 0x0, sizeof(w));");
        this.registerElementForCurrentLine(bitfieldInfo.getAnnotatedElement());
        this.writer.indents().appendln("w.s." + bitfieldName + " = 0xffffffffffffffff;");
        this.writer.indents().appendln("is_unsigned =  (w.s." + bitfieldName + " >= 0);");
        this.writer.indents().appendln("p = (char*)&w.s;");
        this.writer.indents().appendln("byte_offset = 0;");
        this.writer.indents().appendln("while (byte_offset < sizeof(w.s) && *(p + byte_offset) == 0) {");
        this.writer.indents().appendln("  byte_offset++;");
        this.writer.indents().appendln("}");
        this.writer.indents().appendln("start_bit = 0, end_bit = 0;");
        this.writer.indents().appendln("if (byte_offset >= sizeof(w.s)) {");
        this.writer.indents().appendln("  start_bit = end_bit = -1;");
        this.writer.indents().appendln("} else {");
        this.writer.indents().appendln("  v = *((unsigned long long int*) (p + byte_offset));");
        this.writer.indents().appendln("  while ((v & 0x1) == 0) {");
        this.writer.indents().appendln("    start_bit++;");
        this.writer.indents().appendln("    v = v >> 1;");
        this.writer.indents().appendln("  }");
        this.writer.indents().appendln("  end_bit = start_bit;");
        this.writer.indents().appendln("  while (v != 1) {");
        this.writer.indents().appendln("    end_bit++;");
        this.writer.indents().appendln("    v = v >> 1;");
        this.writer.indents().appendln("  }");
        this.writer.indents().appendln("}");
        this.printUnsignedLong(bitfieldInfo.getByteOffsetInfo(), "byte_offset");
        this.printSignedLong(bitfieldInfo.getStartBitInfo(), "start_bit");
        this.printSignedLong(bitfieldInfo.getEndBitInfo(), "end_bit");
        this.printIsUnsigned(bitfieldInfo.getSignednessInfo(), "is_unsigned");
        this.writer.outdent();
        this.writer.indents().appendln("}");
    }

    @Override
    protected void visitPointerToInfo(PointerToInfo pointerToInfo) {
        this.printUnsignedLong(pointerToInfo.getSizeInfo(), QueryCodeWriter.sizeOf(pointerToInfo));
        if (pointerToInfo.getKind() == SizableInfo.ElementKind.INTEGER) {
            String tempVar = this.getUniqueTempVarName(pointerToInfo);
            this.registerElementForCurrentLine(pointerToInfo.getAnnotatedElement());
            this.writer.indents().appendln("{");
            this.writer.indent();
            this.writer.indents().appendln(pointerToInfo.getName() + " " + tempVar + ";");
            this.printIsUnsigned(pointerToInfo.getSignednessInfo(), QueryCodeWriter.isUnsigned(tempVar));
            this.writer.outdent();
            this.writer.indents().appendln("}");
        }
    }

    @Override
    protected void visitEnumConstantInfo(EnumConstantInfo constantInfo) {
        assert (constantInfo.getKind() == SizableInfo.ElementKind.INTEGER);
        this.printUnsignedLong(constantInfo.getSizeInfo(), QueryCodeWriter.sizeOf(constantInfo));
        this.printIsUnsigned(constantInfo.getSignednessInfo(), QueryCodeWriter.isConstUnsigned(constantInfo.getName()));
        this.printLongHex(constantInfo.getValueInfo(), constantInfo.getName());
    }

    private void printString(ElementInfo info, String arg) {
        this.registerElementForCurrentLine(info.getAnnotatedElement());
        this.writer.indents().printf(info.getUniqueID() + "=" + FORMATOR_STRING, arg).semicolon();
    }

    private void printLongHex(ElementInfo info, String arg) {
        this.registerElementForCurrentLine(info.getAnnotatedElement());
        this.writer.indents().printf(info.getUniqueID() + "=" + FORMATOR_LONG_HEX, arg).semicolon();
    }

    private void printSignedLong(ElementInfo info, String arg) {
        this.registerElementForCurrentLine(info.getAnnotatedElement());
        this.writer.indents().printf(info.getUniqueID() + "=" + FORMATOR_SIGNED_LONG, arg).semicolon();
    }

    private void printUnsignedLong(ElementInfo info, String arg) {
        this.registerElementForCurrentLine(info.getAnnotatedElement());
        this.writer.indents().printf(info.getUniqueID() + "=" + FORMATOR_UNSIGNED_LONG, arg).semicolon();
    }

    private void printFloat(ElementInfo info, String arg) {
        this.registerElementForCurrentLine(info.getAnnotatedElement());
        this.writer.indents().printf(info.getUniqueID() + "=" + FORMATOR_FLOAT, arg).semicolon();
    }

    private void printIsUnsigned(ElementInfo info, String arg) {
        this.printString(info, "(" + arg + ") ? \"" + SizableInfo.SignednessValue.UNSIGNED.name() + "\" : \"" + SizableInfo.SignednessValue.SIGNED.name() + "\"");
    }

    private String getUniqueTempVarName(ElementInfo info) {
        ++this.tempVarCounter;
        return "tmp_" + info.getName().replaceAll("\\W", "_") + "_" + this.tempVarCounter;
    }

    private static String sizeOf(ElementInfo element) {
        String elementName = element.getName();
        return elementName.equals("void") ? "1" : "sizeof(" + elementName + ")";
    }

    private static String sizeOfField(StructFieldInfo field) {
        return "sizeof(((" + field.getParent().getName() + " *) 0)->" + field.getName() + ")";
    }

    private static String offsetOfField(StructFieldInfo field) {
        return "offsetof(" + field.getParent().getName() + ", " + field.getName() + ")";
    }

    private static String isUnsigned(String symbolName) {
        return "ISUNSIGNED(" + symbolName + ")";
    }

    private static String isConstUnsigned(String symbolName) {
        return "IS_CONST_UNSIGNED(" + symbolName + ")";
    }

    private void registerElementForCurrentLine(Object element) {
        assert (element != null);
        int currentLineNumber = this.writer.currentLineNumber();
        while (this.elementForLineNumber.size() <= currentLineNumber) {
            this.elementForLineNumber.add(null);
        }
        assert (this.elementForLineNumber.get(currentLineNumber) == null) : "element already registered for this line";
        this.elementForLineNumber.set(currentLineNumber, element);
    }
}

