/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.info;

import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.InfoTreeVisitor;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class AccessorInfo
extends ElementInfo {
    private final ResolvedJavaMethod annotatedMethod;
    private final AccessorKind accessorKind;
    private final boolean isIndexed;
    private final boolean hasLocationIdentityParameter;
    private final boolean hasUniqueLocationIdentity;

    public AccessorInfo(ResolvedJavaMethod annotatedMethod, AccessorKind accessorKind, boolean isIndexed, boolean hasLocationIdentityParameter, boolean hasUniqueLocationIdentity) {
        super(annotatedMethod.getName());
        this.annotatedMethod = annotatedMethod;
        this.accessorKind = accessorKind;
        this.isIndexed = isIndexed;
        this.hasLocationIdentityParameter = hasLocationIdentityParameter;
        this.hasUniqueLocationIdentity = hasUniqueLocationIdentity;
    }

    public AccessorKind getAccessorKind() {
        return this.accessorKind;
    }

    public boolean isIndexed() {
        return this.isIndexed;
    }

    public boolean hasLocationIdentityParameter() {
        return this.hasLocationIdentityParameter;
    }

    public boolean hasUniqueLocationIdentity() {
        return this.hasUniqueLocationIdentity;
    }

    public int baseParameterNumber(boolean withReceiver) {
        assert (withReceiver);
        return 0;
    }

    public int indexParameterNumber(boolean withReceiver) {
        assert (this.isIndexed());
        return withReceiver ? 1 : 0;
    }

    public int valueParameterNumber(boolean withReceiver) {
        assert (this.accessorKind == AccessorKind.SETTER);
        return (withReceiver ? 1 : 0) + (this.isIndexed() ? 1 : 0);
    }

    public int locationIdentityParameterNumber(boolean withReceiver) {
        assert (this.hasLocationIdentityParameter());
        return this.parameterCount(withReceiver) - 1;
    }

    public int parameterCount(boolean withReceiver) {
        return (withReceiver ? 1 : 0) + (this.isIndexed() ? 1 : 0) + (this.getAccessorKind() == AccessorKind.SETTER ? 1 : 0) + (this.hasLocationIdentityParameter() ? 1 : 0);
    }

    @Override
    public Object getAnnotatedElement() {
        return this.annotatedMethod;
    }

    @Override
    public void accept(InfoTreeVisitor visitor) {
        visitor.visitAccessorInfo(this);
    }

    public static enum AccessorKind {
        GETTER,
        SETTER,
        ADDRESS,
        OFFSET;

    }
}

