/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CFunction;

public final class CFunctionLinkages {
    private final Map<String, CGlobalDataInfo> nameToFunction = new ConcurrentHashMap<String, CGlobalDataInfo>();

    public static CFunctionLinkages singleton() {
        return (CFunctionLinkages)ImageSingletons.lookup(CFunctionLinkages.class);
    }

    CFunctionLinkages() {
    }

    public CGlobalDataInfo addOrLookupMethod(ResolvedJavaMethod method) {
        if (method.getAnnotation(Node.NodeIntrinsic.class) != null || method.getAnnotation(Word.Operation.class) != null) {
            return null;
        }
        return this.nameToFunction.computeIfAbsent(CFunctionLinkages.linkageName(method), symbolName -> {
            CGlobalData linkage = CGlobalDataFactory.forSymbol(symbolName);
            return CGlobalDataFeature.singleton().registerAsAccessed(linkage);
        });
    }

    private static String linkageName(ResolvedJavaMethod method) {
        CFunction functionAnnotation = (CFunction)method.getAnnotation(CFunction.class);
        if (functionAnnotation != null && functionAnnotation.value().length() > 0) {
            return functionAnnotation.value();
        }
        return method.getName();
    }
}

