/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.graal.meta.SubstrateReplacements;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;

public class HostedReplacements
extends SubstrateReplacements {
    private final HostedUniverse hUniverse;
    private final SubstrateReplacements aReplacements;

    public HostedReplacements(HostedUniverse hUniverse, Providers providers, SnippetReflectionProvider snippetReflection, TargetDescription target, HostedProviders anaylysisProviders, BytecodeProvider bytecodeProvider, OptionValues options) {
        super(options, providers, snippetReflection, bytecodeProvider, target, null);
        this.hUniverse = hUniverse;
        this.aReplacements = (SubstrateReplacements)anaylysisProviders.getReplacements();
    }

    @Override
    public void registerSnippet(ResolvedJavaMethod m, boolean trackNodeSourcePosition) {
        assert (this.aReplacements.getSnippet((ResolvedJavaMethod)((HostedMethod)m).wrapped, null, null, trackNodeSourcePosition, null) != null);
    }

    @Override
    public void encodeSnippets() {
        super.copyFrom(this.aReplacements, this::replaceAnalysisObjects);
    }

    private Object replaceAnalysisObjects(Object obj) {
        if (obj == null) {
            return obj;
        }
        if (obj instanceof JavaType) {
            return this.hUniverse.lookup((JavaType)obj);
        }
        if (obj instanceof JavaMethod) {
            return this.hUniverse.lookup((JavaMethod)obj);
        }
        if (obj instanceof JavaField) {
            return this.hUniverse.lookup((JavaField)obj);
        }
        if (obj.getClass() == ObjectStamp.class) {
            if (((ObjectStamp)obj).type() == null) {
                return obj;
            }
            ObjectStamp stamp = (ObjectStamp)obj;
            return new ObjectStamp((ResolvedJavaType)this.replaceAnalysisObjects(stamp.type()), stamp.isExactType(), stamp.nonNull(), stamp.alwaysNull());
        }
        if (obj.getClass() == PiNode.PlaceholderStamp.class) {
            assert (((PiNode.PlaceholderStamp)obj).type() == null) : "PlaceholderStamp never references a type";
            return obj;
        }
        if (obj instanceof AbstractObjectStamp) {
            throw VMError.shouldNotReachHere("missing replacement of a subclass of AbstractObjectStamp: " + obj.getClass().getTypeName());
        }
        assert (!obj.getClass().getName().toLowerCase().contains("analysis"));
        assert (!obj.getClass().getName().toLowerCase().contains("pointsto"));
        return obj;
    }
}

