/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInterface;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.util.ArrayList;
import java.util.Arrays;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;

public class HostedInstanceClass
extends HostedClass {
    protected HostedField[] instanceFields;
    protected int instanceSize;
    protected boolean monitorFieldNeeded = false;
    protected int monitorFieldOffset = 0;
    protected boolean waitNotifyConditionFieldNeeded = false;
    protected int waitNotifyConditionFieldOffset = 0;
    protected boolean hashCodeFieldNeeded = false;
    protected int hashCodeFieldOffset = 0;

    public HostedInstanceClass(HostedUniverse universe, AnalysisType wrapped, JavaKind kind, JavaKind storageKind, HostedClass superClass, HostedInterface[] interfaces, boolean isCloneable) {
        super(universe, wrapped, kind, storageKind, superClass, interfaces, isCloneable);
    }

    public boolean isInstanceClass() {
        assert (this.wrapped.isInstanceClass());
        return true;
    }

    public boolean isArray() {
        assert (!this.wrapped.isArray());
        return false;
    }

    @Override
    public final HostedType getComponentType() {
        return null;
    }

    @Override
    public HostedType getBaseType() {
        return this;
    }

    @Override
    public int getArrayDimension() {
        return 0;
    }

    @Override
    public HostedField[] getInstanceFields(boolean includeSuperclasses) {
        assert (this.instanceFields != null);
        if (includeSuperclasses && this.getSuperclass() != null) {
            ArrayList<HostedField> fields = new ArrayList<HostedField>();
            fields.addAll(Arrays.asList(this.getSuperclass().getInstanceFields(true)));
            fields.addAll(Arrays.asList(this.instanceFields));
            return fields.toArray(new HostedField[fields.size()]);
        }
        return this.instanceFields;
    }

    @Override
    public ResolvedJavaField findInstanceFieldWithOffset(long offset, JavaKind expectedKind) {
        assert (offset >= 0L);
        for (HostedField field : this.instanceFields) {
            if ((long)field.getLocation() != offset || expectedKind != null && field.getStorageKind() != expectedKind) continue;
            return field;
        }
        if (this.getSuperclass() != null) {
            return this.getSuperclass().findInstanceFieldWithOffset(offset, expectedKind);
        }
        return null;
    }

    public int getInstanceSize() {
        return this.instanceSize;
    }

    public boolean needMonitorField() {
        return this.monitorFieldNeeded;
    }

    public void setNeedMonitorField() {
        this.monitorFieldNeeded = true;
    }

    public int getMonitorFieldOffset() {
        return this.monitorFieldOffset;
    }

    public void setMonitorFieldOffset(int monitorFieldOffset) {
        assert (this.monitorFieldOffset == 0) : "setting monitor field offset twice";
        this.monitorFieldOffset = monitorFieldOffset;
    }

    public boolean needHashCodeField() {
        return this.hashCodeFieldNeeded;
    }

    public void setNeedHashCodeField() {
        this.hashCodeFieldNeeded = true;
    }

    public int getHashCodeFieldOffset() {
        return this.hashCodeFieldOffset;
    }

    public void setHashCodeFieldOffset(int hashCodeFieldOffset) {
        assert (this.hashCodeFieldOffset == 0) : "setting hash code field offset twice";
        this.hashCodeFieldOffset = hashCodeFieldOffset;
    }
}

