/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.core.graal.meta.SharedRuntimeMethod;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.GraalSupport;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.graph.SourceLanguagePositionProvider;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.LoopExplosionPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;
import org.graalvm.compiler.nodes.spi.StampProvider;
import org.graalvm.compiler.replacements.PEGraphDecoder;

public class SubstratePEGraphDecoder
extends PEGraphDecoder {
    private final EconomicMap<ResolvedJavaMethod, EncodedGraph> graphCache = EconomicMap.create();

    public SubstratePEGraphDecoder(Architecture architecture, StructuredGraph graph, MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection, ConstantFieldProvider constantFieldProvider, StampProvider stampProvider, LoopExplosionPlugin loopExplosionPlugin, InvocationPlugins invocationPlugins, InlineInvokePlugin[] inlineInvokePlugins, ParameterPlugin parameterPlugin, NodePlugin[] nodePlugins, ResolvedJavaMethod callInlinedMethod, SourceLanguagePositionProvider sourceLanguagePosition) {
        super(architecture, graph, metaAccess, constantReflection, constantFieldProvider, stampProvider, loopExplosionPlugin, invocationPlugins, inlineInvokePlugins, parameterPlugin, nodePlugins, callInlinedMethod, sourceLanguagePosition);
    }

    protected EncodedGraph lookupEncodedGraph(ResolvedJavaMethod method, ResolvedJavaMethod originalMethod, BytecodeProvider intrinsicBytecodeProvider, boolean isSubstitution, boolean trackNodeSourcePosition) {
        EncodedGraph result = (EncodedGraph)this.graphCache.get((Object)method);
        if (result == null) {
            result = this.createGraph(method, trackNodeSourcePosition);
        }
        return result;
    }

    private EncodedGraph createGraph(ResolvedJavaMethod method, boolean trackNodeSourcePosition) {
        EncodedGraph result = GraalSupport.encodedGraph((SharedRuntimeMethod)method, trackNodeSourcePosition);
        if (result == null) {
            throw VMError.shouldNotReachHere("Graph not available for runtime compilation: " + method.format("%H.%n(%p)"));
        }
        this.graphCache.put((Object)method, (Object)result);
        return result;
    }
}

